/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.io;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractTypedController;
import com.sap.jvm.profiling.controller.impl.model.io.CalledUtils;
import com.sap.jvm.profiling.controller.model.IncludeType;
import com.sap.jvm.profiling.controller.model.io.CalledDetailedFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledFilterStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledFilterTreeController;
import com.sap.jvm.profiling.controller.model.io.CalledIOController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticByClassController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticByClassLoaderController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticByPackageController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticByPackageTreeController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodTreeController;
import com.sap.jvm.profiling.controller.model.io.CalledOpenFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledTimeSeriesController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodStatisticController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.io.DetailedFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.FileStatisticController;
import com.sap.jvm.profiling.controller.model.io.OpenFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.ThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.io.ThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.io.ThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.io.TimeSeriesController;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public abstract class AbstractCalledController<R extends ResourceController<M>, M extends TypedModel>
extends AbstractTypedController<M>
implements CalledIOController<M, R> {
    private final boolean isCalled;

    protected AbstractCalledController(ResourceName name, ProgressReporter reporter, boolean isCalled) throws IOException {
        super(name, reporter);
        this.isCalled = isCalled;
    }

    @Override
    public FileStatisticController getSelectedFileStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getFileStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public OpenFileStatisticController getSelectedOpenFileStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getOpenFileStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledFileStatisticController getSelectedCalledFileStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledFileStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledOpenFileStatisticController getSelectedCalledOpenFileStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledOpenFileStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledDetailedFileStatisticController getSelectedCalledDetailedFileStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledDetailedFileStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledMethodStatisticController asCalledMethodStatistic() throws IOException {
        return CalledUtils.asCalledMethodStatistic(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByClassController asCalledMethodStatisticByClass() throws IOException {
        return CalledUtils.asCalledMethodStatisticByClass(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByClassLoaderController asCalledMethodStatisticByClassLoader() throws IOException {
        return CalledUtils.asCalledMethodStatisticByClassLoader(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByPackageController asCalledMethodStatisticByPackage() throws IOException {
        return CalledUtils.asCalledMethodStatisticByPackage(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByPackageTreeController asCalledMethodStatisticByPackageTree() throws IOException {
        return CalledUtils.asCalledMethodStatisticByPackageTree(this.getResourceName());
    }

    @Override
    public ThreadIdStatisticController asThreadIdStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadIdStatistic(this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController asThreadNameStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadNameStatistic(this.getResourceName());
    }

    @Override
    public R removeInlining() throws IOException {
        return (R)CalledUtils.removedInliners(this.getResourceName());
    }

    @Override
    public R filterByMethod(MethodFilter[] filters) throws IOException {
        return (R)CalledUtils.filterByMethod(this.getResourceName(), filters);
    }

    @Override
    public R addFilterInliner(MethodFilter[] filters) throws IOException {
        return (R)CalledUtils.addFilterInliner(this.getResourceName(), filters);
    }

    @Override
    public R addJdkIoInliner() throws IOException {
        return (R)CalledUtils.addJdkIoInliner(this.getResourceName());
    }

    @Override
    public R removeJdkIoInlining() throws IOException {
        return (R)CalledUtils.removeJdkIoInlining(this.getResourceName());
    }

    @Override
    public CalledThreadAnnotationStatisticController getSelectedCalledThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadAnnotationStatistic(this.getSelectedCalledName(type), this.getResourceName(), slot);
    }

    @Override
    public CalledThreadIdStatisticController getSelectedCalledThreadIdStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadIdStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledThreadNameStatisticController getSelectedCalledThreadNameStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadNameStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ThreadAnnotationStatisticController getSelectedThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadAnnotationStatistic(this.getSelectedCalledName(type), this.getResourceName(), slot);
    }

    @Override
    public ThreadIdStatisticController getSelectedThreadIdStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadIdStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController getSelectedThreadNameStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadNameStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledThreadIdStatisticController asCalledThreadIdStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.asCalledThreadIdStatistic(this.getResourceName());
    }

    @Override
    public CalledThreadNameStatisticController asCalledThreadNameStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.asCalledThreadNameStatistic(this.getResourceName());
    }

    @Override
    public CalledFilterStatisticController getSelectedCalledFilterStatistic(MethodFilter[] filters, IncludeType type) throws IOException {
        return CalledUtils.getCalledFilterStatistic(this.getSelectedCalledName(type), this.getResourceName(), filters);
    }

    @Override
    public CalledFilterTreeController getSelectedCalledFilterTree(MethodFilter[] filters, IncludeType type) throws IOException {
        return CalledUtils.getCalledFilterTree(this.getSelectedCalledName(type), this.getResourceName(), filters);
    }

    @Override
    public CalledMethodStatisticController getSelectedCalledMethodStatistic(IncludeType type) throws IOException {
        return CalledUtils.getCalledMethodStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CallingMethodStatisticController getSelectedCallingMethodStatistic(IncludeType type) throws IOException {
        return CalledUtils.getCallingMethodStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public CalledMethodTreeController getSelectedCalledMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCalledMethodTree(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public void createSnapshot(IncludeType type, ProgressReporter reporter) throws IOException {
        CalledUtils.createSnapshot(this.getResourceName(), this.getSelectedCalledName(type), null, reporter);
    }

    @Override
    public CallingMethodTreeController getSelectedCallingMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCallingMethodTree(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public DetailedFileStatisticController getSelectedDetailedFileStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getDetailedFileStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledTimeSeriesController getCalledTimeSeriesController(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledTimeSeries(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public TimeSeriesController getTimeSeriesController(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getTimeSeries(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public boolean hasHeartBeat() {
        return this.getResourceName().getSession().getCapabilities().hasHeartBeatTrace();
    }
}

