/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.io;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.io.CallingUtils;
import com.sap.jvm.profiling.controller.impl.model.io.Elements;
import com.sap.jvm.profiling.controller.model.io.CalledDetailedFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledFilterStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledFilterTreeController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticByClassController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticByClassLoaderController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticByPackageController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticByPackageTreeController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodTreeController;
import com.sap.jvm.profiling.controller.model.io.CalledOpenFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledTimeSeriesController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodStatisticController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.io.DetailedFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.FileStatisticController;
import com.sap.jvm.profiling.controller.model.io.OpenFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.ThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.io.ThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.io.ThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.io.TimeSeriesController;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.elements.FilterMethodsByFilter;
import com.sap.jvm.profiling.snapshot.elements.InlineByFilter;
import com.sap.jvm.profiling.snapshot.elements.InlineByPredefinedFilter;
import com.sap.jvm.profiling.snapshot.elements.RemoveInliners;
import com.sap.jvm.profiling.snapshot.elements.RemovePredefinedInliners;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public final class CalledUtils {
    public static ResourceController<?> addFilterInliner(ResourceName parent, MethodFilter[] filters) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new InlineByFilter(filters));
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> removedInliners(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new RemoveInliners());
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> addJdkIoInliner(ResourceName parent) throws IOException {
        InlineByPredefinedFilter filter = new InlineByPredefinedFilter(InlineByPredefinedFilter.PredefinedFilter.JDK_IO_CLASSES, parent.getSession());
        ResourceName name = parent.addElement((ResourceNameElement)filter);
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> removeJdkIoInlining(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new RemovePredefinedInliners());
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static FileStatisticController getFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateFileStatisticController());
        return (FileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static OpenFileStatisticController getOpenFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateOpenFileStatisticController(baseName));
        return (OpenFileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static DetailedFileStatisticController getDetailedFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateDetailedFileStatisticController());
        return (DetailedFileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledFileStatisticController getCalledFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledFileStatisticController());
        return (CalledFileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledOpenFileStatisticController getCalledOpenFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledOpenFileStatisticController(baseName));
        return (CalledOpenFileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledDetailedFileStatisticController getCalledDetailedFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledDetailedFileStatisticController());
        return (CalledDetailedFileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadIdStatisticController asThreadIdStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateThreadIdStatisticController());
        return (ThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadNameStatisticController asThreadNameStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateThreadNameStatisticController());
        return (ThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticController asCalledMethodStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticController());
        return (CalledMethodStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticByClassController asCalledMethodStatisticByClass(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticByClassController());
        return (CalledMethodStatisticByClassController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticByClassLoaderController asCalledMethodStatisticByClassLoader(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticByClassLoaderController());
        return (CalledMethodStatisticByClassLoaderController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticByPackageController asCalledMethodStatisticByPackage(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticByPackageController());
        return (CalledMethodStatisticByPackageController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticByPackageTreeController asCalledMethodStatisticByPackageTree(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticByPackageTreeController());
        return (CalledMethodStatisticByPackageTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> filterByMethod(ResourceName parent, MethodFilter[] filters) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new FilterMethodsByFilter(filters));
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadAnnotationStatisticController getThreadAnnotationStatistic(ResourceName baseName, ResourceName parent, int slot) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadAnnotationStatisticController(slot));
        return (ThreadAnnotationStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadAnnotationStatisticController getCalledThreadAnnotationStatistic(ResourceName baseName, ResourceName parent, int slot) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledThreadAnnotationStatisticController(slot));
        return (CalledThreadAnnotationStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadIdStatisticController getThreadIdStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadIdStatisticController());
        return (ThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadIdStatisticController getCalledThreadIdStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledThreadIdStatisticController());
        return (CalledThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadNameStatisticController getThreadNameStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadNameStatisticController());
        return (ThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadNameStatisticController getCalledThreadNameStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledThreadNameStatisticController());
        return (CalledThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadIdStatisticController asCalledThreadIdStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledThreadIdStatisticController());
        return (CalledThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadNameStatisticController asCalledThreadNameStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledThreadNameStatisticController());
        return (CalledThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodTreeController getCallingMethodTree(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addNonNullElement((ResourceNameElement)CallingUtils.getRootFinder(baseName));
        name = name.addElement((ResourceNameElement)new Elements.CreateCallingMethodTreeController());
        return (CallingMethodTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodStatisticController getCallingMethodStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingMethodStatisticController());
        return (CallingMethodStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledFilterStatisticController getCalledFilterStatistic(ResourceName baseName, ResourceName parent, MethodFilter[] filters) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledFilterStatisticController(filters));
        return (CalledFilterStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledFilterTreeController getCalledFilterTree(ResourceName baseName, ResourceName parent, MethodFilter[] filters) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledFilterTreeController(filters));
        return (CalledFilterTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticController getCalledMethodStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticController());
        return (CalledMethodStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodTreeController getCalledMethodTree(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledMethodTreeController());
        return (CalledMethodTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static void createSnapshot(ResourceName parent, ResourceName baseName, String name, ProgressReporter reporter) throws IOException {
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(baseName.getSession());
        manager.createSnapshot(SnapshotType.IO_SNAPSHOT, name, baseName.addElement((ResourceNameElement)new RemoveInliners()), parent, reporter);
    }

    public static CalledTimeSeriesController getCalledTimeSeries(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledTimeSeriesController());
        return (CalledTimeSeriesController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static TimeSeriesController getTimeSeries(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateTimeSeriesController());
        return (TimeSeriesController)ResourceControllerUtils.getResourceController(parent, name);
    }
}

