/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.io;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.io.CalledUtils;
import com.sap.jvm.profiling.controller.impl.model.io.Elements;
import com.sap.jvm.profiling.controller.model.io.CalledMethodStatisticController;
import com.sap.jvm.profiling.controller.model.io.CalledMethodTreeController;
import com.sap.jvm.profiling.controller.model.io.CallingDetailedFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CallingFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodStatisticByClassController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodStatisticByClassLoaderController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodStatisticByPackageController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodStatisticByPackageTreeController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodStatisticController;
import com.sap.jvm.profiling.controller.model.io.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.io.CallingOpenFileStatisticController;
import com.sap.jvm.profiling.controller.model.io.CallingThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.io.CallingThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.io.CallingThreadNameStatisticController;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.InlineByPredefinedFilter;
import com.sap.jvm.profiling.snapshot.elements.RemovePredefinedInliners;
import com.sap.jvm.profiling.snapshot.elements.UndoLastStackExtractorStep;
import com.sap.jvm.profiling.snapshot.elements.UseNonFilteredAsCallingRoots;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.snapshot.resource.InlineFilterExtractor;
import com.sap.jvm.profiling.snapshot.rootfinder.CallingRootFinderElement;
import java.io.IOException;

public final class CallingUtils {
    public static ResourceController<?> addFilterInliner(ResourceName parent, MethodFilter[] filters) throws IOException {
        return CalledUtils.addFilterInliner(parent, filters);
    }

    public static ResourceController<?> removedInliners(ResourceName parent) throws IOException {
        return CalledUtils.removedInliners(parent);
    }

    public static ResourceController<?> addJdkIoInliner(ResourceName parent) throws IOException {
        InlineByPredefinedFilter filter = new InlineByPredefinedFilter(InlineByPredefinedFilter.PredefinedFilter.JDK_IO_CLASSES, parent.getSession());
        ResourceName name = parent.addElement((ResourceNameElement)filter);
        boolean addRootFinder = parent.endsWithType((ResourceNameElement)new Elements.CreateCallingMethodTreeController());
        if (addRootFinder) {
            name = name.addElement((ResourceNameElement)new UseNonFilteredAsCallingRoots(filter.getFilter()));
        }
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> removeJdkIoInlining(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new RemovePredefinedInliners());
        boolean removeRootFinder = parent.endsWithType((ResourceNameElement)new Elements.CreateCallingMethodTreeController());
        if (removeRootFinder) {
            name = name.addElement((ResourceNameElement)new UndoLastStackExtractorStep());
        }
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingRootFinderElement getRootFinder(ResourceName baseName) {
        MethodFilter inliningFilter = InlineFilterExtractor.getPredefinedInlineFilter(baseName);
        if (inliningFilter == null) {
            return null;
        }
        return new UseNonFilteredAsCallingRoots(inliningFilter);
    }

    public static CallingMethodStatisticController asCallingMethodStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCallingMethodStatisticController());
        return (CallingMethodStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodStatisticByClassController asCallingMethodStatisticByClass(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCallingMethodStatisticByClassController());
        return (CallingMethodStatisticByClassController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodStatisticByClassLoaderController asCallingMethodStatisticByClassLoader(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCallingMethodStatisticByClassLoaderController());
        return (CallingMethodStatisticByClassLoaderController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodStatisticByPackageController asCallingMethodStatisticByPackage(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCallingMethodStatisticByPackageController());
        return (CallingMethodStatisticByPackageController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodStatisticByPackageTreeController asCallingMethodStatisticByPackageTree(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCallingMethodStatisticByPackageTreeController());
        return (CallingMethodStatisticByPackageTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingThreadAnnotationStatisticController getThreadAnnotationStatistic(ResourceName baseName, ResourceName parent, int slot) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingThreadAnnotationStatisticController(slot));
        return (CallingThreadAnnotationStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingThreadNameStatisticController asThreadNameStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCallingThreadNameStatisticController());
        return (CallingThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingThreadIdStatisticController asThreadIdStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCallingThreadIdStatisticController());
        return (CallingThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> filterByMethod(ResourceName parent, MethodFilter[] filters) throws IOException {
        return CalledUtils.filterByMethod(parent, filters);
    }

    public static CalledMethodStatisticController getCalledMethodStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        return CalledUtils.getCalledMethodStatistic(baseName, parent);
    }

    public static CalledMethodTreeController getCalledMethodTree(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledMethodTreeController());
        return (CalledMethodTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingThreadIdStatisticController getThreadIdStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingThreadIdStatisticController());
        return (CallingThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingThreadNameStatisticController getThreadNameStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingThreadNameStatisticController());
        return (CallingThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingFileStatisticController getCallingFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingFileStatisticController());
        return (CallingFileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingOpenFileStatisticController getCallingOpenFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingOpenFileStatisticController(baseName));
        return (CallingOpenFileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingDetailedFileStatisticController getCallingDetailedFileStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingDetailedFileStatisticController());
        return (CallingDetailedFileStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodStatisticController getCallingMethodStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingMethodStatisticController());
        return (CallingMethodStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodTreeController getCallingMethodTree(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addNonNullElement((ResourceNameElement)CallingUtils.getRootFinder(baseName));
        name = name.addElement((ResourceNameElement)new Elements.CreateCallingMethodTreeController());
        return (CallingMethodTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static void createSnapshot(ResourceName parent, ResourceName baseName, String name, ProgressReporter reporter) throws IOException {
        CalledUtils.createSnapshot(parent, baseName, name, reporter);
    }
}

