/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.io;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.io.Elements;
import com.sap.jvm.profiling.controller.impl.trace.IOTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.model.io.IOModel;
import com.sap.jvm.profiling.controller.model.io.IOSnapshotController;
import com.sap.jvm.profiling.controller.trace.IOTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.io.command.IOTraceConfiguration;
import com.sap.jvm.profiling.io.event.FileCloseEvent;
import com.sap.jvm.profiling.io.event.FileNotFoundEvent;
import com.sap.jvm.profiling.io.event.FileOpenEvent;
import com.sap.jvm.profiling.io.event.FileReadEvent;
import com.sap.jvm.profiling.io.event.FileWriteEvent;
import com.sap.jvm.profiling.io.event.IOEventHandler;
import com.sap.jvm.profiling.io.response.DisableIOTraceResponse;
import com.sap.jvm.profiling.io.response.EnableIOTraceResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.profiling.snapshot.io.Elements;
import com.sap.jvm.profiling.snapshot.io.IOSnapshot;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class IOModelImpl
extends AbstractModelImpl<IOSnapshot>
implements IOEventHandler,
IOModel,
SnapshotMarkerHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"File I/O Snapshot");
    private long nrOfReadBytes;
    private long nrOfWrittenBytes;
    private long readDuration;
    private long writeDuration;
    private long nrOfReadBytesSinceLastSnapshotCreation;
    private long nrOfWrittenBytesSinceLastSnapshotCreation;
    private long readDurationSinceLastSnapshotCreation;
    private long writeDurationSinceLastSnapshotCreation;
    private IOTraceConfiguration ioTraceConfig;

    public IOModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.IO_TRACE, controller);
    }

    public void handle(EnableIOTraceResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.ioTraceConfig = response.getConfiguration();
        }
    }

    public void handle(DisableIOTraceResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public boolean handle(SnapshotMarkerResponse event) {
        ProfilingTraceType type;
        boolean consumed = false;
        if (this.ioTraceConfig != null && ((type = event.getTraceType()) == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.IO_TRACE)) {
            this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
            consumed = true;
            this.resetStateAfterSnapshotCreation();
        }
        return consumed;
    }

    public void handle(FileOpenEvent event) {
    }

    public void handle(FileNotFoundEvent event) {
    }

    public void handle(FileReadEvent event) {
        this.updateStatistics(event.getNrOfReadBytes(), 0L, event.getDuration(), 0L);
    }

    public void handle(FileWriteEvent event) {
        this.updateStatistics(0, event.getNrOfWrittenBytes(), 0L, event.getDuration());
    }

    public void handle(FileCloseEvent event) {
    }

    @Override
    public IOSnapshotController getSnapshotController(IOSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateIOSnapshotController());
        ResourceManager manager = name.getResourceManager();
        IOSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (IOSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    public synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        if (this.ioTraceConfig == null) {
            return;
        }
        super.createSnapshotInternal(delta, endCollectionTimeStamp, stop);
        if (stop) {
            this.ioTraceConfig = null;
        }
        this.resetStateAfterSnapshotCreation();
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        IOTraceConfiguration config = null;
        if (response instanceof EnableIOTraceResponse) {
            config = ((EnableIOTraceResponse)response).getConfiguration();
        } else assert (false);
        IOTraceSpec spec = this.createSpecification(config);
        return new IOTraceImpl("File I/O Trace", spec, this.controller.getProfilingSession());
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.IOSnapshotElement snapshotElement = new Elements.IOSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createIOSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, this.ioTraceConfig, isDelta ? this.nrOfReadBytesSinceLastSnapshotCreation : this.nrOfReadBytes, isDelta ? this.nrOfWrittenBytesSinceLastSnapshotCreation : this.nrOfWrittenBytes, isDelta ? this.readDurationSinceLastSnapshotCreation : this.readDuration, isDelta ? this.writeDurationSinceLastSnapshotCreation : this.writeDuration, startTimestamp, endTimestamp, isVirtual, (IOSnapshot)parentSnapshot);
    }

    @Override
    protected void resetCollectionState() {
        this.nrOfReadBytes = 0L;
        this.nrOfReadBytesSinceLastSnapshotCreation = 0L;
        this.nrOfWrittenBytes = 0L;
        this.nrOfWrittenBytesSinceLastSnapshotCreation = 0L;
        this.readDuration = 0L;
        this.readDurationSinceLastSnapshotCreation = 0L;
        this.writeDuration = 0L;
        this.writeDurationSinceLastSnapshotCreation = 0L;
        this.startTimeStamp = 0L;
        this.lastSnapshotEndTimeStamp = -1L;
        this.ioTraceConfig = null;
    }

    private void resetStateAfterSnapshotCreation() {
        this.nrOfReadBytesSinceLastSnapshotCreation = 0L;
        this.nrOfWrittenBytesSinceLastSnapshotCreation = 0L;
        this.readDurationSinceLastSnapshotCreation = 0L;
        this.writeDurationSinceLastSnapshotCreation = 0L;
    }

    private IOTraceSpec createSpecification(IOTraceConfiguration config) {
        IOTraceSpec spec = new IOTraceSpec();
        spec.setThreadFilter(config.getThreadFilter());
        return spec;
    }

    private void updateStatistics(int readBytesToAdd, long writtenBytesToAdd, long readDurationToAdd, long writeDurationToAdd) {
        this.nrOfReadBytes += (long)readBytesToAdd;
        this.nrOfWrittenBytes += writtenBytesToAdd;
        this.readDuration += readDurationToAdd;
        this.writeDuration += writeDurationToAdd;
        ((IOTraceImpl)this.trace).setNrOfReadBytes(this.nrOfReadBytes);
        ((IOTraceImpl)this.trace).setNrOfWrittenBytes(this.nrOfWrittenBytes);
        this.nrOfReadBytesSinceLastSnapshotCreation += (long)readBytesToAdd;
        this.nrOfWrittenBytesSinceLastSnapshotCreation += writtenBytesToAdd;
        this.readDurationSinceLastSnapshotCreation += readDurationToAdd;
        this.writeDurationSinceLastSnapshotCreation += writeDurationToAdd;
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.IOSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        return factory.createIOSnapshot(id, resourceName, name, (IOSnapshot)parent, isVirtual, reporter);
    }
}

