/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.mpt;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractTypedController;
import com.sap.jvm.profiling.controller.impl.model.mpt.CalledUtils;
import com.sap.jvm.profiling.controller.model.IncludeType;
import com.sap.jvm.profiling.controller.model.mpt.CalledMethodParameterController;
import com.sap.jvm.profiling.controller.model.mpt.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.mpt.MethodInvocationStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.MethodParameterStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.ParameterValueStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.ThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.ThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.ThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.TimeSeriesController;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import java.io.IOException;

public abstract class AbstractCalledController<R extends ResourceController<T>, T extends TypedModel>
extends AbstractTypedController<T>
implements CalledMethodParameterController<T, R> {
    private final boolean isCalled;

    protected AbstractCalledController(ResourceName name, ProgressReporter reporter, boolean isCalled) throws IOException {
        super(name, reporter);
        this.isCalled = isCalled;
    }

    @Override
    public ThreadIdStatisticController getSelectedThreadIdStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadIdStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController getSelectedThreadNameStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadNameStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public final ThreadAnnotationStatisticController getSelectedThreadAnnotationStatistic(int slot) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadAnnotationStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName(), slot);
    }

    @Override
    public MethodParameterStatisticController getSelectedMethodParameterStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getMethodParameterStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public MethodParameterStatisticController getSelectedOtherMethodParameterStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getOtherMethodParameterStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CallingMethodTreeController getSelectedCallingMethodTree() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getCallingMethodTree(this.getSelectedCallingName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public ParameterValueStatisticController getSelectedParameterValueStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getParameterValueStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public MethodInvocationStatisticController getSelectedInvocationStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getInvocationStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public ThreadIdStatisticController asThreadIdStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadIdStatistic(this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController asThreadNameStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadNameStatistic(this.getResourceName());
    }

    @Override
    public TimeSeriesController getSelectedTimeSeries() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getTimeSeries(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public void createSnapshot(IncludeType type, ProgressReporter reporter) throws IOException {
        CalledUtils.createSnapshot(this.getResourceName(), this.getSelectedCalledName(type), null, reporter);
    }

    @Override
    public boolean hasHeartBeat() {
        return this.getResourceName().getSession().getCapabilities().hasHeartBeatTrace();
    }
}

