/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.mpt;

import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.mpt.Elements;
import com.sap.jvm.profiling.controller.model.mpt.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.mpt.MethodInvocationStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.MethodParameterStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.ParameterValueStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.ThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.ThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.ThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.mpt.TimeSeriesController;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.elements.RemoveInliners;
import java.io.IOException;

public final class CalledUtils {
    public static ThreadIdStatisticController getThreadIdStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadIdStatisticController());
        return (ThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadNameStatisticController getThreadNameStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadNameStatisticController());
        return (ThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadAnnotationStatisticController getThreadAnnotationStatistic(ResourceName baseName, ResourceName parent, int slot) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadAnnotationStatisticController(slot));
        return (ThreadAnnotationStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static MethodParameterStatisticController getMethodParameterStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateMethodParameterStatisticController());
        return (MethodParameterStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static MethodParameterStatisticController getOtherMethodParameterStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateMethodParameterStatisticController());
        return (MethodParameterStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodTreeController getCallingMethodTree(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingMethodTreeController());
        return (CallingMethodTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ParameterValueStatisticController getParameterValueStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateParameterValuesStatisticController());
        return (ParameterValueStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static MethodInvocationStatisticController getInvocationStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateMethodInvocationStatisticController());
        return (MethodInvocationStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadIdStatisticController asThreadIdStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateThreadIdStatisticController());
        return (ThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadNameStatisticController asThreadNameStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateThreadNameStatisticController());
        return (ThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static TimeSeriesController getTimeSeries(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateTimeSeriesController());
        return (TimeSeriesController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static void createSnapshot(ResourceName parent, ResourceName baseName, String name, ProgressReporter reporter) throws IOException {
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(baseName.getSession());
        manager.createSnapshot(SnapshotType.METHOD_PARAMETER_SNAPSHOT, name, baseName.addElement((ResourceNameElement)new RemoveInliners()), parent, reporter);
    }
}

