/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.mpt;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.mpt.Elements;
import com.sap.jvm.profiling.controller.impl.trace.MethodParameterTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.model.mpt.MethodParameterModel;
import com.sap.jvm.profiling.controller.model.mpt.MethodParameterSnapshotController;
import com.sap.jvm.profiling.controller.trace.MethodParameterTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.event.MethodToTraceHandler;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.profiling.snapshot.mpt.Elements;
import com.sap.jvm.profiling.snapshot.mpt.MethodParameterSnapshot;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MethodParameterModelImpl
extends AbstractModelImpl<MethodParameterSnapshot>
implements MethodParameterModel,
MethodParameterEventHandler,
SnapshotMarkerHandler,
MethodToTraceHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"Method Parameter Snapshot");
    private long nrOfInvocations;
    private List<MethodParameterSpec> specs;
    private long nrOfInvocationsSinceLastSnapshotCreation;
    private ArrayList<MethodParameterMethodToTraceEvent> methodsToTrace;

    public MethodParameterModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.METHOD_PARAMETER_TRACE, controller);
    }

    @Override
    public long getNrOfInvocations() {
        return this.nrOfInvocations;
    }

    @Override
    public MethodParameterSnapshotController getSnapshotController(MethodParameterSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateMethodParameterSnapshotController());
        ResourceManager manager = name.getResourceManager();
        MethodParameterSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (MethodParameterSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    public void handle(DisableMethodParameterTraceResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public void handle(EnableMethodParameterTraceResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.specs = response.getParameterSpecs();
            this.methodsToTrace = new ArrayList();
        }
    }

    public void handle(MethodParameterEntryEvent event) {
        if (this.trace == null) {
            return;
        }
        ++this.nrOfInvocations;
        ++this.nrOfInvocationsSinceLastSnapshotCreation;
        ((MethodParameterTraceImpl)this.trace).setNrOfInvocations(this.nrOfInvocations);
    }

    public void handle(MethodParameterExitEvent event) {
    }

    public boolean handle(SnapshotMarkerResponse event) {
        ProfilingTraceType type;
        boolean consumed = false;
        if (this.specs != null && ((type = event.getTraceType()) == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.METHOD_PARAMETER_TRACE)) {
            this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
            this.resetStateAfterSnapshotCreation();
            consumed = true;
        }
        return consumed;
    }

    public void handle(MethodParameterMethodToTraceEvent event) {
        if (this.methodsToTrace != null) {
            this.methodsToTrace.add(event);
        }
    }

    public void handle(MethodParameterApplyErrorEvent event) {
    }

    public void handle(MethodParameterNearMissEvent event) {
    }

    public boolean providesReturnValuesInEntryEvents() {
        return false;
    }

    public ArrayList<Parameter> getReturnValuesForEntryEvent(MethodParameterEntryEvent event) {
        assert (false);
        return null;
    }

    @Override
    protected synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        super.createSnapshotInternal(delta, endCollectionTimeStamp, stop);
        this.resetStateAfterSnapshotCreation();
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.MethodParameterSnapshotElement snapshotElement = new Elements.MethodParameterSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createMethodParameterSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, isDelta ? this.nrOfInvocationsSinceLastSnapshotCreation : this.nrOfInvocations, this.specs, this.methodsToTrace, startTimestamp, endTimestamp, isVirtual, (MethodParameterSnapshot)parentSnapshot);
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        return new MethodParameterTraceImpl("Method Parameter Trace", this.createSpecification((EnableMethodParameterTraceResponse)response), this.controller.getProfilingSession());
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected void resetCollectionState() {
        this.nrOfInvocations = 0L;
        this.nrOfInvocationsSinceLastSnapshotCreation = 0L;
        this.startTimeStamp = 0L;
        this.lastSnapshotEndTimeStamp = -1L;
        this.specs = null;
        this.methodsToTrace = null;
    }

    private void resetStateAfterSnapshotCreation() {
        this.nrOfInvocationsSinceLastSnapshotCreation = 0L;
    }

    private MethodParameterTraceSpec createSpecification(EnableMethodParameterTraceResponse response) {
        ArrayList<RequestedMethodParameter> parameterList = new ArrayList<RequestedMethodParameter>();
        for (MethodParameterSpec spec : response.getParameterSpecs()) {
            RequestedMethodParameter parameter = new RequestedMethodParameter(spec.getName(), spec.getDescription(), spec.getMethod(), spec.getIndex(), spec.getIncludeType(), spec.getModifiers());
            parameterList.add(parameter);
        }
        return new MethodParameterTraceSpec(parameterList, response.includeTimeStamp(), response.includeCpuTime(), response.includeStackTrace());
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.MethodParameterSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        return factory.createMethodParameterSnapshot(id, resourceName, name, (MethodParameterSnapshot)parent, isVirtual, reporter);
    }
}

