/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.net;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractTypedController;
import com.sap.jvm.profiling.controller.impl.model.net.CalledUtils;
import com.sap.jvm.profiling.controller.model.IncludeType;
import com.sap.jvm.profiling.controller.model.net.CalledDetailedSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledFilterStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledFilterTreeController;
import com.sap.jvm.profiling.controller.model.net.CalledHostStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticByClassController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticByClassLoaderController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticByPackageController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticByPackageTreeController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodTreeController;
import com.sap.jvm.profiling.controller.model.net.CalledNetworkController;
import com.sap.jvm.profiling.controller.model.net.CalledOpenSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledServiceStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledTimeSeriesController;
import com.sap.jvm.profiling.controller.model.net.CallingMethodStatisticController;
import com.sap.jvm.profiling.controller.model.net.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.net.DetailedSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.HostStatisticController;
import com.sap.jvm.profiling.controller.model.net.OpenSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.ServiceStatisticController;
import com.sap.jvm.profiling.controller.model.net.SocketLatencyStatisticController;
import com.sap.jvm.profiling.controller.model.net.SocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.ThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.net.ThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.net.ThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.net.TimeSeriesController;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public abstract class AbstractCalledController<T extends ResourceController<M>, M extends TypedModel>
extends AbstractTypedController<M>
implements CalledNetworkController<M, T> {
    private final boolean isCalled;

    protected AbstractCalledController(ResourceName name, ProgressReporter reporter, boolean isCalled) throws IOException {
        super(name, reporter);
        this.isCalled = isCalled;
    }

    @Override
    public ServiceStatisticController getSelectedServiceStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getServiceStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledServiceStatisticController getSelectedCalledServiceStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledServiceStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public HostStatisticController getSelectedHostStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getHostStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledHostStatisticController getSelectedCalledHostStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledHostStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public SocketStatisticController getSelectedSocketStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getSocketStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public OpenSocketStatisticController getSelectedOpenSocketStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getOpenSocketStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public SocketLatencyStatisticController getSelectedSocketLatencyStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getSocketLatencyStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledSocketStatisticController getSelectedCalledSocketStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledSocketStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledOpenSocketStatisticController getSelectedCalledOpenSocketStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledOpenSocketStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledDetailedSocketStatisticController getSelectedCalledDetailedSocketStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledDetailedSocketStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public CalledMethodStatisticController asCalledMethodStatistic() throws IOException {
        return CalledUtils.asCalledMethodStatistic(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByClassController asCalledMethodStatisticByClass() throws IOException {
        return CalledUtils.asCalledMethodStatisticByClass(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByClassLoaderController asCalledMethodStatisticByClassLoader() throws IOException {
        return CalledUtils.asCalledMethodStatisticByClassLoader(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByPackageController asCalledMethodStatisticByPackage() throws IOException {
        return CalledUtils.asCalledMethodStatisticByPackage(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByPackageTreeController asCalledMethodStatisticByPackageTree() throws IOException {
        return CalledUtils.asCalledMethodStatisticByPackageTree(this.getResourceName());
    }

    @Override
    public ThreadIdStatisticController asThreadIdStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadIdStatistic(this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController asThreadNameStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadNameStatistic(this.getResourceName());
    }

    @Override
    public T removeInlining() throws IOException {
        return (T)CalledUtils.removedInliners(this.getResourceName());
    }

    @Override
    public T filterByMethod(MethodFilter[] filters) throws IOException {
        return (T)CalledUtils.filterByMethod(this.getResourceName(), filters);
    }

    @Override
    public T addFilterInliner(MethodFilter[] filters) throws IOException {
        return (T)CalledUtils.addFilterInliner(this.getResourceName(), filters);
    }

    @Override
    public T addJdkNetworkInliner() throws IOException {
        return (T)CalledUtils.addJdkNetworkInliner(this.getResourceName());
    }

    @Override
    public T removeJdkNetworkInlining() throws IOException {
        return (T)CalledUtils.removeJdkNetworkInlining(this.getResourceName());
    }

    @Override
    public CalledThreadAnnotationStatisticController getSelectedCalledThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadAnnotationStatistic(this.getSelectedCalledName(type), this.getResourceName(), slot);
    }

    @Override
    public CalledThreadIdStatisticController getSelectedCalledThreadIdStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadIdStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledThreadNameStatisticController getSelectedCalledThreadNameStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadNameStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ThreadAnnotationStatisticController getSelectedThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadAnnotationStatistic(this.getSelectedCalledName(type), this.getResourceName(), slot);
    }

    @Override
    public ThreadIdStatisticController getSelectedThreadIdStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadIdStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController getSelectedThreadNameStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadNameStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledThreadIdStatisticController asCalledThreadIdStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.asCalledThreadIdStatistic(this.getResourceName());
    }

    @Override
    public CalledThreadNameStatisticController asCalledThreadNameStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.asCalledThreadNameStatistic(this.getResourceName());
    }

    @Override
    public CalledFilterStatisticController getSelectedCalledFilterStatistic(MethodFilter[] filters, IncludeType type) throws IOException {
        return CalledUtils.getCalledFilterStatistic(this.getSelectedCalledName(type), this.getResourceName(), filters);
    }

    @Override
    public CalledFilterTreeController getSelectedCalledFilterTree(MethodFilter[] filters, IncludeType type) throws IOException {
        return CalledUtils.getCalledFilterTree(this.getSelectedCalledName(type), this.getResourceName(), filters);
    }

    @Override
    public CalledMethodStatisticController getSelectedCalledMethodStatistic(IncludeType type) throws IOException {
        return CalledUtils.getCalledMethodStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CallingMethodStatisticController getSelectedCallingMethodStatistic(IncludeType type) throws IOException {
        return CalledUtils.getCallingMethodStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public CalledMethodTreeController getSelectedCalledMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCalledMethodTree(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public void createSnapshot(IncludeType type, ProgressReporter reporter) throws IOException {
        CalledUtils.createSnapshot(this.getResourceName(), this.getSelectedCalledName(type), null, reporter);
    }

    @Override
    public CallingMethodTreeController getSelectedCallingMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCallingMethodTree(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public DetailedSocketStatisticController getSelectedDetailedSocketStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getDetailedSocketStatistic(this.getSelectedCalledName(IncludeType.TOTAL), this.getResourceName());
    }

    @Override
    public TimeSeriesController getSelectedTimeSeriesController(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getTimeSeries(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledTimeSeriesController getSelectedCalledTimeSeriesController(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledTimeSeries(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public boolean hasHeartBeat() {
        return this.getResourceName().getSession().getCapabilities().hasHeartBeatTrace();
    }
}

