/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.net;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.net.CallingUtils;
import com.sap.jvm.profiling.controller.impl.model.net.Elements;
import com.sap.jvm.profiling.controller.model.net.CalledDetailedSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledFilterStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledFilterTreeController;
import com.sap.jvm.profiling.controller.model.net.CalledHostStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticByClassController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticByClassLoaderController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticByPackageController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticByPackageTreeController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledMethodTreeController;
import com.sap.jvm.profiling.controller.model.net.CalledOpenSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledServiceStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.net.CalledTimeSeriesController;
import com.sap.jvm.profiling.controller.model.net.CallingMethodStatisticController;
import com.sap.jvm.profiling.controller.model.net.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.net.DetailedSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.HostStatisticController;
import com.sap.jvm.profiling.controller.model.net.OpenSocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.ServiceStatisticController;
import com.sap.jvm.profiling.controller.model.net.SocketLatencyStatisticController;
import com.sap.jvm.profiling.controller.model.net.SocketStatisticController;
import com.sap.jvm.profiling.controller.model.net.ThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.net.ThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.net.ThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.net.TimeSeriesController;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.elements.FilterMethodsByFilter;
import com.sap.jvm.profiling.snapshot.elements.InlineByFilter;
import com.sap.jvm.profiling.snapshot.elements.InlineByPredefinedFilter;
import com.sap.jvm.profiling.snapshot.elements.RemoveInliners;
import com.sap.jvm.profiling.snapshot.elements.RemovePredefinedInliners;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public final class CalledUtils {
    public static ResourceController<?> addFilterInliner(ResourceName parent, MethodFilter[] filters) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new InlineByFilter(filters));
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> removedInliners(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new RemoveInliners());
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> addJdkNetworkInliner(ResourceName parent) throws IOException {
        InlineByPredefinedFilter filter = new InlineByPredefinedFilter(InlineByPredefinedFilter.PredefinedFilter.JDK_NETWORK_CLASSES, parent.getSession());
        ResourceName name = parent.addElement((ResourceNameElement)filter);
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> removeJdkNetworkInlining(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new RemovePredefinedInliners());
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ServiceStatisticController getServiceStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateServiceStatisticController());
        return (ServiceStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledServiceStatisticController getCalledServiceStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledServiceStatisticController());
        return (CalledServiceStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static HostStatisticController getHostStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateHostStatisticController());
        return (HostStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledHostStatisticController getCalledHostStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledHostStatisticController());
        return (CalledHostStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static SocketStatisticController getSocketStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateSocketStatisticController());
        return (SocketStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static OpenSocketStatisticController getOpenSocketStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateOpenSocketStatisticController(baseName));
        return (OpenSocketStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static SocketLatencyStatisticController getSocketLatencyStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateSocketLatencyStatisticController());
        return (SocketLatencyStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static DetailedSocketStatisticController getDetailedSocketStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateDetailedSocketStatisticController());
        return (DetailedSocketStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledSocketStatisticController getCalledSocketStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledSocketStatisticController());
        return (CalledSocketStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledOpenSocketStatisticController getCalledOpenSocketStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledOpenSocketStatisticController(baseName));
        return (CalledOpenSocketStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledDetailedSocketStatisticController getCalledDetailedSocketStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledDetailedSocketStatisticController());
        return (CalledDetailedSocketStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadIdStatisticController asThreadIdStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateThreadIdStatisticController());
        return (ThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadNameStatisticController asThreadNameStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateThreadNameStatisticController());
        return (ThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticController asCalledMethodStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticController());
        return (CalledMethodStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticByClassController asCalledMethodStatisticByClass(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticByClassController());
        return (CalledMethodStatisticByClassController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticByClassLoaderController asCalledMethodStatisticByClassLoader(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticByClassLoaderController());
        return (CalledMethodStatisticByClassLoaderController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticByPackageController asCalledMethodStatisticByPackage(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticByPackageController());
        return (CalledMethodStatisticByPackageController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticByPackageTreeController asCalledMethodStatisticByPackageTree(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticByPackageTreeController());
        return (CalledMethodStatisticByPackageTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ResourceController<?> filterByMethod(ResourceName parent, MethodFilter[] filters) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new FilterMethodsByFilter(filters));
        name = name.addElement(parent.getLastElement());
        return ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadAnnotationStatisticController getThreadAnnotationStatistic(ResourceName baseName, ResourceName parent, int slot) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadAnnotationStatisticController(slot));
        return (ThreadAnnotationStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadAnnotationStatisticController getCalledThreadAnnotationStatistic(ResourceName baseName, ResourceName parent, int slot) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledThreadAnnotationStatisticController(slot));
        return (CalledThreadAnnotationStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadIdStatisticController getThreadIdStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadIdStatisticController());
        return (ThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadIdStatisticController getCalledThreadIdStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledThreadIdStatisticController());
        return (CalledThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static ThreadNameStatisticController getThreadNameStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateThreadNameStatisticController());
        return (ThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadNameStatisticController getCalledThreadNameStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledThreadNameStatisticController());
        return (CalledThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadIdStatisticController asCalledThreadIdStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledThreadIdStatisticController());
        return (CalledThreadIdStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledThreadNameStatisticController asCalledThreadNameStatistic(ResourceName parent) throws IOException {
        ResourceName name = parent.addElement((ResourceNameElement)new Elements.CreateCalledThreadNameStatisticController());
        return (CalledThreadNameStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodTreeController getCallingMethodTree(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addNonNullElement((ResourceNameElement)CallingUtils.getRootFinder(baseName));
        name = name.addElement((ResourceNameElement)new Elements.CreateCallingMethodTreeController());
        return (CallingMethodTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CallingMethodStatisticController getCallingMethodStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCallingMethodStatisticController());
        return (CallingMethodStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledFilterStatisticController getCalledFilterStatistic(ResourceName baseName, ResourceName parent, MethodFilter[] filters) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledFilterStatisticController(filters));
        return (CalledFilterStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledFilterTreeController getCalledFilterTree(ResourceName baseName, ResourceName parent, MethodFilter[] filters) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledFilterTreeController(filters));
        return (CalledFilterTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodStatisticController getCalledMethodStatistic(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledMethodStatisticController());
        return (CalledMethodStatisticController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledMethodTreeController getCalledMethodTree(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledMethodTreeController());
        return (CalledMethodTreeController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static CalledTimeSeriesController getCalledTimeSeries(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateCalledTimeSeriesController());
        return (CalledTimeSeriesController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static TimeSeriesController getTimeSeries(ResourceName baseName, ResourceName parent) throws IOException {
        ResourceName name = baseName.addElement((ResourceNameElement)new Elements.CreateTimeSeriesController());
        return (TimeSeriesController)ResourceControllerUtils.getResourceController(parent, name);
    }

    public static void createSnapshot(ResourceName parent, ResourceName baseName, String name, ProgressReporter reporter) throws IOException {
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(baseName.getSession());
        manager.createSnapshot(SnapshotType.NETWORK_SNAPSHOT, name, baseName.addElement((ResourceNameElement)new RemoveInliners()), parent, reporter);
    }
}

