/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.net;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.net.Elements;
import com.sap.jvm.profiling.controller.impl.trace.NetworkTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.model.net.NetworkModel;
import com.sap.jvm.profiling.controller.model.net.NetworkSnapshotController;
import com.sap.jvm.profiling.controller.trace.NetworkTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.net.command.NetworkTraceConfiguration;
import com.sap.jvm.profiling.net.event.DirectedSocketReadEvent;
import com.sap.jvm.profiling.net.event.DirectedSocketWriteEvent;
import com.sap.jvm.profiling.net.event.NetworkEventHandler;
import com.sap.jvm.profiling.net.event.SocketAcceptEvent;
import com.sap.jvm.profiling.net.event.SocketBindEvent;
import com.sap.jvm.profiling.net.event.SocketCloseEvent;
import com.sap.jvm.profiling.net.event.SocketConnectEvent;
import com.sap.jvm.profiling.net.event.SocketConnectFailureEvent;
import com.sap.jvm.profiling.net.event.SocketOpenEvent;
import com.sap.jvm.profiling.net.event.SocketReadEvent;
import com.sap.jvm.profiling.net.event.SocketWriteEvent;
import com.sap.jvm.profiling.net.response.DisableNetworkTraceResponse;
import com.sap.jvm.profiling.net.response.EnableNetworkTraceResponse;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.profiling.snapshot.net.Elements;
import com.sap.jvm.profiling.snapshot.net.NetworkSnapshot;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class NetworkModelImpl
extends AbstractModelImpl<NetworkSnapshot>
implements NetworkEventHandler,
NetworkModel,
SnapshotMarkerHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"Network I/O Snapshot");
    private long nrOfReadBytes;
    private long nrOfWrittenBytes;
    private long readDuration;
    private long writeDuration;
    private long nrOfReadBytesSinceLastSnapshotCreation;
    private long nrOfWrittenBytesSinceLastSnapshotCreation;
    private long readDurationSinceLastSnapshotCreation;
    private long writeDurationSinceLastSnapshotCreation;
    private NetworkTraceConfiguration netTraceConfig;

    public NetworkModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.NETWORK_TRACE, controller);
    }

    public void handle(EnableNetworkTraceResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.netTraceConfig = response.getConfiguration();
        }
    }

    public void handle(DisableNetworkTraceResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public boolean handle(SnapshotMarkerResponse event) {
        ProfilingTraceType type;
        boolean consumed = false;
        if (this.netTraceConfig != null && ((type = event.getTraceType()) == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.NETWORK_TRACE)) {
            this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
            consumed = true;
            this.resetStateAfterSnapshotCreation();
        }
        return consumed;
    }

    public void handle(SocketOpenEvent event) {
    }

    public void handle(SocketBindEvent event) {
    }

    public void handle(SocketConnectEvent event) {
    }

    public void handle(SocketConnectFailureEvent event) {
    }

    public void handle(SocketAcceptEvent event) {
    }

    public void handle(SocketReadEvent event) {
        this.updateStatistics(event.getNrOfReadBytes(), 0L, event.getDuration(), 0L);
    }

    public void handle(DirectedSocketReadEvent event) {
        this.updateStatistics(event.getNrOfReadBytes(), 0L, event.getDuration(), 0L);
    }

    public void handle(SocketWriteEvent event) {
        this.updateStatistics(0, event.getNrOfWrittenBytes(), 0L, event.getDuration());
    }

    public void handle(DirectedSocketWriteEvent event) {
        this.updateStatistics(0, event.getNrOfWrittenBytes(), 0L, event.getDuration());
    }

    public void handle(SocketCloseEvent event) {
    }

    @Override
    public NetworkSnapshotController getSnapshotController(NetworkSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateNetworkSnapshotController());
        ResourceManager manager = name.getResourceManager();
        NetworkSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (NetworkSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    public synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        if (this.netTraceConfig == null) {
            return;
        }
        super.createSnapshotInternal(delta, endCollectionTimeStamp, stop);
        if (stop) {
            this.netTraceConfig = null;
        }
        this.resetStateAfterSnapshotCreation();
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        NetworkTraceConfiguration config = null;
        if (response instanceof EnableNetworkTraceResponse) {
            config = ((EnableNetworkTraceResponse)response).getConfiguration();
        } else assert (false);
        NetworkTraceSpec spec = this.createSpecification(config);
        return new NetworkTraceImpl("Network I/O Trace", spec, this.controller.getProfilingSession());
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.NetworkSnapshotElement snapshotElement = new Elements.NetworkSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createNetworkSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, this.netTraceConfig, isDelta ? this.nrOfReadBytesSinceLastSnapshotCreation : this.nrOfReadBytes, isDelta ? this.nrOfWrittenBytesSinceLastSnapshotCreation : this.nrOfWrittenBytes, isDelta ? this.readDurationSinceLastSnapshotCreation : this.readDuration, isDelta ? this.writeDurationSinceLastSnapshotCreation : this.writeDuration, startTimestamp, endTimestamp, isVirtual, (NetworkSnapshot)parentSnapshot);
    }

    @Override
    protected void resetCollectionState() {
        this.nrOfReadBytes = 0L;
        this.nrOfReadBytesSinceLastSnapshotCreation = 0L;
        this.nrOfWrittenBytes = 0L;
        this.nrOfWrittenBytesSinceLastSnapshotCreation = 0L;
        this.readDuration = 0L;
        this.readDurationSinceLastSnapshotCreation = 0L;
        this.writeDuration = 0L;
        this.writeDurationSinceLastSnapshotCreation = 0L;
        this.startTimeStamp = 0L;
        this.lastSnapshotEndTimeStamp = -1L;
        this.netTraceConfig = null;
    }

    private void resetStateAfterSnapshotCreation() {
        this.nrOfReadBytesSinceLastSnapshotCreation = 0L;
        this.nrOfWrittenBytesSinceLastSnapshotCreation = 0L;
        this.readDurationSinceLastSnapshotCreation = 0L;
        this.writeDurationSinceLastSnapshotCreation = 0L;
    }

    private NetworkTraceSpec createSpecification(NetworkTraceConfiguration config) {
        NetworkTraceSpec spec = new NetworkTraceSpec();
        spec.setThreadFilter(config.getThreadFilter());
        spec.setResolveAllHosts(config.isResolveAllHosts());
        return spec;
    }

    private void updateStatistics(int readBytesToAdd, long writtenBytesToAdd, long readDurationToAdd, long writeDurationToAdd) {
        this.nrOfReadBytes += (long)readBytesToAdd;
        this.nrOfWrittenBytes += writtenBytesToAdd;
        this.readDuration += readDurationToAdd;
        this.writeDuration += writeDurationToAdd;
        ((NetworkTraceImpl)this.trace).setNrOfReadBytes(this.nrOfReadBytes);
        ((NetworkTraceImpl)this.trace).setNrOfWrittenBytes(this.nrOfWrittenBytes);
        this.nrOfReadBytesSinceLastSnapshotCreation += (long)readBytesToAdd;
        this.nrOfWrittenBytesSinceLastSnapshotCreation += writtenBytesToAdd;
        this.readDurationSinceLastSnapshotCreation += readDurationToAdd;
        this.writeDurationSinceLastSnapshotCreation += writeDurationToAdd;
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.NetworkSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        return factory.createNetworkSnapshot(id, resourceName, name, (NetworkSnapshot)parent, isVirtual, reporter);
    }
}

