/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.sync;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.sync.Elements;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.SynchronizationTraceImpl;
import com.sap.jvm.profiling.controller.model.sync.SynchronizationModel;
import com.sap.jvm.profiling.controller.model.sync.SynchronizationSnapshotController;
import com.sap.jvm.profiling.controller.trace.SynchronizationTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.event.ObjectIdentificationEvent;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.profiling.snapshot.sync.Elements;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationSnapshot;
import com.sap.jvm.profiling.sync.command.SynchronizationTraceConfiguration;
import com.sap.jvm.profiling.sync.event.MonitorEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorEnteredEvent;
import com.sap.jvm.profiling.sync.event.MonitorExitEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyAllEvent;
import com.sap.jvm.profiling.sync.event.MonitorNotifyEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitEnterEvent;
import com.sap.jvm.profiling.sync.event.MonitorWaitExitEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnterEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockEnteredEvent;
import com.sap.jvm.profiling.sync.event.ReentrantLockExitEvent;
import com.sap.jvm.profiling.sync.event.SyncEnterEvent;
import com.sap.jvm.profiling.sync.event.SyncEnteredEvent;
import com.sap.jvm.profiling.sync.event.SyncExitEvent;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import com.sap.jvm.profiling.sync.response.DisableSynchronizationTraceResponse;
import com.sap.jvm.profiling.sync.response.EnableSynchronizationTraceResponse;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public final class SynchronizationModelImpl
extends AbstractModelImpl<SynchronizationSnapshot>
implements SynchronizationEventHandler,
SynchronizationModel,
SnapshotMarkerHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"Synchronization Snapshot");
    private long nrOfBlockedEvents;
    private long blockedTime;
    private long nrOfWaitEvents;
    private long nrOfBlockedEventsSinceLastSnapshotCreation;
    private long blockedTimeSinceLastSnapshotCreation;
    private long nrOfWaitEventsSinceLastSnapshotCreation;
    private long[] startBlockedTimes;
    private SynchronizationTraceConfiguration syncTraceConfig;

    public SynchronizationModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.SYNCHRONIZATION_TRACE, controller);
    }

    private void ensureStartBlockedTime() {
        if (this.startBlockedTimes == null) {
            this.startBlockedTimes = new long[32768];
            for (int i = 0; i < this.startBlockedTimes.length; ++i) {
                this.startBlockedTimes[i] = -1L;
            }
        }
    }

    public void handle(EnableSynchronizationTraceResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.syncTraceConfig = response.getConfiguration();
        }
    }

    public void handle(DisableSynchronizationTraceResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public void handle(MonitorEnterEvent event) {
        this.handleImpl((SyncEnterEvent)event);
    }

    private void handleImpl(SyncEnterEvent event) {
        this.ensureStartBlockedTime();
        ++this.nrOfBlockedEvents;
        ((SynchronizationTraceImpl)this.trace).setNrOfBlockedEvents(this.nrOfBlockedEvents);
        ++this.nrOfBlockedEventsSinceLastSnapshotCreation;
        this.startBlockedTimes[event.getThreadIndex()] = event.getTimeStamp() - event.getCumulatedSafepointTime();
    }

    public void handle(MonitorEnteredEvent event) {
        this.handleImpl((SyncEnteredEvent)event);
    }

    private void handleImpl(SyncEnteredEvent event) {
        this.ensureStartBlockedTime();
        long start = this.startBlockedTimes[event.getThreadIndex()];
        if (start == -1L) {
            return;
        }
        long blockedTimeNS = event.getTimeStamp() - event.getCumulatedSafepointTime() - start;
        this.blockedTime += blockedTimeNS;
        ((SynchronizationTraceImpl)this.trace).setBlockedTime(this.blockedTime);
        this.blockedTimeSinceLastSnapshotCreation += blockedTimeNS;
        this.startBlockedTimes[event.getThreadIndex()] = -1L;
    }

    public void handle(MonitorExitEvent event) {
        this.handleImpl((SyncExitEvent)event);
    }

    private void handleImpl(SyncExitEvent event) {
        this.ensureStartBlockedTime();
        this.startBlockedTimes[event.getThreadIndex()] = -1L;
    }

    public void handle(MonitorWaitEnterEvent event) {
        ++this.nrOfWaitEvents;
    }

    public void handle(MonitorWaitExitEvent event) {
    }

    public boolean handle(SnapshotMarkerResponse event) {
        ProfilingTraceType type;
        boolean consumed = false;
        if (this.syncTraceConfig != null && ((type = event.getTraceType()) == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.SYNCHRONIZATION_TRACE)) {
            this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
            consumed = true;
            this.resetStateAfterSnapshotCreation();
        }
        return consumed;
    }

    @Override
    public SynchronizationSnapshotController getSnapshotController(SynchronizationSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateSynchronizationSnapshotController());
        ResourceManager manager = name.getResourceManager();
        SynchronizationSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (SynchronizationSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    public synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        if (this.syncTraceConfig == null) {
            return;
        }
        super.createSnapshotInternal(delta, endCollectionTimeStamp, stop);
        if (stop) {
            this.syncTraceConfig = null;
        }
        this.resetStateAfterSnapshotCreation();
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        SynchronizationTraceConfiguration config = null;
        if (response instanceof EnableSynchronizationTraceResponse) {
            config = ((EnableSynchronizationTraceResponse)response).getConfiguration();
        } else assert (false);
        SynchronizationTraceSpec spec = this.createSpecification(config);
        return new SynchronizationTraceImpl("Synchronization Trace", spec, this.controller.getProfilingSession());
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.SynchronizationSnapshotElement snapshotElement = new Elements.SynchronizationSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createSynchronizationSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, this.startTraceBookmark, endBookmark, this.syncTraceConfig, isDelta ? this.nrOfBlockedEventsSinceLastSnapshotCreation : this.nrOfBlockedEvents, isDelta ? this.blockedTimeSinceLastSnapshotCreation : this.blockedTime, isDelta ? this.nrOfWaitEventsSinceLastSnapshotCreation : this.nrOfWaitEvents, startTimestamp, endTimestamp, isVirtual, (SynchronizationSnapshot)parentSnapshot);
    }

    @Override
    protected void resetCollectionState() {
        this.nrOfBlockedEvents = 0L;
        this.blockedTime = 0L;
        this.nrOfWaitEvents = 0L;
        this.nrOfBlockedEventsSinceLastSnapshotCreation = 0L;
        this.nrOfWaitEventsSinceLastSnapshotCreation = 0L;
        this.startTimeStamp = 0L;
        this.lastSnapshotEndTimeStamp = -1L;
        this.startBlockedTimes = null;
        this.syncTraceConfig = null;
    }

    private void resetStateAfterSnapshotCreation() {
        this.nrOfBlockedEventsSinceLastSnapshotCreation = 0L;
        this.blockedTimeSinceLastSnapshotCreation = 0L;
        this.nrOfWaitEventsSinceLastSnapshotCreation = 0L;
    }

    private SynchronizationTraceSpec createSpecification(SynchronizationTraceConfiguration config) {
        SynchronizationTraceSpec spec = new SynchronizationTraceSpec();
        spec.setThreadFilter(config.getThreadFilter());
        return spec;
    }

    public void handle(MonitorNotifyEvent event) {
    }

    public void handle(MonitorNotifyAllEvent event) {
    }

    public void handle(ObjectIdentificationEvent event) {
    }

    public void handle(ReentrantLockEnterEvent event) {
        this.handleImpl((SyncEnterEvent)event);
    }

    public void handle(ReentrantLockEnteredEvent event) {
        this.handleImpl((SyncEnteredEvent)event);
    }

    public void handle(ReentrantLockExitEvent event) {
        this.handleImpl((SyncExitEvent)event);
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.SynchronizationSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        return factory.createSynchronizationSnapshot(id, resourceName, name, (SynchronizationSnapshot)parent, isVirtual, reporter);
    }
}

