/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.sync;

import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.RemoveInliners;
import com.sap.jvm.profiling.snapshot.elements.SwitchToBlocked;
import com.sap.jvm.profiling.snapshot.elements.SwitchToBlocking;
import com.sap.jvm.profiling.snapshot.elements.SwitchToCalling;
import com.sap.jvm.profiling.snapshot.elements.UseTopOfStackAsCalledRoots;

public class SynchronizationUtils {
    public static ResourceName getBlockedCalledName(ResourceName name) {
        if (!SynchronizationUtils.isBlocked(name)) {
            return name.addElement((ResourceNameElement)new SwitchToBlocked()).addElement((ResourceNameElement)new RemoveInliners());
        }
        return name;
    }

    public static ResourceName getBlockedCallingName(ResourceName name) {
        if (!SynchronizationUtils.isBlocked(name)) {
            return name.addElement((ResourceNameElement)new SwitchToBlocked()).addElement((ResourceNameElement)new RemoveInliners()).addElement((ResourceNameElement)new UseTopOfStackAsCalledRoots()).addElement((ResourceNameElement)new SwitchToCalling());
        }
        return name;
    }

    public static ResourceName getBlockingCalledName(ResourceName name) {
        if (!SynchronizationUtils.isBlocking(name)) {
            return name.addElement((ResourceNameElement)new SwitchToBlocking()).addElement((ResourceNameElement)new RemoveInliners());
        }
        return name;
    }

    public static ResourceName getBlockingCallingName(ResourceName name) {
        if (!SynchronizationUtils.isBlocking(name)) {
            return name.addElement((ResourceNameElement)new SwitchToBlocking()).addElement((ResourceNameElement)new RemoveInliners()).addElement((ResourceNameElement)new UseTopOfStackAsCalledRoots()).addElement((ResourceNameElement)new SwitchToCalling());
        }
        return name;
    }

    private static boolean isBlocked(ResourceName name) {
        int blockingIndex = name.lastIndexOf(SwitchToBlocking.class);
        int blockedIndex = name.lastIndexOf(SwitchToBlocked.class);
        return blockedIndex > blockingIndex;
    }

    private static boolean isBlocking(ResourceName name) {
        int blockedIndex;
        int blockingIndex = name.lastIndexOf(SwitchToBlocking.class);
        return blockingIndex > (blockedIndex = name.lastIndexOf(SwitchToBlocked.class));
    }
}

