/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.tbs;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractTypedController;
import com.sap.jvm.profiling.controller.impl.model.tbs.CalledUtils;
import com.sap.jvm.profiling.controller.impl.model.tbs.ValueSetUtils;
import com.sap.jvm.profiling.controller.model.IncludeType;
import com.sap.jvm.profiling.controller.model.tbs.CalledFilterStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.CalledFilterTreeController;
import com.sap.jvm.profiling.controller.model.tbs.CalledMethodStatisticByClassController;
import com.sap.jvm.profiling.controller.model.tbs.CalledMethodStatisticByClassLoaderController;
import com.sap.jvm.profiling.controller.model.tbs.CalledMethodStatisticByPackageController;
import com.sap.jvm.profiling.controller.model.tbs.CalledMethodStatisticByPackageTreeController;
import com.sap.jvm.profiling.controller.model.tbs.CalledMethodStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.CalledMethodTreeController;
import com.sap.jvm.profiling.controller.model.tbs.CalledPerformanceController;
import com.sap.jvm.profiling.controller.model.tbs.CalledThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.CalledThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.CalledThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.CalledTimeSeriesController;
import com.sap.jvm.profiling.controller.model.tbs.CallingMethodStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.CallingMethodTreeController;
import com.sap.jvm.profiling.controller.model.tbs.CompiledVsInterpretedController;
import com.sap.jvm.profiling.controller.model.tbs.DetailedCompiledVsInterpretedController;
import com.sap.jvm.profiling.controller.model.tbs.MethodInvocationStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.MethodParameterStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.NativeVsNonNativeController;
import com.sap.jvm.profiling.controller.model.tbs.ParameterValueStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.ThreadAnnotationStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.ThreadIdStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.ThreadNameStatisticController;
import com.sap.jvm.profiling.controller.model.tbs.TimeSeriesController;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import java.io.IOException;

public abstract class AbstractCalledController<R extends ResourceController<T>, T extends TypedModel>
extends AbstractTypedController<T>
implements CalledPerformanceController<T, R> {
    private final boolean isCalled;

    protected AbstractCalledController(ResourceName name, ProgressReporter reporter, boolean isCalled) throws IOException {
        super(name, reporter);
        this.isCalled = isCalled;
    }

    @Override
    public CalledMethodStatisticController getSelectedCalledMethodStatistic(IncludeType type) throws IOException {
        return CalledUtils.getCalledMethodStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledMethodTreeController getSelectedCalledMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCalledMethodTree(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CallingMethodTreeController getSelectedCallingMethodTree(IncludeType type) throws IOException {
        return CalledUtils.getCallingMethodTree(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public final ThreadAnnotationStatisticController getSelectedThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadAnnotationStatistic(this.getSelectedCalledName(type), this.getResourceName(), slot);
    }

    @Override
    public ThreadIdStatisticController getSelectedThreadIdStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadIdStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController getSelectedThreadNameStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getThreadNameStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledFilterStatisticController getSelectedCalledFilterStatistic(MethodFilter[] filters, IncludeType type) throws IOException {
        return CalledUtils.getCalledFilterStatistic(this.getSelectedCalledName(type), this.getResourceName(), filters);
    }

    @Override
    public CalledFilterTreeController getSelectedCalledFilterTree(MethodFilter[] filters, IncludeType type) throws IOException {
        return CalledUtils.getCalledFilterTree(this.getSelectedCalledName(type), this.getResourceName(), filters);
    }

    @Override
    public CalledThreadAnnotationStatisticController getSelectedCalledThreadAnnotationStatistic(int slot, IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadAnnotationStatistic(this.getSelectedCalledName(type), this.getResourceName(), slot);
    }

    @Override
    public CalledThreadIdStatisticController getSelectedCalledThreadIdStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadIdStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CalledThreadNameStatisticController getSelectedCalledThreadNameStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledThreadNameStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public CallingMethodStatisticController getSelectedCallingMethodStatistic(IncludeType type) throws IOException {
        return CalledUtils.getCallingMethodStatistic(this.getSelectedCallingName(type), this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByClassController asCalledMethodStatisticByClass() throws IOException {
        return CalledUtils.asCalledMethodStatisticByClass(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByClassLoaderController asCalledMethodStatisticByClassLoader() throws IOException {
        return CalledUtils.asCalledMethodStatisticByClassLoader(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByPackageController asCalledMethodStatisticByPackage() throws IOException {
        return CalledUtils.asCalledMethodStatisticByPackage(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticByPackageTreeController asCalledMethodStatisticByPackageTree() throws IOException {
        return CalledUtils.asCalledMethodStatisticByPackageTree(this.getResourceName());
    }

    @Override
    public CalledMethodStatisticController asCalledMethodStatistic() throws IOException {
        return CalledUtils.asCalledMethodStatistic(this.getResourceName());
    }

    @Override
    public ThreadIdStatisticController asThreadIdStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadIdStatistic(this.getResourceName());
    }

    @Override
    public CalledThreadIdStatisticController asCalledThreadIdStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.asCalledThreadIdStatistic(this.getResourceName());
    }

    @Override
    public ThreadNameStatisticController asThreadNameStatistic() throws IOException {
        assert (!this.isCalled);
        return CalledUtils.asThreadNameStatistic(this.getResourceName());
    }

    @Override
    public CalledThreadNameStatisticController asCalledThreadNameStatistic() throws IOException {
        assert (this.isCalled);
        return CalledUtils.asCalledThreadNameStatistic(this.getResourceName());
    }

    @Override
    public MethodParameterStatisticController getSelectedMethodParameterStatistic(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getMethodParameterStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public ParameterValueStatisticController getSelectedParameterValueStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getParameterValueStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public MethodInvocationStatisticController getSelectedMethodInvocationStatistic(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getMethodInvocationStatistic(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public R filterByMethod(MethodFilter[] filters) throws IOException {
        return (R)CalledUtils.filterByMethod(this.getResourceName(), filters);
    }

    @Override
    public R removeInlining() throws IOException {
        return (R)CalledUtils.removedInliners(this.getResourceName());
    }

    @Override
    public R addFilterInliner(MethodFilter[] filters) throws IOException {
        return (R)CalledUtils.addFilterInliner(this.getResourceName(), filters);
    }

    @Override
    public void createSnapshot(IncludeType type, ProgressReporter reporter) throws IOException {
        CalledUtils.createSnapshot(this.getResourceName(), this.getSelectedCalledName(type), null, reporter);
    }

    @Override
    public NativeVsNonNativeController getNativeVsNonNativeController(boolean useSelection) throws IOException {
        return ValueSetUtils.getNativeVsNonNativeController(this.getCalledName(IncludeType.TOTAL, useSelection), this.getResourceName(), useSelection);
    }

    @Override
    public CompiledVsInterpretedController getCompiledVsInterpretedController(boolean useSelection) throws IOException {
        return ValueSetUtils.getCompiledVsInterpretedController(this.getCalledName(IncludeType.TOTAL, useSelection), this.getResourceName(), useSelection);
    }

    @Override
    public DetailedCompiledVsInterpretedController getDetailedCompiledVsInterpretedController(boolean useSelection) throws IOException {
        return ValueSetUtils.getDetailedCompiledVsInterpretedController(this.getCalledName(IncludeType.TOTAL, useSelection), this.getResourceName(), useSelection);
    }

    @Override
    public CalledTimeSeriesController getSelectedCalledTimeSeriesController(IncludeType type) throws IOException {
        assert (this.isCalled);
        return CalledUtils.getCalledTimeSeries(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public TimeSeriesController getSelectedTimeSeriesController(IncludeType type) throws IOException {
        assert (!this.isCalled);
        return CalledUtils.getTimeSeries(this.getSelectedCalledName(type), this.getResourceName());
    }

    @Override
    public boolean hasHeartBeat() {
        return this.getResourceName().getSession().getCapabilities().hasHeartBeatTrace();
    }
}

