/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.tbs;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.tbs.Elements;
import com.sap.jvm.profiling.controller.impl.trace.PerformanceHotspotTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.model.tbs.PerformanceHotspotModel;
import com.sap.jvm.profiling.controller.model.tbs.PerformanceHotspotSnapshotController;
import com.sap.jvm.profiling.controller.trace.PerformanceHotspotTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.command.TimeBasedSamplingConfiguration;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.event.MethodToTraceHandler;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEvent;
import com.sap.jvm.profiling.method.event.TimeBasedSamplingEventHandler;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.DisableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingResponse;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.profiling.snapshot.tbs.Elements;
import com.sap.jvm.profiling.snapshot.tbs.PerformanceHotspotSnapshot;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class PerformanceHotspotModelImpl
extends AbstractModelImpl<PerformanceHotspotSnapshot>
implements PerformanceHotspotModel,
TimeBasedSamplingEventHandler,
MethodParameterEventHandler,
SnapshotMarkerHandler,
MethodToTraceHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"Performance Hotspot Snapshot");
    private static final long NR_OF_NANO_SECONDS_PER_MILLIS = 1000000L;
    private TimeBasedSamplingConfiguration traceConfig;
    private long nrOfSamples;
    private long runningTime;
    private long runningTimeSinceLastSnapshotCreation;
    private long cpuTime;
    private long cpuTimeSinceLastSnapshotCreation;
    private long sleepingTime;
    private long sleepingTimeSinceLastSnapshotCreation;
    private long nrOfInvocations;
    private long interpretedSamples;
    private long nonInterpretedSamples;
    private long compiledOrInterpretedSamplePoints;
    private List<MethodParameterSpec> specs;
    private List<MethodParameterMethodToTraceEvent> methodsToTrace;
    private long firstSampleTime;
    private long lastTraceEnabledTime;
    private long lastSampleTime;
    private long nrOfSamplesSinceLastSnapshotCreation;
    private long nrOfInvocationsSinceLastSnapshotCreation;
    private long nrOfExitEventsPending;
    private long nrOfExitEventsPendingInLastSnapshot;

    public PerformanceHotspotModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE, controller);
    }

    @Override
    public PerformanceHotspotSnapshotController getSnapshotController(PerformanceHotspotSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreatePerformanceHotspotSnapshotController());
        ResourceManager manager = name.getResourceManager();
        PerformanceHotspotSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (PerformanceHotspotSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.PerformanceHotspotSnapshotElement snapshotElement = new Elements.PerformanceHotspotSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createPerformanceHotspotSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, this.traceConfig, isDelta ? this.nrOfSamplesSinceLastSnapshotCreation : this.nrOfSamples, isDelta ? this.runningTimeSinceLastSnapshotCreation : this.runningTime, isDelta ? this.cpuTimeSinceLastSnapshotCreation : this.cpuTime, isDelta ? this.sleepingTimeSinceLastSnapshotCreation : this.sleepingTime, isDelta ? this.nrOfInvocationsSinceLastSnapshotCreation + this.nrOfExitEventsPendingInLastSnapshot : this.nrOfInvocations, this.specs, this.methodsToTrace, startTimestamp, endTimestamp, isVirtual, (PerformanceHotspotSnapshot)parentSnapshot);
    }

    @Override
    protected synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        super.createSnapshotInternal(delta, this.lastSampleTime == 0L ? endCollectionTimeStamp : this.startTimeStamp + (this.lastSampleTime - this.lastTraceEnabledTime), stop);
        if (stop) {
            this.traceConfig = null;
        }
        this.resetStateAfterSnapshotCreation();
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        TimeBasedSamplingConfiguration config = null;
        if (response instanceof EnableTimeBasedSamplingResponse) {
            config = ((EnableTimeBasedSamplingResponse)response).getConfiguration();
        } else if (response instanceof EnableTimeBasedSamplingMptResponse) {
            config = ((EnableTimeBasedSamplingMptResponse)response).getTbsConfiguration();
        } else assert (false);
        PerformanceHotspotTraceSpec spec = this.createSpecification(config);
        return new PerformanceHotspotTraceImpl("Performance Hotspot Trace", spec, this.controller.getProfilingSession());
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected void resetCollectionState() {
        this.nrOfSamples = 0L;
        this.runningTime = 0L;
        this.cpuTime = 0L;
        this.sleepingTime = 0L;
        this.nrOfInvocationsSinceLastSnapshotCreation = 0L;
        this.nrOfSamplesSinceLastSnapshotCreation = 0L;
        this.nrOfInvocations = 0L;
        this.nrOfInvocationsSinceLastSnapshotCreation = 0L;
        this.nrOfExitEventsPending = 0L;
        this.nrOfExitEventsPendingInLastSnapshot = 0L;
        this.startTimeStamp = 0L;
        this.lastSnapshotEndTimeStamp = -1L;
        this.methodsToTrace = null;
        this.traceConfig = null;
        this.interpretedSamples = 0L;
        this.nonInterpretedSamples = 0L;
        this.compiledOrInterpretedSamplePoints = 0L;
        this.firstSampleTime = 0L;
    }

    private void resetStateAfterSnapshotCreation() {
        this.nrOfSamplesSinceLastSnapshotCreation = 0L;
        this.nrOfInvocationsSinceLastSnapshotCreation = 0L;
        this.runningTimeSinceLastSnapshotCreation = 0L;
        this.cpuTimeSinceLastSnapshotCreation = 0L;
        this.sleepingTimeSinceLastSnapshotCreation = 0L;
        this.nrOfExitEventsPendingInLastSnapshot = this.nrOfExitEventsPending;
    }

    public void handle(EnableTimeBasedSamplingResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.traceConfig = response.getConfiguration();
        }
    }

    public void handle(DisableTimeBasedSamplingResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public void handle(EnableTimeBasedSamplingMptResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.traceConfig = response.getTbsConfiguration();
            this.specs = response.getParameterSpecs();
            this.methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
        }
    }

    public void handle(DisableTimeBasedSamplingMptResponse response) {
        this.handleDisableResponse((Response)response);
    }

    public void handle(TimeBasedSamplingEvent event) {
        ++this.nrOfSamples;
        long currTime = event.getTimeStamp() / 1000000L;
        if (this.firstSampleTime == 0L) {
            this.lastTraceEnabledTime = this.firstSampleTime = currTime;
        }
        this.lastSampleTime = currTime;
        boolean hasCompiledOrInterpreted = false;
        for (int i = 0; i < event.getNrOfThreads(); ++i) {
            if (event.isSleeping(i)) {
                this.sleepingTime += event.getElapsedTime();
                this.sleepingTimeSinceLastSnapshotCreation += event.getElapsedTime();
                continue;
            }
            this.runningTime += event.getElapsedTime();
            this.runningTimeSinceLastSnapshotCreation += event.getElapsedTime();
            this.cpuTime += event.getElapsedCpuTime(i);
            this.cpuTimeSinceLastSnapshotCreation += event.getElapsedCpuTime(i);
            if (event.topIsNative(i)) continue;
            if (event.topIsInterpreter(i)) {
                ++this.interpretedSamples;
                hasCompiledOrInterpreted = true;
                continue;
            }
            if (event.topIsOther(i)) continue;
            ++this.nonInterpretedSamples;
            hasCompiledOrInterpreted = true;
        }
        if (hasCompiledOrInterpreted) {
            ++this.compiledOrInterpretedSamplePoints;
        }
        PerformanceHotspotTraceImpl traceImpl = (PerformanceHotspotTraceImpl)this.trace;
        traceImpl.setNrOfSamples(this.nrOfSamples);
        traceImpl.setSampleTime(this.lastSampleTime - this.firstSampleTime);
        int delayNonNativeSamples = 300;
        if (this.compiledOrInterpretedSamplePoints >= (long)delayNonNativeSamples) {
            double fraction = (double)this.interpretedSamples / (double)(this.interpretedSamples + this.nonInterpretedSamples);
            traceImpl.setInterpretedFraction(fraction);
        } else {
            traceImpl.setInterpretedFraction(-1.0);
        }
        ++this.nrOfSamplesSinceLastSnapshotCreation;
    }

    public boolean handle(SnapshotMarkerResponse event) {
        ProfilingTraceType type;
        boolean consumed = false;
        if (this.traceConfig != null && ((type = event.getTraceType()) == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE)) {
            this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
            this.resetStateAfterSnapshotCreation();
            consumed = true;
        }
        return consumed;
    }

    public void handle(EnableMethodParameterTraceResponse response) {
    }

    public void handle(DisableMethodParameterTraceResponse response) {
    }

    public void handle(MethodParameterEntryEvent event) {
        ++this.nrOfInvocations;
        ++this.nrOfInvocationsSinceLastSnapshotCreation;
        ++this.nrOfExitEventsPending;
    }

    public void handle(MethodParameterExitEvent event) {
        --this.nrOfExitEventsPending;
    }

    public void handle(MethodParameterApplyErrorEvent event) {
    }

    public void handle(MethodParameterNearMissEvent event) {
    }

    public void handle(MethodParameterMethodToTraceEvent event) {
        if (this.methodsToTrace != null) {
            this.methodsToTrace.add(event);
        }
    }

    public boolean providesReturnValuesInEntryEvents() {
        return false;
    }

    public ArrayList<Parameter> getReturnValuesForEntryEvent(MethodParameterEntryEvent event) {
        assert (false);
        return null;
    }

    private PerformanceHotspotTraceSpec createSpecification(TimeBasedSamplingConfiguration config) {
        PerformanceHotspotTraceSpec spec = new PerformanceHotspotTraceSpec();
        spec.ignoreSleepingThreads();
        spec.setUserFilter("**");
        if (!config.ignoreSleepingThreads()) {
            spec.reportSleepingThreads();
        }
        spec.setThreadFilter(config.getThreadFilter());
        spec.setSmooth(config.getSmooth());
        return spec;
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.PerformanceHotspotSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        return factory.createPerformanceHotspotSnapshot(id, resourceName, name, (PerformanceHotspotSnapshot)parent, isVirtual, reporter);
    }
}

