/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.tbs;

import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.tbs.Elements;
import com.sap.jvm.profiling.controller.model.tbs.CompiledVsInterpretedController;
import com.sap.jvm.profiling.controller.model.tbs.DetailedCompiledVsInterpretedController;
import com.sap.jvm.profiling.controller.model.tbs.NativeVsNonNativeController;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.SwitchToCalled;
import com.sap.jvm.profiling.snapshot.elements.SwitchToCalling;
import java.io.IOException;

public final class ValueSetUtils {
    public static NativeVsNonNativeController getNativeVsNonNativeController(ResourceName selectedName, ResourceName parent, boolean useSelection) throws IOException {
        ResourceName baseName = ValueSetUtils.getBaseName(selectedName, parent, useSelection).addElement((ResourceNameElement)new Elements.CreateNativeVsNonNativeController());
        return (NativeVsNonNativeController)ResourceControllerUtils.getResourceController(parent, baseName);
    }

    public static CompiledVsInterpretedController getCompiledVsInterpretedController(ResourceName selectedName, ResourceName parent, boolean useSelection) throws IOException {
        ResourceName baseName = ValueSetUtils.getBaseName(selectedName, parent, useSelection).addElement((ResourceNameElement)new Elements.CreateCompiledVsInterpretedController());
        return (CompiledVsInterpretedController)ResourceControllerUtils.getResourceController(parent, baseName);
    }

    public static DetailedCompiledVsInterpretedController getDetailedCompiledVsInterpretedController(ResourceName selectedName, ResourceName parent, boolean useSelection) throws IOException {
        ResourceName baseName = ValueSetUtils.getBaseName(selectedName, parent, useSelection).addElement((ResourceNameElement)new Elements.CreateDetailedCompiledVsInterpretedController());
        return (DetailedCompiledVsInterpretedController)ResourceControllerUtils.getResourceController(parent, baseName);
    }

    private static ResourceName getBaseName(ResourceName selectedName, ResourceName name, boolean useSelection) {
        if (useSelection) {
            if (ValueSetUtils.isCalled(selectedName)) {
                return selectedName;
            }
            return selectedName.addElement((ResourceNameElement)new SwitchToCalled());
        }
        if (ValueSetUtils.isCalled(name)) {
            return name;
        }
        return name.addElement((ResourceNameElement)new SwitchToCalled());
    }

    private static boolean isCalled(ResourceName name) {
        boolean result = true;
        for (ResourceNameElement element : name) {
            if (element instanceof SwitchToCalling) {
                result = false;
                continue;
            }
            if (!(element instanceof SwitchToCalled)) continue;
            result = true;
        }
        return result;
    }
}

