/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.thread;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.thread.Elements;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.impl.trace.ThreadDumpTraceImpl;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpModel;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpSnapshotController;
import com.sap.jvm.profiling.controller.trace.ThreadDumpTraceSpec;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.command.ThreadDumpConfiguration;
import com.sap.jvm.profiling.thread.event.ThreadDumpEventHandler;
import com.sap.jvm.profiling.thread.event.ThreadDumpsEvent;
import com.sap.jvm.profiling.thread.event.ThreadDumpsLastEvent;
import com.sap.jvm.profiling.thread.response.EnableThreadDumpsResponse;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ThreadDumpModelImpl
extends AbstractModelImpl<ThreadDumpSnapshot>
implements ThreadDumpEventHandler,
ThreadDumpModel,
SnapshotMarkerHandler {
    public static final String DEFAULT_SNAPSHOT_NAME = I18n._s((String)"Thread Dumps Snapshot");
    ThreadDumpConfiguration threadDumpConfig;
    List<ThreadDump> dumps = new ArrayList<ThreadDump>();
    int number;
    long duration;
    long startTime;
    long lastTimestamp;

    public ThreadDumpModelImpl(ControllerImpl controller) {
        super(ProfilingTraceType.THREAD_DUMP_TRACE, controller);
        this.resetCollectionState();
    }

    @Override
    public ThreadDumpSnapshotController getSnapshotController(ThreadDumpSnapshot snapshot) {
        ResourceName name = snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateThreadDumpSnapshotController());
        ResourceManager manager = name.getResourceManager();
        ThreadDumpSnapshotController result = null;
        ProgressReporter reporter = new ProgressReporter();
        try {
            result = (ThreadDumpSnapshotController)manager.get(name, reporter);
        }
        catch (IOException e) {
            Trace.error((Throwable)e);
        }
        reporter.finish();
        return result;
    }

    @Override
    protected String getDefaultSnapshotName() {
        return DEFAULT_SNAPSHOT_NAME;
    }

    @Override
    protected ProfilingTraceImpl createTrace(Response response) {
        ThreadDumpConfiguration config = null;
        if (response instanceof EnableThreadDumpsResponse) {
            config = ((EnableThreadDumpsResponse)response).getConfiguration();
        } else assert (false);
        ThreadDumpTraceSpec spec = new ThreadDumpTraceSpec(config);
        return new ThreadDumpTraceImpl("Thread Dump Trace", spec, this.controller.getProfilingSession());
    }

    @Override
    protected Snapshot createSnapshot(int snapshotId, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimestamp, long endTimestamp, boolean isVirtual, boolean isDelta, Snapshot parentSnapshot) {
        if (this.snapshotFactory == null) {
            this.snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        }
        Elements.ThreadDumpSnapshotElement snapshotElement = new Elements.ThreadDumpSnapshotElement(snapshotId);
        ResourceName resourceName = this.controller.getProfilingSession().getResourceManager().createResourceName((ResourceNameElement)snapshotElement);
        resourceName = resourceName.addElement((ResourceNameElement)new SnapshotEndTag());
        return this.snapshotFactory.createThreadDumpSnapshot(snapshotId, resourceName, name, startBookmark, endBookmark, startTimestamp, endTimestamp, this.dumps.toArray(new ThreadDump[0]), isVirtual);
    }

    @Override
    public synchronized void createSnapshotInternal(boolean delta, long endCollectionTimeStamp, boolean stop) {
        if (this.threadDumpConfig == null) {
            return;
        }
        super.createSnapshotInternal(delta, endCollectionTimeStamp, stop);
        if (stop) {
            this.threadDumpConfig = null;
        }
        this.dumps.clear();
    }

    public void handle(EnableThreadDumpsResponse response) {
        this.handleEnableResponse((Response)response);
        if (response.isSuccess()) {
            this.threadDumpConfig = response.getConfiguration();
            this.lastTimestamp = this.startTime = response.getTime();
        }
    }

    public void handle(ThreadDumpsEvent threadDumpsEvent) {
        ThreadDump curDump = threadDumpsEvent.getThreadDump();
        this.dumps.add(curDump);
        ++this.number;
        this.lastTimestamp = curDump.getTimeStamp();
        this.duration = threadDumpsEvent.getTime() - this.startTime;
        if (this.trace != null) {
            int quality = this.estimateQuality();
            ThreadDumpTraceImpl traceImpl = (ThreadDumpTraceImpl)this.trace;
            traceImpl.setNumberThreadDumps(this.number);
            traceImpl.setQuality(quality);
            traceImpl.setDuration(this.duration);
        }
    }

    private int estimateQuality() {
        if (this.number < 3 || this.duration < 1L) {
            return 0;
        }
        double factor = (double)this.duration / 180000.0 * (double)this.number / 10.0;
        double p = 1.0 - Math.exp(-1.6 * factor);
        double pResult = 100.0 * p;
        assert (0.0 <= pResult && pResult <= 100.0);
        if (pResult >= 90.0) {
            pResult = 100.0;
        }
        return (int)Math.round(pResult);
    }

    public void handle(ThreadDumpsLastEvent event) {
        long timestamp = Math.max(this.lastTimestamp, this.startTime);
        this.createSnapshotInternal(true, timestamp, true);
        this.resetCollectionState();
    }

    public boolean handle(SnapshotMarkerResponse event) {
        ProfilingTraceType type;
        boolean consumed = false;
        if (this.threadDumpConfig != null && ((type = event.getTraceType()) == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.THREAD_DUMP_TRACE)) {
            this.createSnapshotInternal(event.getName(), event.isDelta(), event.getCreationTimeStamp(), false);
            consumed = true;
            this.dumps.clear();
        }
        return consumed;
    }

    @Override
    protected void resetCollectionState() {
        this.dumps.clear();
        this.number = 0;
        this.startTime = 0L;
        this.duration = 0L;
    }

    @Override
    protected GenericSnapshotElement createSnapshotElement(int id) {
        return new Elements.ThreadDumpSnapshotElement(id);
    }

    @Override
    protected Snapshot createSnapshot(SnapshotFactory factory, int id, ResourceName resourceName, String name, Snapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        throw new UnsupportedOperationException();
    }
}

