/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.thread;

import com.sap.jvm.profiling.controller.impl.model.AbstractReportController;
import com.sap.jvm.profiling.controller.impl.model.thread.Elements;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpReportController;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpSnapshotController;
import com.sap.jvm.profiling.presentation.typed.Elements;
import com.sap.jvm.profiling.presentation.typed.TypedReportModel;
import com.sap.jvm.profiling.presentation.typed.thread.Elements;
import com.sap.jvm.profiling.presentation.typed.thread.ThreadDumpReportProvider;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.thread.compare.ThreadDumpCompareResult;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import com.sap.jvm.profiling.viewer.report.ReportLinkResolver;
import java.io.IOException;

public final class ThreadDumpReportControllerImpl
extends AbstractReportController
implements ThreadDumpReportController {
    private final ThreadDumpSnapshotController snapshotController;
    private ThreadDumpCompareResult compareResult;

    public ThreadDumpReportControllerImpl(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter);
        ResourceName controllerName = this.getBaseName().addElement((ResourceNameElement)new Elements.CreateThreadDumpSnapshotController());
        this.snapshotController = (ThreadDumpSnapshotController)name.getResourceManager().get(controllerName, reporter);
        this.initModel(name, reporter);
    }

    protected void initModel(ResourceName name, ProgressReporter reporter) {
        ThreadDumpReportProvider provider = null;
        try {
            provider = (ThreadDumpReportProvider)name.getResourceManager().get(name.stripLastElement().addElement((ResourceNameElement)new Elements.CreateThreadDumpReportProvider()), reporter);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        final ThreadDumpReportProvider theProvider = provider;
        TypedReportModel reportModel = (TypedReportModel)this.getModel();
        reportModel.setLinkResolver("thread-dump-lookup", new ReportLinkResolver(){

            @Override
            public ResourceName getResourceName(String location, String options) {
                int dumpIndex = Integer.parseInt(options);
                ResourceName[] dumpNames = ThreadDumpReportControllerImpl.this.snapshotController.getThreadDumpTreeControllerNames();
                return dumpNames[dumpIndex];
            }
        });
        reportModel.setLinkResolver("thread-run-lookup", new ReportLinkResolver(){

            @Override
            public ResourceName getResourceName(String location, String options) {
                ThreadDumpCompareResult compare = theProvider.getCompareResult();
                int threadIndex = Integer.parseInt(options);
                ThreadDumpItem headItem = compare.getSummary().getThreadDumps().getThreadRunHead(threadIndex);
                return ThreadDumpReportControllerImpl.this.snapshotController.getThreadRunTreeControllerName(threadIndex, headItem.getName());
            }
        });
        reportModel.setLinkHandler("method-source-lookup", provider.getLinkHandler());
    }

    @Override
    protected ResourceName getModelName() {
        return this.getBaseName().addElement((ResourceNameElement)new Elements.CreateThreadDumpReportProvider()).addElement((ResourceNameElement)new Elements.CreateTypedReportModel());
    }

    @Override
    public ThreadDumpSnapshotController getSnapshotController() {
        return this.snapshotController;
    }

    @Override
    public ThreadDumpCompareResult getCompareResult() {
        return this.compareResult;
    }
}

