/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.thread;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.model.AbstractSnapshotController;
import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.thread.Elements;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpReportController;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpSnapshotController;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpTreeController;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.ThreadRunName;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import java.io.IOException;

public class ThreadDumpSnapshotControllerImpl
extends AbstractSnapshotController<ThreadDumpSnapshot>
implements ThreadDumpSnapshotController {
    private final ThreadDumpSnapshot snapshot;

    ThreadDumpSnapshotControllerImpl(ThreadDumpSnapshot snapshot) {
        super(snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateThreadDumpSnapshotController()));
        this.snapshot = snapshot;
    }

    @Override
    public ThreadDumpSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public ThreadDumpTreeController getThreadDumpTreeController(int dumpIndex) throws IOException {
        return (ThreadDumpTreeController)this.getResourceControllerImpl((ResourceNameElement)new Elements.CreateThreadDumpTreeController(dumpIndex));
    }

    @Override
    public ResourceName[] getThreadDumpTreeControllerNames() {
        ResourceName[] result = new ResourceName[this.snapshot.getNumThreadDumps()];
        ResourceName parent = this.getResourceName();
        for (int dumpIndex = 0; dumpIndex < result.length; ++dumpIndex) {
            ResourceName tmpName = parent.stripLastElement();
            result[dumpIndex] = tmpName = tmpName.addElement((ResourceNameElement)new Elements.CreateThreadDumpTreeController(dumpIndex));
        }
        return result;
    }

    @Override
    public ThreadDumpReportController getThreadDumpReportController() throws IOException {
        return (ThreadDumpReportController)this.getResourceControllerImpl((ResourceNameElement)new Elements.CreateThreadDumpReportController());
    }

    @Override
    public ResourceName getThreadRunTreeControllerName(int threadIndex, UTF8String threadName) {
        ResourceName parent = this.getResourceName();
        ResourceName tmpName = parent.stripLastElement();
        tmpName = tmpName.addElement((ResourceNameElement)new ThreadRunName(threadName)).addElement((ResourceNameElement)new Elements.CreateThreadRunTreeController(threadIndex));
        return tmpName;
    }

    private ResourceController<?> getResourceControllerImpl(ResourceNameElement toAdd) throws IOException {
        ResourceName parent = this.getResourceName();
        ResourceName tmpName = parent.stripLastElement();
        tmpName = tmpName.addElement(toAdd);
        return ResourceControllerUtils.getResourceController(parent, tmpName);
    }
}

