/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.thread;

import com.sap.jvm.profiling.controller.impl.model.ResourceControllerUtils;
import com.sap.jvm.profiling.controller.impl.model.thread.AbstractThreadDumpTreeController;
import com.sap.jvm.profiling.controller.impl.model.thread.Elements;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpSnapshotController;
import com.sap.jvm.profiling.controller.model.thread.ThreadDumpTreeController;
import com.sap.jvm.profiling.presentation.typed.Elements;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.thread.Elements;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.elements.ThreadRunName;
import com.sap.jvm.profiling.snapshot.thread.Elements;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.snapshot.thread.compare.ThreadDumpCompareResult;
import com.sap.jvm.profiling.thread.ThreadDumpItem;
import java.io.IOException;

public final class ThreadDumpTreeControllerImpl
extends AbstractThreadDumpTreeController<ThreadDumpTreeController, TypedTreeModel>
implements ThreadDumpTreeController {
    ThreadDumpSnapshotController snapshotController;

    public ThreadDumpTreeControllerImpl(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter);
    }

    @Override
    protected ResourceName getModelName() {
        int dumpIndex = this.retrieveDumpIndex();
        return this.getBaseName().addElement((ResourceNameElement)new Elements.CreateThreadDumpTreeProvider(dumpIndex)).addElement((ResourceNameElement)new Elements.CreateTypedTreeModel());
    }

    @Override
    public int retrieveDumpIndex() {
        Elements.CreateThreadDumpTreeController createController = (Elements.CreateThreadDumpTreeController)this.getResourceName().getLastElement();
        return createController.getId();
    }

    @Override
    public ThreadDumpTreeController getThreadRunController(int dumpIndex, ThreadDumpItem item) throws IOException {
        ProgressReporter reporter = new ProgressReporter();
        ThreadDumpSnapshot snapshot = (ThreadDumpSnapshot)SnapshotResourceManagerFactory.get(this.getBaseName().getSession()).getSnapshot(this.getBaseName());
        ThreadDumpCompareResult compareResult = (ThreadDumpCompareResult)this.getBaseName().getResourceManager().get(snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateThreadDumpCompareResult()), reporter);
        reporter.finish();
        int threadRunIndex = compareResult.getSummary().getThreadDumps().threadIndex2ThreadRunIndex(dumpIndex, item.getThreadIndex());
        ResourceName threadRunControllerName = this.getResourceName().addElement((ResourceNameElement)new ThreadRunName(item.getName())).addElement((ResourceNameElement)new Elements.CreateThreadRunTreeController(threadRunIndex));
        return (ThreadDumpTreeController)ResourceControllerUtils.getResourceController(this.getResourceName(), threadRunControllerName);
    }

    @Override
    public ThreadDumpSnapshotController getSnapshotController() {
        assert (false);
        return this.snapshotController;
    }

    @Override
    public boolean isThreadRunBased() {
        return false;
    }

    @Override
    public ThreadDumpTreeController getThreadDumpController(int dumpIndex) throws IOException {
        assert (false);
        return null;
    }
}

