/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.workspace;

import com.sap.jvm.profiling.controller.impl.model.workspace.LaunchConfigurationWorkspaceLocationImpl;
import com.sap.jvm.profiling.controller.model.workspace.InconsistentWorkspaceException;
import com.sap.jvm.profiling.controller.model.workspace.LaunchConfigurationWorkspace;
import com.sap.jvm.profiling.controller.model.workspace.LaunchConfigurationWorkspaceLocation;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class LaunchConfigurationWorkspaceImpl
implements LaunchConfigurationWorkspace {
    private static final String CONFIG_REMOVED_FILE_NAME = ".removed";
    private static final String VERSION = "2.4.14";
    private static final String PROP_FILE = "properties.xml";
    private static final String PROP_WP_CREATION_VERSION = "WorkSpaceCreationVersion";
    private static final String PROP_WP_LASMOD_VERSION = "WorkSpaceLastModificationVersion";
    private LaunchConfigurationWorkspace.VersionState state = LaunchConfigurationWorkspace.VersionState.UNDEFINED;
    private File propsFile;
    private Properties workspaceProps = new Properties();
    private File workspaceDirectory;

    public LaunchConfigurationWorkspaceImpl(File workspaceDirectory) throws InconsistentWorkspaceException {
        this.workspaceDirectory = workspaceDirectory;
        if (!workspaceDirectory.exists()) {
            throw new InconsistentWorkspaceException("The specified workspace directory does not exist!");
        }
        try {
            this.propsFile = new File(workspaceDirectory, PROP_FILE);
            if (!this.propsFile.exists()) {
                this.workspaceProps.put(PROP_WP_CREATION_VERSION, VERSION);
                this.saveCache();
            } else {
                this.workspaceProps.loadFromXML(new FileInputStream(this.propsFile));
                WPVersion v1 = new WPVersion(VERSION);
                WPVersion v2 = new WPVersion(this.workspaceProps.getProperty(PROP_WP_LASMOD_VERSION));
                if (v2.isGreater(v1)) {
                    this.state = LaunchConfigurationWorkspace.VersionState.LOWER;
                    Trace.error((String)"The current workspace was created by a newer profiler release! This can lead to severe runtime problems. Please use a different workspace.");
                } else if (v1.isGreater(v2)) {
                    this.state = LaunchConfigurationWorkspace.VersionState.HIGHER;
                    Trace.debug(() -> "The current workspace was created by a lower profiler version (" + v2.toString() + ")");
                } else {
                    this.state = LaunchConfigurationWorkspace.VersionState.CURRENT;
                }
            }
        }
        catch (Exception e) {
            throw new InconsistentWorkspaceException("Canot handle the external file cache file!", e);
        }
    }

    @Override
    public LaunchConfigurationWorkspace.VersionState getVersionState() {
        return this.state;
    }

    @Override
    public File getConfigTempDir(String cfgName, String cfgId) {
        File tempFile = new File(this.getWorkspaceLocation(cfgName, cfgId).getWorkinDirectory(), "temp");
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        return tempFile;
    }

    @Override
    public List<LaunchConfigurationWorkspaceLocation> getAllWorkspaceConfigurations() {
        ArrayList<LaunchConfigurationWorkspaceLocation> result = new ArrayList<LaunchConfigurationWorkspaceLocation>();
        for (File cfgDir : this.workspaceDirectory.listFiles()) {
            if (!cfgDir.isDirectory()) continue;
            for (File launchDir : cfgDir.listFiles()) {
                if (!launchDir.isDirectory() || launchDir.getName().equals("temp")) continue;
                LaunchConfigurationWorkspaceLocationImpl wpLocation = new LaunchConfigurationWorkspaceLocationImpl(cfgDir, launchDir.getName(), this);
                File workingDirectory = wpLocation.getWorkinDirectory();
                File file = new File(workingDirectory, CONFIG_REMOVED_FILE_NAME);
                if (file.exists()) {
                    this.removeConfigurationFiles(wpLocation.getConfigurationName(), wpLocation.getConfigurationId());
                    continue;
                }
                result.add(wpLocation);
            }
        }
        return result;
    }

    @Override
    public LaunchConfigurationWorkspaceLocation getWorkspaceLocation(String cfgName, String cfgId) {
        return new LaunchConfigurationWorkspaceLocationImpl(new File(this.workspaceDirectory, cfgName), cfgId, this);
    }

    @Override
    public File getWorkspaceDirectory(String cfgName) {
        return new File(this.workspaceDirectory, cfgName);
    }

    @Override
    public File getWorkspaceDirectory(String cfgName, String cfgId) {
        return new File(this.getWorkspaceDirectory(cfgName), cfgId);
    }

    @Override
    public String getExternProfilingFileLocation(String cfgId) {
        return this.workspaceProps.getProperty(cfgId);
    }

    @Override
    public void removeExternProfilingFileLocation(String cfgId) {
        this.workspaceProps.remove(cfgId);
        this.saveCache();
    }

    @Override
    public void saveExternProfilingFileLocation(String cfgId, String path) {
        this.workspaceProps.put(cfgId, path);
        this.saveCache();
    }

    @Override
    public void markAsValid() {
        this.saveCache();
    }

    private void saveCache() {
        FileOutputStream fos = null;
        try {
            this.workspaceProps.put(PROP_WP_LASMOD_VERSION, VERSION);
            fos = new FileOutputStream(this.propsFile);
            this.workspaceProps.storeToXML(fos, "Last Modified. " + new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss").format(new Date()));
        }
        catch (Exception e) {
            Trace.error((Throwable)e, (String)"Cannot save the external file cache file!");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    Trace.error((Throwable)e, (String)"Closing external file cache file failed!");
                }
            }
        }
    }

    @Override
    public void removeConfigurationFiles(String configName, String configId) {
        boolean success;
        File sessionDir = this.getWorkspaceDirectory(configName, configId);
        if (sessionDir != null && !(success = this.remove(sessionDir))) {
            try {
                success = new File(sessionDir, CONFIG_REMOVED_FILE_NAME).createNewFile();
                if (!success) {
                    Trace.warn(() -> "Cannot create '.removed' file for configuration \"" + configName + "\".");
                }
            }
            catch (IOException ex) {
                Trace.warn((Throwable)ex, () -> "Cannot write '.removed' file for configuration \"" + configName + "\".");
            }
        }
        File cfgDir = this.getWorkspaceDirectory(configName);
        cfgDir.delete();
    }

    private boolean remove(File file) {
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.remove(subFile);
            }
        }
        return file.delete();
    }

    private static class WPVersion {
        String version;
        int major;
        int minor;
        int micro;

        WPVersion(String version) {
            this.version = version;
            String[] tmp = version.split("\\.");
            this.major = Integer.parseInt(tmp[0]);
            this.minor = Integer.parseInt(tmp[1]);
            this.micro = Integer.parseInt(tmp[2]);
        }

        boolean isGreater(WPVersion v2) {
            return this.major > v2.major || v2.major == this.major && this.minor > v2.minor || v2.major == this.major && v2.minor == this.minor && this.micro > v2.micro;
        }

        public String toString() {
            return this.version;
        }
    }
}

