/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.model.workspace;

import com.sap.jvm.profiling.controller.model.workspace.LaunchConfigurationWorkspace;
import com.sap.jvm.profiling.controller.model.workspace.LaunchConfigurationWorkspaceLocation;
import java.io.File;

public class LaunchConfigurationWorkspaceLocationImpl
implements LaunchConfigurationWorkspaceLocation {
    public static final String PROFILING_DATA = "profilingData.prf";
    private String name;
    private String id;
    private File prfFile;
    private File launchDir;
    private String cfgDir;
    private LaunchConfigurationWorkspace workSpace;

    public LaunchConfigurationWorkspaceLocationImpl(File cfgDir, String id, LaunchConfigurationWorkspace wp) {
        this.name = cfgDir.getName();
        this.cfgDir = cfgDir.getPath();
        this.id = id;
        this.launchDir = new File(cfgDir, id);
        this.prfFile = new File(this.launchDir, PROFILING_DATA);
        this.workSpace = wp;
        if (!this.launchDir.exists()) {
            this.launchDir.mkdirs();
        }
    }

    @Override
    public String getConfigurationName() {
        return this.name;
    }

    @Override
    public String getConfigurationId() {
        return this.id;
    }

    @Override
    public File getPrfFile() {
        String extPath;
        if (!this.prfFile.exists() && (extPath = this.workSpace.getExternProfilingFileLocation(this.id)) != null) {
            this.prfFile = new File(extPath);
        }
        return this.prfFile;
    }

    @Override
    public File getWorkinDirectory() {
        return this.launchDir;
    }

    @Override
    public String getWorkinDirectoryAsString() {
        return this.launchDir.getAbsolutePath();
    }

    @Override
    public String getConfigDirectory() {
        return this.cfgDir;
    }
}

