/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.AlertsController;
import com.sap.jvm.profiling.controller.RemoteController;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.model.alerts.CreateAlertsController;
import com.sap.jvm.profiling.controller.impl.resource.ChunkHeaderMetaData;
import com.sap.jvm.profiling.controller.impl.resource.ControllerResourceUtil;
import com.sap.jvm.profiling.controller.impl.resource.OfflineResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ProfilingSessionWriter;
import com.sap.jvm.profiling.controller.impl.resource.ResourceDataProvider;
import com.sap.jvm.profiling.controller.impl.resource.ResourceNameElementsHandler;
import com.sap.jvm.profiling.controller.impl.resource.ResourceNameImpl;
import com.sap.jvm.profiling.controller.impl.resource.ResourceReaderImpl;
import com.sap.jvm.profiling.controller.impl.resource.ResourceStore;
import com.sap.jvm.profiling.controller.impl.resource.ResourceUtils;
import com.sap.jvm.profiling.controller.impl.resource.ResourceWriterImpl;
import com.sap.jvm.profiling.controller.impl.resource.SnpOfflineResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.Task;
import com.sap.jvm.profiling.controller.impl.resource.TaskManager;
import com.sap.jvm.profiling.controller.impl.resource.ViewStateStore;
import com.sap.jvm.profiling.controller.model.Model;
import com.sap.jvm.profiling.controller.model.SnapshotController;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.resource.PresentationResourceUtil;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceHandler;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotDefiningElement;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResouceUtil;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.persistence.VersionMismatchException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class AbstractResourceManagerImpl<T extends TypedModel>
implements ResourceManager,
SnapshotResourceManager {
    public static final String EVENT_INFO_FILENAME = "events.tmp";
    public static final String MAP_INFO_FILENAME = "mapInfo.tmp";
    public static final String TRACE_HISTORY_FILENAME = "trcHistory.tmp";
    public static final String HEART_BEAT_INFO_FILENAME = "heartBeat.tmp";
    public static final String ALERTS_INFO_FILENAME = "alerts.tmp";
    public static final String CONTROLLER_PROPERTIES_FILENAME = "controllerProps.tmp";
    public static final String STACK_TRACE_ID_2_INDEX_FILENAME = "id2index.map";
    public static final String SAVED_FILENAME = ".saved";
    public static final String RECOVER_FILENAME = ".recover";
    protected static final String RESOURCE_FILE_PREFIX = "resource";
    protected static final String ALLOCATION_RESOURCE_FILE_PREFIX = "alloc_snapshot";
    protected static final String PERFORMANCE_RESOURCE_FILE_PREFIX = "perf_snapshot";
    protected static final String MPT_RESOURCE_FILE_PREFIX = "mpt_snaphot";
    protected static final String SYNCHRONIZATION_RESOURCE_FILE_PREFIX = "sync_snaphot";
    protected static final String IO_RESOURCE_FILE_PREFIX = "io_snaphot";
    protected static final String NET_RESOURCE_FILE_PREFIX = "net_snaphot";
    protected static final String HPROF_DUMP_RESOURCE_FILE_PREFIX = "hprof_snaphot";
    protected static final String CLASS_STATISITC_DUMP_RESOURCE_FILE_PREFIX = "class_statistic_snaphot";
    protected static final String THREAD_DUMP_RESOURCE_FILE_PREFIX = "thread_dump_snapshot";
    protected static final String GC_RESOURCE_FILE_PREFIX = "gc_snaphot";
    protected static final String GC_HISTORY_FILE_DUMP_RESOURCE_FILE_PREFIX = "gc_history_snaphot";
    private static boolean useResourceCache = true;
    private static final boolean traceMapOperations = System.getProperty("com.sap.jvm.profiling.traceResourceManagerMap", "false").equals("true");
    protected final String eventFilename;
    protected final String heartBeatFilename;
    protected final String alertsFilename;
    protected final String stackIdBackupFileName;
    protected RandomAccessFile stackIdBackupFile;
    protected ResourceWriterImpl eventWriter;
    protected ResourceWriterImpl heartBeatWriter;
    protected ResourceWriterImpl alertsWriter;
    protected ResourceStore eventStore;
    protected ResourceStore heartBeatStore;
    protected ResourceStore alertsStore;
    protected String sessionDirectory;
    protected ControllerImpl controller;
    protected ProfilingSession session;
    protected Map<ResourceName, ResourceData> resourceMap;
    protected TaskManager taskManager;
    protected ViewStateStore viewStateStore;
    protected ChunkHeaderMetaData[] eventMetaData;
    protected long nrOfEventPackets;
    protected int nextUniqueResourceId;
    private ResourceNameElementsHandler elementsHandler;
    private final WeakHashMap<ResourceNameElement, WeakReference<ResourceNameElement>> elements;
    private boolean closed;
    private final Set<ResourceName> creatingResources;
    protected boolean noResourceQueriesAllowed;
    private File tempDirectory;

    public AbstractResourceManagerImpl(ControllerImpl controller, String sessionDirectory, File tempDirectory) throws IOException {
        this.controller = controller;
        this.session = controller.getProfilingSession();
        this.sessionDirectory = sessionDirectory;
        this.tempDirectory = tempDirectory;
        File file = new File(sessionDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.eventFilename = sessionDirectory + File.separator + EVENT_INFO_FILENAME;
        this.heartBeatFilename = sessionDirectory + File.separator + HEART_BEAT_INFO_FILENAME;
        this.alertsFilename = sessionDirectory + File.separator + ALERTS_INFO_FILENAME;
        this.stackIdBackupFileName = sessionDirectory + File.separator + STACK_TRACE_ID_2_INDEX_FILENAME;
        this.resourceMap = new HashMap<ResourceName, ResourceData>();
        this.taskManager = new TaskManager();
        this.nextUniqueResourceId = 1;
        this.elementsHandler = ResourceNameElementsHandler.getInstance();
        SnapshotResourceManagerFactory.set(this.session, this);
        this.elements = new WeakHashMap();
        this.creatingResources = Collections.synchronizedSet(new HashSet());
    }

    public ControllerImpl getController() {
        return this.controller;
    }

    public PacketResourceWriter getEventWriter() {
        return this.eventWriter;
    }

    public PacketResourceWriter getHeartBeatWriter() {
        return this.heartBeatWriter;
    }

    public PacketResourceWriter getAlertsWriter() {
        return this.alertsWriter;
    }

    public ProfilingReader getEventReader() {
        try {
            if (this.eventWriter != null) {
                this.eventWriter.flush();
            }
            ResourceReaderImpl packetReader = new ResourceReaderImpl(0L, -1L, this.eventStore.asDataProvider(), this.controller, null);
            return this.session.getReader((PacketResourceReader)packetReader, null);
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Could not get event reader");
            return null;
        }
    }

    public ProfilingReader getEventReader(Bookmark start, Bookmark end, ThreadFilter threadFilter, ProgressReporter reporter) throws OperationCanceledException {
        try {
            long nrOfThreadInfoPacketsToSkip;
            if (this.eventWriter != null) {
                this.eventWriter.flush();
            }
            ResourceDataProvider dataProvider = this.eventStore.asDataProvider();
            if (end.getNrOfReadEvents() > this.nrOfEventPackets) {
                reporter.setWork(I18n._s((String)"Scanning the snapshot (<%> %)"), dataProvider.length());
                this.eventMetaData = ResourceReaderImpl.generateChunkHeaderMetaData(dataProvider, reporter);
                this.nrOfEventPackets = 0L;
                for (int i = 0; i < this.eventMetaData.length; ++i) {
                    this.nrOfEventPackets += (long)this.eventMetaData[i].getNrOfPackets();
                }
                dataProvider.seek(0L);
            }
            ResourceReaderImpl packetReader = new ResourceReaderImpl(start.getNrOfReadEvents(), end.getNrOfReadEvents() - start.getNrOfReadEvents() + 1L, dataProvider, this.controller, this.eventMetaData);
            ProfilingReader reader = this.session.getReader((PacketResourceReader)packetReader, threadFilter);
            long nrOfStartPacketsToSkip = packetReader.getNrOfPacketsToSkip();
            assert (nrOfThreadInfoPacketsToSkip <= nrOfStartPacketsToSkip);
            for (nrOfThreadInfoPacketsToSkip = packetReader.getNrOfThreadInfoPacketsToSkip(); nrOfThreadInfoPacketsToSkip > 0L; --nrOfThreadInfoPacketsToSkip) {
                reader.nextPacket();
                --nrOfStartPacketsToSkip;
            }
            packetReader.skipInitialContinuedPacket();
            while (nrOfStartPacketsToSkip > 0L) {
                reader.nextPacket();
                --nrOfStartPacketsToSkip;
            }
            return reader;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Could not get event reader");
            return null;
        }
    }

    public ResourceWriterImpl getWriter(ResourceName resourceName) throws IOException {
        int uniqueResourceId = this.getUniqueResourceIdentifier(resourceName);
        String filename = this.getFilename(resourceName, uniqueResourceId);
        short type = ResourceUtils.isSnapshotName(resourceName) ? (short)5002 : 5004;
        ResourceWriterImpl retValue = new ResourceWriterImpl(filename, this.session, type, 1, false);
        retValue.initializePacket((short)30000);
        resourceName.write((ResourceWriter)retValue);
        retValue.writeInt32(uniqueResourceId);
        return retValue;
    }

    public String getAddonPrefix(ResourceName name) {
        return this.getFilename(name, this.getUniqueResourceIdentifier(name)) + "_addon";
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    private String getFilename(ResourceName resourceName, int id) {
        String resourceFileName = RESOURCE_FILE_PREFIX;
        if (ResourceUtils.isSnapshotRelated(resourceName)) {
            Snapshot snapshot = this.getSnapshot(resourceName);
            assert (snapshot != null);
            resourceFileName = this.getResourceFilenamePrefix(snapshot.getType()) + "_" + snapshot.getId();
        }
        return ResourceUtils.isSnapshotName(resourceName) ? this.sessionDirectory + File.separator + resourceFileName : this.sessionDirectory + File.separator + resourceFileName + "_" + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource get(ResourceName name, ProgressReporter progressReporter) throws IOException {
        int id;
        assert (!this.noResourceQueriesAllowed);
        Resource resource = this.getResource(name);
        if (resource != null) {
            return resource;
        }
        ResourceHandler resourceHandler = this.getHandler(name);
        if (resourceHandler == null) {
            throw new IOException("Could not get resource handler for " + name);
        }
        ResourceData resourceData = null;
        if (useResourceCache) {
            resourceData = this.getResourceFromFileSystem(name, resourceHandler, progressReporter);
        }
        if (resourceData != null) {
            return this.storeResource(resourceData.resource, resourceData.id);
        }
        Resource retValue = null;
        boolean doCreate = false;
        Object object = this;
        synchronized (object) {
            id = this.getUniqueResourceIdentifier(name);
            this.storeResource(name, id);
            resourceData = this.resourceMap.get(name);
        }
        object = resourceData;
        synchronized (object) {
            if (resourceData.resource != null) {
                resourceData.notifyAll();
                return resourceData.resource;
            }
            doCreate = this.creatingResources.add(name);
        }
        while (retValue == null) {
            if (doCreate) {
                IOException toThrow = null;
                try {
                    retValue = resourceHandler.create(name, progressReporter);
                }
                catch (IOException e) {
                    toThrow = e;
                }
                catch (Throwable t) {
                    toThrow = new IOException("Creating " + name + " failed");
                    toThrow.initCause(t);
                }
                if (toThrow == null && retValue == null) {
                    toThrow = new IOException("Creating " + name + " returned null");
                }
                if (toThrow != null) {
                    ResourceData t = resourceData;
                    synchronized (t) {
                        this.creatingResources.remove(name);
                        resourceData.notifyAll();
                    }
                    throw toThrow;
                }
                retValue = this.storeResource(retValue, id);
                ResourceData t = resourceData;
                synchronized (t) {
                    assert (resourceData.resource != null);
                    resourceData.notifyAll();
                    this.creatingResources.remove(name);
                    continue;
                }
            }
            object = resourceData;
            synchronized (object) {
                doCreate = this.creatingResources.add(name);
                long simulatedWork = 0L;
                long alreadySimulated = 0L;
                while (!doCreate && resourceData.resource == null) {
                    try {
                        if (simulatedWork - 100L <= alreadySimulated) {
                            progressReporter.addWork(I18n._s((String)"Waiting for other view to load ..."), simulatedWork += 100L);
                        }
                        ++alreadySimulated;
                        progressReporter.reportNext();
                        resourceData.wait(1000L);
                        doCreate = this.creatingResources.add(name);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                retValue = resourceData.resource;
            }
        }
        this.taskManager.add(new ResourceWriteTask(resourceHandler, name, retValue));
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource get(int id, ProgressReporter progressReporter) throws IOException {
        if (this.noResourceQueriesAllowed) {
            return null;
        }
        ResourceName resourceName = null;
        AbstractResourceManagerImpl abstractResourceManagerImpl = this;
        synchronized (abstractResourceManagerImpl) {
            for (Map.Entry<ResourceName, ResourceData> current : this.resourceMap.entrySet()) {
                if (current.getValue().id != id) continue;
                if (current.getValue().resource != null) {
                    return current.getValue().resource;
                }
                resourceName = current.getKey();
                break;
            }
        }
        if (resourceName == null) {
            return null;
        }
        return this.get(resourceName, progressReporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceNameElement readResourceNameElement(ResourceReader reader) throws IOException {
        ResourceNameElement result = this.elementsHandler.readElement(reader);
        WeakHashMap<ResourceNameElement, WeakReference<ResourceNameElement>> weakHashMap = this.elements;
        synchronized (weakHashMap) {
            ResourceNameElement orig;
            WeakReference<ResourceNameElement> ref = this.elements.get(result);
            if (ref != null && (orig = (ResourceNameElement)ref.get()) != null) {
                return orig;
            }
            this.elements.put(result, new WeakReference<ResourceNameElement>(result));
        }
        return result;
    }

    public void writeResourceNameElement(ResourceNameElement element, ResourceWriter writer) throws IOException {
        this.elementsHandler.writeElement(element, writer);
    }

    public ResourceNameImpl createResourceName(ResourceNameElement element) {
        return new ResourceNameImpl(this.controller, element);
    }

    public void writeEventInfo(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        if (this.eventWriter != null) {
            this.eventWriter.flush();
        }
        this.eventStore.copyContent(file, this.controller instanceof RemoteController, reporter);
    }

    public void writeHeartBeatInfo(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        if (this.heartBeatWriter != null) {
            this.heartBeatWriter.flush();
        }
        this.heartBeatStore.copyContent(file, this.controller instanceof RemoteController, reporter);
    }

    public void writeAlertsInfo(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        if (this.alertsWriter != null) {
            this.alertsWriter.flush();
        }
        if (this.alertsStore != null) {
            this.alertsStore.copyContent(file, this.controller instanceof RemoteController, reporter);
        }
    }

    public synchronized RandomAccessFile getStackTraceIdFile() {
        try {
            this.stackIdBackupFile = new RandomAccessFile(this.stackIdBackupFileName, "rw");
            return this.stackIdBackupFile;
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Cannot create the stack trace id2index file.");
            throw new RuntimeException("Cannot create the stack trace id2index file");
        }
    }

    public void removeStackTraceIdFile() {
        if (this.stackIdBackupFile != null) {
            try {
                this.stackIdBackupFile.close();
            }
            catch (IOException ex) {
                Trace.warn((Throwable)ex, (String)"Error during closing stack trace id2index file.");
            }
        }
        new File(this.stackIdBackupFileName).delete();
    }

    public synchronized void removeSnapshot(Snapshot snapshot) {
        ResourceName snapshotName = snapshot.asResourceName();
        ResourceName controllerName = ResourceUtils.getControllerName(snapshot);
        ResourceData snpData = this.resourceMap.get(controllerName);
        this.viewStateStore.closed(snpData.id);
        LinkedList<ResourceName> toRemove = new LinkedList<ResourceName>();
        for (Map.Entry<ResourceName, ResourceData> entry : this.resourceMap.entrySet()) {
            File file;
            if (!snapshotName.equals((Object)ResourceUtils.getSnapshotName(entry.getKey()))) continue;
            ResourceStore store = entry.getValue().store;
            if (store != null && (OfflineResourceManagerImpl.isResource((file = new File(store.getFilename())).getName()) || OfflineResourceManagerImpl.isSnapshotResource(file.getName()))) {
                if (!file.delete()) {
                    Trace.warn(() -> "Cannot remove file: " + file.getName());
                }
                if (ResourceUtils.isSnapshotControllerName(entry.getKey())) {
                    this.viewStateStore.removeInvalidSnpEntry(entry.getValue().id);
                }
            }
            toRemove.add(entry.getKey());
        }
        for (ResourceName resourceName : toRemove) {
            this.traceMap(resourceName, "remove");
            this.resourceMap.remove(resourceName);
        }
    }

    public synchronized ResourceName[] getSnapshotResourceNames() {
        ArrayList<ResourceName> snapshotResourceNames = new ArrayList<ResourceName>();
        for (ResourceName resourceName : this.resourceMap.keySet()) {
            if (!ResourceUtils.isSnapshotName(resourceName)) continue;
            snapshotResourceNames.add(resourceName);
        }
        ResourceName[] retValue = new ResourceName[snapshotResourceNames.size()];
        retValue = snapshotResourceNames.toArray(retValue);
        return retValue;
    }

    public synchronized ResourceName[] getStatisticResourceNames() {
        ArrayList<ResourceName> statisticResourceNames = new ArrayList<ResourceName>();
        for (ResourceName resourceName : this.resourceMap.keySet()) {
            if (ResourceUtils.isSnapshotName(resourceName)) continue;
            statisticResourceNames.add(resourceName);
        }
        ResourceName[] retValue = new ResourceName[statisticResourceNames.size()];
        retValue = statisticResourceNames.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResource(ResourceName resourceName, RandomAccessFile file, ProgressReporter reporter) throws IOException {
        this.taskManager.waitForFinish();
        AbstractResourceManagerImpl abstractResourceManagerImpl = this;
        synchronized (abstractResourceManagerImpl) {
            ResourceData resourceData = this.resourceMap.get(resourceName);
            if (resourceData != null && resourceData.store != null) {
                resourceData.store.copyContent(file, reporter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResource(ResourceName resourceName, ProgressReporter reporter) throws IOException {
        ResourceData resourceData;
        ResourceWriterImpl writer = null;
        ResourceHandler handler = null;
        Resource resource = null;
        AbstractResourceManagerImpl abstractResourceManagerImpl = this;
        synchronized (abstractResourceManagerImpl) {
            resourceData = this.resourceMap.get(resourceName);
            resource = resourceData.resource;
            if (resource == null || !resource.isModifiable()) {
                return;
            }
            writer = this.getWriter(resourceName);
            handler = this.getHandler(resourceName);
        }
        handler.write(resourceName, resource, (ResourceWriter)writer, reporter);
        writer.close();
        abstractResourceManagerImpl = this;
        synchronized (abstractResourceManagerImpl) {
            resourceData = this.resourceMap.get(resourceName);
            resource = resourceData.resource;
            if (resource == null || !resource.isModifiable()) {
                return;
            }
            resourceData.store = new ResourceStore(writer.getFilename());
        }
    }

    public void writeViewState(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        this.viewStateStore.writePayload(file, reporter);
    }

    public synchronized ResourceName getParent(ResourceName child) {
        ResourceData resourceData = this.resourceMap.get(child);
        if (resourceData == null) {
            return null;
        }
        int childId = resourceData.id;
        assert (childId > 0);
        int parentId = this.viewStateStore.getParent(childId);
        if (parentId < 0) {
            return null;
        }
        for (Map.Entry<ResourceName, ResourceData> entry : this.resourceMap.entrySet()) {
            if (entry.getValue().id != parentId) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized void setParent(ResourceName parent, ResourceName child) {
        ResourceData parentResourceData = this.resourceMap.get(parent);
        int parentId = parentResourceData.id;
        assert (parentId > 0);
        ResourceData childResourceData = this.resourceMap.get(child);
        int childId = childResourceData.id;
        assert (childId > 0);
        this.viewStateStore.setParent(parentId, childId, ResourceUtils.isSnapshotControllerName(child));
    }

    public synchronized int getId(Resource resource) {
        ResourceData resourceData = this.resourceMap.get(resource.getResourceName());
        assert (resourceData != null);
        return resourceData.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWriters() {
        try {
            if (this.eventWriter != null && !this.eventWriter.isClosed()) {
                try {
                    this.eventWriter.close();
                }
                catch (IOException ex) {
                    Trace.error((Throwable)ex, (String)"Error while closing the event writer");
                }
            }
        }
        finally {
            this.eventWriter = null;
            try {
                if (this.heartBeatWriter != null && !this.heartBeatWriter.isClosed()) {
                    try {
                        this.heartBeatWriter.close();
                    }
                    catch (IOException ex) {
                        Trace.error((Throwable)ex, (String)"Error while closing the heart beat writer");
                    }
                }
            }
            finally {
                this.heartBeatWriter = null;
                try {
                    if (this.alertsWriter != null && !this.alertsWriter.isClosed()) {
                        try {
                            this.alertsWriter.close();
                        }
                        catch (IOException ex) {
                            Trace.error((Throwable)ex, (String)"Error while closing the alerts writer");
                        }
                    }
                }
                finally {
                    this.alertsWriter = null;
                }
            }
        }
    }

    public void close() {
        assert (!this.closed);
        this.taskManager.stop();
        try {
            this.writeOnClose();
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Could not write offline resource");
        }
        if (this.viewStateStore != null) {
            this.viewStateStore.close();
        }
        this.removeStackTraceIdFile();
        for (ResourceName name : this.resourceMap.keySet()) {
            this.traceMap(name, "closed");
        }
        this.resourceMap.clear();
        this.closeWriters();
        this.closed = true;
    }

    @Override
    public Snapshot createSnapshot(SnapshotType type, String snapshotName, ResourceName resourceName, ResourceName parentViewName, ProgressReporter reporter) throws IOException {
        Snapshot snapshot = this.createSnapshot(type, snapshotName, resourceName, reporter);
        this.controller.snapshotCreated(snapshot, parentViewName);
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Snapshot getSnapshot(ResourceName name) {
        if (!ResourceUtils.isSnapshotRelated(name)) {
            return null;
        }
        ResourceName snapshotName = ResourceUtils.createSnapshotName(name, this.controller);
        Snapshot snapshot = this.getSnapshotInternal(snapshotName);
        if (snapshot != null) {
            return snapshot;
        }
        ResourceName parentName = ResourceUtils.getParentSnapshotName(snapshotName);
        Snapshot parentSnapshot = this.getSnapshot(parentName);
        ResourceNameElement[] nameElements = snapshotName.getElements();
        ArrayList<ResourceNameElement> filterElements = new ArrayList<ResourceNameElement>();
        for (int i = 1; i < nameElements.length - 1; ++i) {
            filterElements.add(nameElements[i]);
        }
        ProgressReporter reporter = new ProgressReporter();
        try {
            if (parentSnapshot.getType().hasExplicitStartAndStop()) {
                Model model = this.controller.getModelController().getModel(parentSnapshot.getType().getTraceType());
                Snapshot snapshot2 = ((AbstractModelImpl)model).createSnapshot("Virtual Sub Snapshot", parentSnapshot, filterElements, true, reporter);
                return snapshot2;
            }
        }
        catch (OperationCanceledException e) {
            Trace.debug((Throwable)e, (String)"Creating the snapshot was cancelled");
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Could not create the snapshot");
        }
        finally {
            reporter.finish();
        }
        return null;
    }

    @Override
    public ResourceName getBaseSnapshotName(ResourceName name) {
        SnapshotResourceManager manager = SnapshotResourceManagerFactory.get(name.getSession());
        ResourceName snapshotName = manager.getSnapshot(name).asResourceName();
        ResourceNameElement[] nameElements = snapshotName.getElements();
        ResourceName baseName = name.getResourceManager().createResourceName(nameElements[0]);
        for (int i = 1; i < nameElements.length; ++i) {
            if (!(nameElements[i] instanceof SnapshotDefiningElement)) {
                baseName = baseName.addElement(nameElements[i]);
            }
            if (nameElements[i] instanceof SnapshotEndTag) break;
        }
        return baseName;
    }

    @Override
    public Snapshot getExplicitSnapshot(ResourceName name) {
        ResourceName snapshotName = ResourceUtils.getSnapshotName(name);
        return this.getSnapshotInternal(snapshotName);
    }

    public synchronized int getNrOfSnapshots() {
        int nrOfSnapshots = 0;
        for (ResourceName name : this.resourceMap.keySet()) {
            if (!ResourceUtils.isSnapshotName(name)) continue;
            ++nrOfSnapshots;
        }
        return nrOfSnapshots;
    }

    public synchronized int getNrOfResources() {
        int nrOfResources = 0;
        for (ResourceName name : this.resourceMap.keySet()) {
            if (ResourceUtils.isSnapshotName(name)) continue;
            ++nrOfResources;
        }
        return nrOfResources;
    }

    public synchronized ResourceController<T>[] getResourceController(ProgressReporter progressReporter) throws IOException {
        ArrayList<ResourceController> retList = new ArrayList<ResourceController>();
        for (ResourceName name : this.getResourceControllerNames()) {
            Resource resource = this.get(name, progressReporter);
            retList.add((ResourceController)resource);
        }
        ResourceController[] retValue = new ResourceController[retList.size()];
        retValue = retList.toArray(retValue);
        return retValue;
    }

    public synchronized SnapshotController<?, ?>[] getSnapshotResourceController() throws IOException {
        ArrayList<SnapshotController> retList = new ArrayList<SnapshotController>();
        Snapshot[] snapshots = this.controller.getModelController().getSnapshots();
        ProgressReporter reporter = new ProgressReporter();
        for (int i = 0; i < snapshots.length; ++i) {
            ResourceName controllerName;
            SnapshotController snapshotController;
            if (snapshots[i].isVirtual() || this.viewStateStore.isClosed((snapshotController = (SnapshotController)this.get(controllerName = ResourceUtils.getControllerName(snapshots[i]), reporter)).getId()) || snapshotController.getParentName() != null) continue;
            retList.add((SnapshotController)this.get(controllerName, reporter));
        }
        reporter.finish();
        SnapshotController[] retValue = new SnapshotController[retList.size()];
        retValue = retList.toArray(retValue);
        return retValue;
    }

    public synchronized AlertsController<?> getAlertsResourceController(boolean opened) throws IOException {
        ResourceNameImpl name = this.createResourceName(new CreateAlertsController(this.controller.getId()));
        Resource resource = this.get(name, new ProgressReporter());
        assert (resource instanceof AlertsController);
        if (!(opened || this.viewStateStore.isAvailable(resource.getId()) && !this.viewStateStore.isClosed(resource.getId()))) {
            return null;
        }
        return (AlertsController)resource;
    }

    public synchronized boolean isOpen(ResourceController<T> resourceController) {
        if (this.closed) {
            return false;
        }
        ResourceData resourceData = this.resourceMap.get(resourceController.getResourceName());
        return this.viewStateStore.isOpen(resourceData.id);
    }

    public synchronized ResourceController<T>[] getChildren(ResourceController<T> resourceController) {
        if (this.closed) {
            return new ResourceController[0];
        }
        ResourceData resourceData = this.resourceMap.get(resourceController.getResourceName());
        int viewId = resourceData.id;
        ArrayList<ResourceController> childrenResources = new ArrayList<ResourceController>();
        int[] childrenIds = this.viewStateStore.getChildren(viewId);
        try {
            ProgressReporter reporter = new ProgressReporter();
            if (childrenIds.length > 0) {
                HashMap<ResourceName, ResourceData> copy = new HashMap<ResourceName, ResourceData>(this.resourceMap);
                for (Map.Entry<ResourceName, ResourceData> current : copy.entrySet()) {
                    for (int i = 0; i < childrenIds.length; ++i) {
                        if (current.getValue().id != childrenIds[i]) continue;
                        if (current.getValue().resource == null) {
                            childrenResources.add((ResourceController)this.get(current.getKey(), reporter));
                            break;
                        }
                        childrenResources.add((ResourceController)current.getValue().resource);
                        break;
                    }
                    if (childrenResources.size() != childrenIds.length) continue;
                    break;
                }
            }
            reporter.finish();
        }
        catch (IOException reporter) {
            // empty catch block
        }
        ResourceController[] retValue = new ResourceController[childrenResources.size()];
        retValue = childrenResources.toArray(retValue);
        return retValue;
    }

    public long getEventInfoPayloadLength() {
        return this.eventStore.getPayloadLength();
    }

    public long getHeartBeatInfoPayloadLength() {
        return this.heartBeatStore.getPayloadLength();
    }

    public long getAlertsInfoPayloadLength() {
        return this.alertsStore == null ? 0L : this.alertsStore.getPayloadLength();
    }

    private synchronized Resource getResource(ResourceName resourceName) {
        int resourceId;
        ResourceData resourceData = this.resourceMap.get(resourceName);
        Resource resource = resourceData == null ? null : resourceData.resource;
        int n = resourceId = resourceData == null ? -1 : resourceData.id;
        if (resource != null) {
            if (resource instanceof SnapshotController) {
                this.viewStateStore.opened(resourceId, ResourceUtils.isSnapshotControllerName(resourceName));
            }
            return resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceData getResourceFromFileSystem(ResourceName resourceName, ResourceHandler resourceHandler, ProgressReporter progressReporter) throws OperationCanceledException {
        ResourceStore resourceStore = null;
        AbstractResourceManagerImpl abstractResourceManagerImpl = this;
        synchronized (abstractResourceManagerImpl) {
            ResourceData resourceData = this.resourceMap.get(resourceName);
            if (resourceData != null) {
                resourceStore = resourceData.store;
            }
        }
        ResourceReaderImpl reader = null;
        if (resourceStore != null) {
            try {
                reader = new ResourceReaderImpl(0L, -1L, resourceStore.asDataProvider(), this.controller, null);
                boolean hasNext = reader.nextPacket();
                assert (hasNext);
                ResourceName readName = reader.readResourceName();
                int id = reader.readInt32();
                assert (resourceName.equals((Object)readName));
                assert (id >= 0);
                this.storeResource(resourceName, id);
                Resource resource = resourceHandler.read(resourceName, (ResourceReader)reader, progressReporter);
                assert (resource != null);
                ResourceData retValue = new ResourceData();
                retValue.resource = resource;
                retValue.id = id;
                ResourceData resourceData = retValue;
                return resourceData;
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (VersionMismatchException e) {
                Trace.debug((Throwable)e, () -> "Version mismatch while reading " + resourceName);
            }
            catch (Throwable t) {
                Trace.warn((Throwable)t, () -> "Could not read the resource " + resourceName);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Resource storeResource(Resource resource, int id) {
        ResourceData resourceData = this.resourceMap.get(resource.getResourceName());
        if (resourceData == null) {
            resourceData = new ResourceData();
            this.resourceMap.put(resource.getResourceName(), resourceData);
            resourceData.resource = resource;
            resourceData.id = id;
            this.traceMap(resource.getResourceName(), "store(resource, id), not present");
        } else {
            ResourceData resourceData2 = resourceData;
            synchronized (resourceData2) {
                if (resourceData.resource != null) {
                    return resourceData.resource;
                }
                resourceData.resource = resource;
                resourceData.id = id;
                this.traceMap(resource.getResourceName(), "store(resource, id), already present");
                resourceData.notifyAll();
            }
        }
        return resource;
    }

    private synchronized Resource storeResource(ResourceName name, int id) {
        ResourceData resourceData = this.resourceMap.get(name);
        if (resourceData == null) {
            assert (this.assertId(id, name));
            resourceData = new ResourceData();
            this.resourceMap.put(name, resourceData);
            resourceData.id = id;
            this.traceMap(name, "store(name, id), not present");
        } else {
            assert (this.assertId(id, name));
            if (resourceData.resource != null) {
                return resourceData.resource;
            }
            resourceData.id = id;
            this.traceMap(name, "store(name, id), already present");
        }
        return null;
    }

    private synchronized List<ResourceName> getResourceControllerNames() {
        ArrayList<ResourceName> retValue = new ArrayList<ResourceName>();
        for (ResourceName name : this.resourceMap.keySet()) {
            if (ControllerResourceUtil.getFactory().get(name) == null) continue;
            ResourceData resourceData = this.resourceMap.get(name);
            if (!this.viewStateStore.isOpen(resourceData.id)) continue;
            retValue.add(name);
        }
        return retValue;
    }

    private Snapshot createSnapshot(SnapshotType type, String name, ResourceName resourceName, ProgressReporter reporter) throws IOException {
        ResourceName snapshotName = ResourceUtils.asSnapshotName(resourceName, this.controller);
        ResourceName parentName = ResourceUtils.getSnapshotName(resourceName);
        Snapshot parentSnapshot = this.getSnapshotInternal(parentName);
        ResourceNameElement[] nameElements = snapshotName.getElements();
        ArrayList<ResourceNameElement> filterElements = new ArrayList<ResourceNameElement>();
        for (int i = 1; i < nameElements.length - 1; ++i) {
            filterElements.add(nameElements[i]);
        }
        if (type.hasExplicitStartAndStop()) {
            Model model = this.controller.getModelController().getModel(type.getTraceType());
            return ((AbstractModelImpl)model).createSnapshot(name, parentSnapshot, filterElements, false, reporter);
        }
        return null;
    }

    private Snapshot getSnapshotInternal(ResourceName name) {
        Snapshot[] snapshots = this.controller.getModelController().getSnapshots();
        for (int i = 0; i < snapshots.length; ++i) {
            if (!name.equals((Object)snapshots[i].asResourceName())) continue;
            return snapshots[i];
        }
        return null;
    }

    private ResourceHandler getHandler(ResourceName resourceName) {
        ResourceHandler resourceHandler = SnapshotResouceUtil.getFactory().get(resourceName);
        if (resourceHandler != null) {
            return resourceHandler;
        }
        resourceHandler = PresentationResourceUtil.getFactory().get(resourceName);
        if (resourceHandler != null) {
            return resourceHandler;
        }
        resourceHandler = ControllerResourceUtil.getFactory().get(resourceName);
        return resourceHandler;
    }

    public synchronized void clearCache() {
        for (ResourceName name : this.resourceMap.keySet()) {
            this.traceMap(name, "cleared cached");
        }
        this.resourceMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long calculateResourceWriteWork() {
        LinkedList<Resource> toCheck = new LinkedList<Resource>();
        long retValue = 0L;
        AbstractResourceManagerImpl abstractResourceManagerImpl = this;
        synchronized (abstractResourceManagerImpl) {
            for (ResourceData resourceData : this.resourceMap.values()) {
                Resource resource = resourceData.resource;
                if (resource != null && resource.isModifiable()) {
                    toCheck.add(resource);
                }
                if (resourceData.store == null) continue;
                retValue += resourceData.store.getPayloadLength();
            }
        }
        for (Resource resource : toCheck) {
            ResourceHandler handler = this.getHandler(resource.getResourceName());
            retValue += handler.calculateWriteWork(resource.getResourceName(), resource);
        }
        return retValue;
    }

    public synchronized void open(ResourceName resourceName) {
        ResourceData resourceData = this.resourceMap.get(resourceName);
        this.viewStateStore.opened(resourceData.id, ResourceUtils.isSnapshotControllerName(resourceName));
    }

    public synchronized void closed(ResourceName resourceName) {
        if (this.closed) {
            return;
        }
        ResourceData resourceData = this.resourceMap.get(resourceName);
        assert (resourceData.id > 0);
        this.viewStateStore.closed(resourceData.id);
        LinkedList<ResourceName> toCheck = new LinkedList<ResourceName>();
        toCheck.add(resourceName);
        while (!toCheck.isEmpty()) {
            ResourceName[] deps;
            ResourceName currentName = (ResourceName)toCheck.removeFirst();
            if (this.isReferenced(currentName)) continue;
            ResourceName dep = this.getImplicitDependent(currentName);
            if (dep != null) {
                toCheck.add(dep);
            }
            resourceData = this.resourceMap.get(currentName);
            Resource resource = null;
            if (resourceData != null) {
                resource = resourceData.resource;
                resourceData.resource = null;
            }
            if (resource == null || (deps = resource.getDependents()) == null) continue;
            for (ResourceName d : deps) {
                toCheck.add(d);
            }
        }
    }

    private synchronized boolean isReferenced(ResourceName resourceName) {
        for (ResourceData currentData : this.resourceMap.values()) {
            ResourceName dep;
            Resource current = currentData.resource;
            if (current == null || current.getResourceName() == resourceName) continue;
            ResourceName[] deps = current.getDependents();
            if (deps != null) {
                for (ResourceName dep2 : deps) {
                    if (!dep2.equals((Object)resourceName)) continue;
                    return true;
                }
            }
            if ((dep = this.getImplicitDependent(current.getResourceName())) == null || !dep.equals((Object)resourceName)) continue;
            return true;
        }
        return false;
    }

    private synchronized ResourceName getImplicitDependent(ResourceName resourceName) {
        ResourceName tmpName;
        for (tmpName = resourceName.stripLastElement(); tmpName != null; tmpName = tmpName.stripLastElement()) {
            if (!this.resourceMap.containsKey(tmpName)) continue;
            return tmpName;
        }
        return tmpName;
    }

    private synchronized int getUniqueResourceIdentifier(ResourceName name) {
        ResourceData resourceData = this.resourceMap.get(name);
        if (resourceData != null) {
            return resourceData.id;
        }
        return this.nextUniqueResourceId++;
    }

    private void writeOnClose() throws IOException {
        ProgressReporter reporter = new ProgressReporter();
        if (!(this instanceof SnpOfflineResourceManagerImpl)) {
            String mapInfoFilename = this.sessionDirectory + File.separator + MAP_INFO_FILENAME;
            RandomAccessFile fileMapInfo = new RandomAccessFile(mapInfoFilename, "rw");
            ProfilingSessionWriter.writeMapInfo(this.session, mapInfoFilename, fileMapInfo, reporter);
            fileMapInfo.close();
        }
        ResourceName[] statisticResources = this.getStatisticResourceNames();
        for (int i = 0; i < statisticResources.length; ++i) {
            this.updateResource(statisticResources[i], reporter);
        }
        String traceHistoryFilename = this.sessionDirectory + File.separator + TRACE_HISTORY_FILENAME;
        RandomAccessFile fileTraceHistory = new RandomAccessFile(traceHistoryFilename, "rw");
        ProfilingSessionWriter.writeTraceInfo(this.session, this.controller, fileTraceHistory, reporter);
        fileTraceHistory.close();
        String controllerPropsFilename = this.sessionDirectory + File.separator + CONTROLLER_PROPERTIES_FILENAME;
        FileOutputStream outputStream = new FileOutputStream(controllerPropsFilename);
        this.controller.getProperties().store(outputStream, null);
        outputStream.close();
        reporter.finish();
        String saveFilename = this.sessionDirectory + File.separator + SAVED_FILENAME;
        RandomAccessFile saveFile = new RandomAccessFile(saveFilename, "rw");
        ProfilingVersion version = this.session.getVersion();
        saveFile.writeUTF("success");
        saveFile.writeShort(version.getMajorVersion());
        saveFile.writeShort(version.getMinorVersion());
        saveFile.writeShort(version.getMicroVersion());
        saveFile.writeByte(8);
        saveFile.close();
    }

    private String getResourceFilenamePrefix(SnapshotType type) {
        if (type == SnapshotType.ALLOCATION_SNAPSHOT) {
            return ALLOCATION_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.PERFORMANCE_HOTSPOT_SNAPSHOT) {
            return PERFORMANCE_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.METHOD_PARAMETER_SNAPSHOT) {
            return MPT_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.IO_SNAPSHOT) {
            return IO_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.SYNCHRONIZATION_SNAPSHOT) {
            return SYNCHRONIZATION_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.NETWORK_SNAPSHOT) {
            return NET_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.HPROF_DUMP_SNAPSHOT) {
            return HPROF_DUMP_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.THREAD_DUMP_SNAPSHOT) {
            return THREAD_DUMP_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.GC_SNAPSHOT) {
            return GC_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.CLASS_STATISTIC_SNAPSHOT) {
            return CLASS_STATISITC_DUMP_RESOURCE_FILE_PREFIX;
        }
        if (type == SnapshotType.GC_HISTORY_FILE_DUMP_SNAPSHOT) {
            return GC_HISTORY_FILE_DUMP_RESOURCE_FILE_PREFIX;
        }
        assert (false);
        return null;
    }

    public synchronized void store(ResourceName name, String filename) {
        ResourceData resourceData = this.resourceMap.get(name);
        if (resourceData == null) {
            int id = this.getUniqueResourceIdentifier(name);
            assert (this.assertId(id, name));
            resourceData = new ResourceData();
            resourceData.id = id;
            this.resourceMap.put(name, resourceData);
            this.traceMap(name, "store(name, file), not present");
        }
        resourceData.store = new ResourceStore(filename);
    }

    public synchronized void store(ResourceName name, ResourceStore store, int id) {
        assert (this.assertId(id, name));
        ResourceData resourceData = this.resourceMap.get(name);
        if (resourceData == null) {
            resourceData = new ResourceData();
            resourceData.id = id;
            this.resourceMap.put(name, resourceData);
            resourceData.store = store;
            this.traceMap(name, "store(name, store, id), not present");
        } else {
            resourceData.store = store;
            resourceData.id = id;
            this.traceMap(name, "store(name, store, id), already present");
        }
    }

    public synchronized void collapse(ResourceName resourceName) {
        ResourceData resourceData = this.resourceMap.get(resourceName);
        this.viewStateStore.expanded(resourceData.id, false);
    }

    public synchronized void expand(ResourceName resourceName) {
        ResourceData resourceData = this.resourceMap.get(resourceName);
        if (resourceData != null) {
            this.viewStateStore.expanded(resourceData.id, true);
        }
    }

    public synchronized boolean isExpanded(ResourceName resourceName) {
        ResourceData resourceData = this.resourceMap.get(resourceName);
        return this.viewStateStore.isExpanded(resourceData.id);
    }

    public synchronized ResourceName[] getKnownResourceNames() {
        ArrayList<ResourceName> result = new ArrayList<ResourceName>();
        for (ResourceName name : this.resourceMap.keySet()) {
            ResourceData data = this.resourceMap.get(name);
            if (data == null) continue;
            result.add(name);
        }
        return result.toArray(new ResourceName[result.size()]);
    }

    public static void setResourceCacheUsage(boolean useCache) {
        useResourceCache = useCache;
    }

    public String getBackupFileName() {
        return new File(this.sessionDirectory, "profilingData.prf").getAbsolutePath();
    }

    public File createTemporaryFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix, new File(this.sessionDirectory));
        file.deleteOnExit();
        return file;
    }

    public synchronized File createTemporaryDirectory(String prefix) throws IOException {
        File file = File.createTempFile(prefix, "_TMP_DIR", new File(this.sessionDirectory));
        file.delete();
        file.mkdir();
        file.deleteOnExit();
        return file;
    }

    protected final void traceMap(ResourceName name, String operation) {
        if (traceMapOperations) {
            int maxLen = 300;
            StringBuilder builder = new StringBuilder();
            boolean onlyShorts = false;
            for (ResourceNameElement current : name.getElements()) {
                if (builder.length() > 0) {
                    builder.append(";");
                }
                String toAdd = current.toString();
                if (builder.length() + toAdd.length() > maxLen) {
                    onlyShorts = true;
                }
                if (onlyShorts) {
                    builder.append("#" + current.getClass());
                    continue;
                }
                builder.append(current.toString());
            }
            System.out.println(new Date() + " " + operation + ": resId=" + this.resourceMap.get((Object)name).id + ", ctrlId=" + this.controller.getId() + ", name=" + builder);
        }
    }

    protected synchronized boolean assertId(int id, ResourceName name) {
        boolean found = false;
        for (Map.Entry<ResourceName, ResourceData> entry : this.resourceMap.entrySet()) {
            if (entry.getValue().id != id) continue;
            assert (!found);
            assert (name.equals((Object)entry.getKey()));
            found = true;
        }
        return true;
    }

    private class ResourceWriteTask
    implements Task {
        private ResourceHandler resourceHandler;
        private ResourceName resourceName;
        private Resource resource;

        public ResourceWriteTask(ResourceHandler resourceHandler, ResourceName resourceName, Resource resource) {
            this.resourceHandler = resourceHandler;
            this.resourceName = resourceName;
            this.resource = resource;
        }

        public Boolean run() throws Exception {
            ResourceWriterImpl resourceWriter = AbstractResourceManagerImpl.this.getWriter(this.resourceName);
            ProgressReporter progressReporter = new ProgressReporter();
            try {
                this.resourceHandler.write(this.resourceName, this.resource, (ResourceWriter)resourceWriter, progressReporter);
            }
            finally {
                progressReporter.finish();
                resourceWriter.close();
            }
            AbstractResourceManagerImpl.this.store(this.resourceName, resourceWriter.getFilename());
            return true;
        }
    }

    protected class ResourceData {
        public Resource resource;
        public int id;
        public ResourceStore store;

        protected ResourceData() {
        }
    }
}

