/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.impl.resource.PacketWriterDestination;
import com.sap.jvm.profiling.controller.impl.resource.ProfilingEventBuffer;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import java.io.IOException;

public abstract class AbstractResourcePacketWriter
implements PacketResourceWriter {
    private ProfilingEventBuffer eventBuffer;
    private long nrOfWrittenPackets;
    private ProfilingSession session;
    private boolean inInitialize;
    private boolean closed;

    public AbstractResourcePacketWriter(PacketWriterDestination writer, ProfilingSession session, boolean writeThreadInfo) throws IOException {
        this.session = session;
        this.eventBuffer = new ProfilingEventBuffer(writer, session, writeThreadInfo);
        this.inInitialize = false;
        this.closed = false;
    }

    public boolean isFinalized() {
        return !this.inInitialize;
    }

    public void beforeNewPacket() throws IOException {
        try {
            this.eventBuffer.beforeNewPacket();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void initializePacket(short type) throws IOException {
        this.eventBuffer.initializePacket(type);
        this.inInitialize = true;
    }

    public void finalizePacket() throws IOException {
        this.eventBuffer.finalizePacket();
        this.inInitialize = false;
        ++this.nrOfWrittenPackets;
    }

    public void writeBoolean(boolean value) throws IOException {
        if (!value) {
            this.writeInt8(0);
        } else {
            this.writeInt8(1);
        }
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.eventBuffer.writeBytes(bytes);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.eventBuffer.writeBytes(bytes, offset, length);
    }

    public void writeDouble(double value) throws IOException {
        this.eventBuffer.writeDouble(value);
    }

    public void writeFloat(float value) throws IOException {
        this.eventBuffer.writeFloat(value);
    }

    public void writeInt16(short value) throws IOException {
        this.eventBuffer.writeInt16(value);
    }

    public void writeUint16(char value) throws IOException {
        this.eventBuffer.writeUint16(value);
    }

    public void writeInt32(int value) throws IOException {
        this.eventBuffer.writeInt32(value);
    }

    public void writeCompressedInt32(int value) throws IOException {
        if (value >= 0 && value <= Short.MAX_VALUE) {
            this.writeInt16((short)value);
        } else {
            this.writeUint16('\uffff');
            this.writeInt32(value);
        }
    }

    public void writeVersion(int version) throws IOException {
        this.eventBuffer.writeInt32(version);
    }

    public void writeInt64(long value) throws IOException {
        this.eventBuffer.writeInt64(value);
    }

    public void writeInt8(int value) throws IOException {
        this.eventBuffer.writeInt8(value);
    }

    public void writeString(String value) throws IOException {
        this.eventBuffer.writeString(value);
    }

    public void writeBigString(String value) throws IOException {
        this.eventBuffer.writeBigString(value);
    }

    public void writeStringSafe(String value) throws IOException {
        if (value == null) {
            this.eventBuffer.writeString("");
        } else {
            this.eventBuffer.writeString(value);
        }
    }

    public void writeUTF(UTF8String value) throws IOException {
        this.eventBuffer.writeUTF(value.getBytes());
    }

    public void writeUTF(byte[] value, int offset, int length) throws IOException {
        this.eventBuffer.writeUTF(value, offset, length);
    }

    public void writeUTF(byte[] value) throws IOException {
        this.eventBuffer.writeUTF(value, 0, value.length);
    }

    public void writeMethodLocation(MethodLocation location) throws IOException {
        this.writeInt32(location.getIndex());
    }

    public void writePackageName(PackageName name) throws IOException {
        this.writeUTF(name.getName());
        this.writeBoolean(name.includesSubPackages());
    }

    public void writeClassLoaderObject(ClassLoaderObject classLoaderObject) throws IOException {
        this.writeInt32(classLoaderObject == null ? -1 : classLoaderObject.getIndex());
    }

    public void writeClassObject(ClassObject classObject) throws IOException {
        this.writeInt32(classObject == null ? -1 : classObject.getIndex());
    }

    public void writeMethodObject(MethodObject methodObject) throws IOException {
        this.writeInt32(methodObject == null ? -1 : methodObject.getIndex());
    }

    public void writeThreadFilter(ThreadFilter threadFilter) throws IOException {
        String userPattern = threadFilter.getUserFilter();
        if (userPattern == null) {
            this.writeString("**");
            return;
        }
        this.writeString("user=");
        this.writeInt32(userPattern.length());
        for (int i = 0; i < userPattern.length(); ++i) {
            this.writeUint16(userPattern.charAt(i));
        }
    }

    public void writeNewThreadFilter(ThreadFilter threadFilter) throws IOException {
        this.writeString(threadFilter.asString());
    }

    public void writeMethodParameterSpec(MethodParameterSpec spec) throws IOException {
        this.session.writeMethodParameterSpec(spec, (PacketResourceWriter)this);
    }

    public void writeMethodToTrace(MethodParameterMethodToTraceEvent methodToTrace) throws IOException {
        this.session.writeMethodToTrace(methodToTrace, (PacketResourceWriter)this);
    }

    public void flush() throws IOException {
        this.eventBuffer.dump(true);
    }

    public void close() throws IOException {
        assert (!this.closed);
        if (this.inInitialize) {
            this.finalizePacket();
        }
        this.eventBuffer.close();
        this.eventBuffer = null;
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public long getNrOfWrittenPackets() {
        return this.nrOfWrittenPackets;
    }

    public ProfilingSession getSession() {
        return this.session;
    }
}

