/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.resource.PacketWriterDestination;
import java.io.IOException;

public final class ByteArrayWriterDestination
implements PacketWriterDestination {
    private static final int BUFFER_SIZE = 0x100000;
    private static final int OUTPUT_RESIZE_SIZE = 0x100000;
    private byte[] outputBuffer = new byte[0x100000];
    private int outputIndex = 0;

    @Override
    public long getOffset() throws IOException {
        return this.outputIndex;
    }

    @Override
    public void seek(long pos) throws IOException {
        assert (pos < Integer.MAX_VALUE);
        this.outputIndex = (int)pos;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.ensureSize(1);
        this.outputBuffer[this.outputIndex] = value ? (byte)1 : 0;
        ++this.outputIndex;
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.ensureSize(4);
        this.outputBuffer[this.outputIndex] = (byte)(value >>> 24 & 0xFF);
        this.outputBuffer[this.outputIndex + 1] = (byte)(value >>> 16 & 0xFF);
        this.outputBuffer[this.outputIndex + 2] = (byte)(value >>> 8 & 0xFF);
        this.outputBuffer[this.outputIndex + 3] = (byte)(value >>> 0 & 0xFF);
        this.outputIndex += 4;
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.ensureSize(8);
        this.outputBuffer[this.outputIndex] = (byte)(value >>> 56);
        this.outputBuffer[this.outputIndex + 1] = (byte)(value >>> 48);
        this.outputBuffer[this.outputIndex + 2] = (byte)(value >>> 40);
        this.outputBuffer[this.outputIndex + 3] = (byte)(value >>> 32);
        this.outputBuffer[this.outputIndex + 4] = (byte)(value >>> 24);
        this.outputBuffer[this.outputIndex + 5] = (byte)(value >>> 16);
        this.outputBuffer[this.outputIndex + 6] = (byte)(value >>> 8);
        this.outputBuffer[this.outputIndex + 7] = (byte)(value >>> 0);
        this.outputIndex += 8;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureSize(len);
        System.arraycopy(b, off, this.outputBuffer, this.outputIndex, len);
        this.outputIndex += len;
    }

    public byte[] getData() {
        return this.outputBuffer;
    }

    public int getLength() {
        return this.outputIndex;
    }

    public void reset() {
        this.outputIndex = 0;
    }

    @Override
    public void close() throws IOException {
    }

    private void ensureSize(int size) {
        if (this.outputIndex + size > this.outputBuffer.length) {
            this.resize(this.outputBuffer.length + Math.max(size, 0x100000));
        }
    }

    private void resize(int newSize) {
        byte[] newOutputBuffer = new byte[newSize];
        System.arraycopy(this.outputBuffer, 0, newOutputBuffer, 0, this.outputIndex);
        this.outputBuffer = newOutputBuffer;
    }
}

