/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.resource.PacketWriterDestination;
import com.sap.jvm.util.threads.RunWaiter;
import com.sap.jvm.util.threads.VoidRunnable;
import java.io.IOException;
import java.util.zip.Deflater;

public final class EventBufferWriterRunnable
implements VoidRunnable<Void> {
    private static final int DEFLATER_BUFFER_SIZE = 0x100000;
    private static final int COMPRESSION_LEVEL = 5;
    private byte[] deflaterBuffer;
    private PacketWriterDestination writer;
    private int chunkHeaderLength;
    private int nrOfPackets;
    private boolean writeThreadInfo;
    private boolean startsWithContinuedPacket;
    private byte[] threadInfo;
    private int threadInfoSize;
    private byte[] eventData;
    private int eventDataSize;
    private RunWaiter<Void> previousWaiter;

    public EventBufferWriterRunnable(PacketWriterDestination writer) {
        this.writer = writer;
        this.deflaterBuffer = new byte[0x100000];
    }

    public void setNewChunkData(int newChunkHeaderLength, int newNrOfPackets, boolean newWriteThreadInfo, boolean startsWithContinuedPacket, byte[] newThreadInfo, int newThreadInfoSize, byte[] newEventData, int newEventDataSize, RunWaiter<Void> previousWaiter) {
        this.chunkHeaderLength = newChunkHeaderLength;
        this.nrOfPackets = newNrOfPackets;
        this.writeThreadInfo = newWriteThreadInfo;
        this.startsWithContinuedPacket = startsWithContinuedPacket;
        this.threadInfo = newThreadInfo;
        this.threadInfoSize = newThreadInfoSize;
        this.eventData = newEventData;
        this.eventDataSize = newEventDataSize;
        this.previousWaiter = previousWaiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void run() throws IOException {
        try {
            boolean wroteHeader = false;
            Deflater deflater = new Deflater(5);
            deflater.setInput(this.eventData, 0, this.eventDataSize);
            deflater.finish();
            int deflated = 0;
            long currentChunkStartOffset = 0L;
            long nrOfBytesBeforePayloadLength = 9L;
            while (!deflater.finished()) {
                deflated = deflater.deflate(this.deflaterBuffer);
                if (deflated <= 0) continue;
                if (this.previousWaiter != null) {
                    this.previousWaiter.waitOnFinish();
                    this.previousWaiter = null;
                }
                if (!wroteHeader) {
                    currentChunkStartOffset = this.writer.getOffset();
                    this.writer.writeInt(this.chunkHeaderLength);
                    this.writer.writeInt(this.nrOfPackets);
                    byte[] flags = new byte[]{(byte)((this.writeThreadInfo ? 1 : 0) | (this.startsWithContinuedPacket ? 2 : 0))};
                    this.writer.write(flags, 0, flags.length);
                    this.writer.writeLong(0L);
                    if (this.writeThreadInfo) {
                        this.writer.write(this.threadInfo, 0, this.threadInfoSize);
                    }
                    wroteHeader = true;
                }
                this.writer.write(this.deflaterBuffer, 0, deflated);
            }
            deflater.end();
            if (this.previousWaiter != null) {
                this.previousWaiter.waitOnFinish();
                this.previousWaiter = null;
            }
            long chunkEndOffset = this.writer.getOffset();
            this.writer.seek(currentChunkStartOffset + nrOfBytesBeforePayloadLength);
            this.writer.writeLong(chunkEndOffset - currentChunkStartOffset - (long)this.chunkHeaderLength);
            this.writer.seek(chunkEndOffset);
        }
        finally {
            if (this.previousWaiter != null) {
                this.previousWaiter.waitOnFinish();
            }
        }
        return null;
    }
}

