/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.resource.PacketWriterDestination;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileWriterDestination
implements PacketWriterDestination {
    private RandomAccessFile file;
    private boolean fileCreated;

    public FileWriterDestination(RandomAccessFile file) {
        this.file = file;
        this.fileCreated = false;
    }

    public FileWriterDestination(String filename, short type, short version) throws IOException {
        this.file = new RandomAccessFile(filename, "rw");
        this.file.setLength(0L);
        this.file.writeShort(type);
        this.file.writeInt(-559038737);
        this.file.writeShort(10);
        this.file.writeShort(version);
        this.fileCreated = true;
    }

    @Override
    public long getOffset() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.file.writeBoolean(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.file.writeInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.file.writeLong(value);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.file.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.fileCreated) {
            this.file.close();
        }
    }
}

