/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.presentation.typed.TypedModel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class OfflineResourceManagerImpl
extends AbstractResourceManagerImpl<TypedModel> {
    protected ProfilingVersion versionInfo;

    public OfflineResourceManagerImpl(ControllerImpl controller, String sessionDirectory, File tempDirectory) throws IOException {
        super(controller, sessionDirectory, tempDirectory);
    }

    public static boolean isRestoreInfoAvail(String directory) {
        try {
            String filename = directory + File.separator + ".saved";
            RandomAccessFile file = new RandomAccessFile(filename, "r");
            String string = file.readUTF();
            file.close();
            if (!string.equals("success")) {
                return false;
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean isSnapshotResource(String filename) {
        return filename.matches("(alloc_snapshot|perf_snapshot|io_snaphot|sync_snaphot|net_snaphot|hprof_snaphot|thread_dump_snapshot|class_statistic_snaphot|gc_snaphot|gc_history_snaphot|mpt_snaphot)_[0-9]+");
    }

    public static boolean isResource(String filename) {
        return filename.matches("resource_[0-9]+") || filename.matches("(alloc_snapshot|perf_snapshot|io_snaphot|sync_snaphot|net_snaphot|hprof_snaphot|thread_dump_snapshot|class_statistic_snaphot|gc_snaphot|mpt_snaphot)_[0-9]+_[0-9]+");
    }

    public void init() throws IOException {
    }

    public ProfilingVersion getVersionInfo() {
        return this.versionInfo;
    }
}

