/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.impl.resource.ByteArrayWriterDestination;
import com.sap.jvm.profiling.controller.impl.resource.EventBufferWriterRunnable;
import com.sap.jvm.profiling.controller.impl.resource.PacketWriterDestination;
import com.sap.jvm.profiling.controller.impl.resource.ResourceWriterImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.threads.RunWaiter;
import com.sap.jvm.util.threads.ThreadRunner;
import com.sap.jvm.util.threads.VoidRunnable;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.LinkedList;

public final class ProfilingEventBuffer {
    public static final int BUFFER_SIZE = 0x100000;
    public static final int MAX_PACKET_SIZE = 65535;
    public static final int NR_OF_PARALLEL_DEFLATE_THREADS = 4;
    private static final int CONTINUED_PACKET_BIT = Short.MIN_VALUE;
    private static final short CHUNK_HEADER_SIZE = 17;
    private byte[][] rawData;
    private int rawDataIndex;
    private int packetStart;
    private int currentIndex;
    private int activePacketType;
    private byte[] activePacket = new byte[65535];
    private int activePacketIndex;
    private int nrOfPackets;
    private boolean writeThreadInfo;
    private int currentChunkHeaderLength;
    private ProfilingSession session;
    private int threadInfoBufferIndex;
    private ByteArrayWriterDestination[] threadInfoWriter;
    private LinkedList<EventBufferWriterRunnable> runnables;
    private LinkedList<RunWaiter<Void>> waiters;
    private PacketWriterDestination writer;
    private boolean closed;
    private boolean firstPacketOfChunkIsContinued;

    public ProfilingEventBuffer(PacketWriterDestination writer, ProfilingSession session, boolean writeThreadInfo) throws IOException {
        int i;
        this.session = session;
        this.writer = writer;
        this.writeThreadInfo = writeThreadInfo;
        this.rawData = new byte[5][];
        this.rawDataIndex = 0;
        for (i = 0; i < this.rawData.length; ++i) {
            this.rawData[i] = new byte[0x100000];
        }
        this.activePacket = new byte[65535];
        this.activePacketIndex = 0;
        if (writeThreadInfo) {
            this.threadInfoWriter = new ByteArrayWriterDestination[5];
            this.threadInfoBufferIndex = 0;
            for (i = 0; i < this.threadInfoWriter.length; ++i) {
                this.threadInfoWriter[i] = new ByteArrayWriterDestination();
            }
        }
        this.writeThreadInfo();
        this.runnables = new LinkedList();
        this.waiters = new LinkedList();
        this.closed = false;
    }

    public void beforeNewPacket() throws IOException {
        assert (this.activePacketType == 0);
        if (this.packetStart + 65535 >= this.rawData[this.rawDataIndex].length) {
            this.dump(false);
        }
        assert (this.activePacketIndex == 0);
        assert (this.packetStart == this.currentIndex);
    }

    public void initializePacket(int type) throws IOException {
        this.initializePacket(type, false);
    }

    private void initializePacket(int type, boolean isAContinuePacket) throws IOException {
        assert (this.activePacketType == 0);
        if (this.packetStart + 65535 >= this.rawData[this.rawDataIndex].length) {
            this.dump(false);
            this.firstPacketOfChunkIsContinued = isAContinuePacket;
        }
        assert (this.packetStart == this.currentIndex);
        assert (this.activePacketIndex == 0);
        this.activePacketIndex += 4;
        this.activePacketType = type;
        if (!isAContinuePacket) {
            ++this.nrOfPackets;
        }
    }

    public void finalizePacket() throws IOException {
        assert (this.activePacketType > 0);
        this.finalizePacket(this.activePacketType);
        this.activePacketType = 0;
    }

    public void dump(boolean waitForWriter) throws IOException {
        this.dump(true, waitForWriter, false);
    }

    public void close() throws IOException {
        assert (!this.closed);
        assert (this.activePacketIndex == 0);
        this.dump(false, false, true);
        if (!this.waiters.isEmpty() && !this.waiters.getLast().waitOnFinish()) {
            Trace.error((Throwable)this.waiters.getLast().getThrowable(), (String)"Error during joining event buffer writer thread.");
        }
        this.writer.close();
        this.closed = true;
    }

    public void writeInt8(int value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 1) {
            this.continuePacket();
        }
        ProfilingEventBuffer.writeInt8(this.activePacket, this.activePacketIndex, value);
        ++this.activePacketIndex;
    }

    public void writeInt16(short value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 2) {
            byte[] tmp = new byte[2];
            ProfilingEventBuffer.writeInt16(tmp, 0, value);
            this.writeBytesAndInc(tmp);
        } else {
            ProfilingEventBuffer.writeInt16(this.activePacket, this.activePacketIndex, value);
            this.activePacketIndex += 2;
        }
    }

    public void writeUint16(char value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 2) {
            byte[] tmp = new byte[2];
            ProfilingEventBuffer.writeUint16(tmp, 0, value);
            this.writeBytesAndInc(tmp);
        } else {
            ProfilingEventBuffer.writeUint16(this.activePacket, this.activePacketIndex, value);
            this.activePacketIndex += 2;
        }
    }

    public void writeInt32(int value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 4) {
            byte[] data = new byte[4];
            ProfilingEventBuffer.writeInt32(data, 0, value);
            this.writeBytesAndInc(data);
        } else {
            ProfilingEventBuffer.writeInt32(this.activePacket, this.activePacketIndex, value);
            this.activePacketIndex += 4;
        }
    }

    public void writeInt64(long value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 8) {
            byte[] tmp = new byte[8];
            ProfilingEventBuffer.writeInt64(tmp, 0, value);
            this.writeBytesAndInc(tmp);
        } else {
            ProfilingEventBuffer.writeInt64(this.activePacket, this.activePacketIndex, value);
            this.activePacketIndex += 8;
        }
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt32(Float.floatToIntBits(value));
    }

    private void writeString(String value, boolean isBig) throws IOException {
        byte[] bytearr;
        char c;
        int strlen = value.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (isBig) {
            bytearr = new byte[utflen + 4];
            bytearr[count++] = (byte)(utflen >>> 24 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 16 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        } else {
            if (utflen > 65535) {
                throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
            }
            bytearr = new byte[utflen + 2];
            bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
            bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        }
        int i = 0;
        for (i = 0; i < strlen && (c = value.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.writeBytes(bytearr);
    }

    public void writeDouble(double value) throws IOException {
        this.writeInt64(Double.doubleToLongBits(value));
    }

    public void writeString(String value) throws IOException {
        this.writeString(value, false);
    }

    public void writeBigString(String value) throws IOException {
        this.writeString(value, true);
    }

    public void writeUTF(byte[] value) throws IOException {
        char len = (char)value.length;
        if (len != value.length) {
            throw new UTFDataFormatException("UTF string too long: " + value.length + " bytes");
        }
        this.writeUint16(len);
        this.writeBytes(value);
    }

    public void writeUTF(byte[] value, int offset, int length) throws IOException {
        char len = (char)length;
        if (len != length) {
            throw new UTFDataFormatException("UTF string too long: " + length + " bytes");
        }
        this.writeUint16(len);
        this.writeBytesAndInc(value, offset, length);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytesAndInc(bytes);
    }

    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        this.writeBytesAndInc(bytes, offset, length);
    }

    private synchronized void dump(boolean startNewChunk, boolean waitForWriter, boolean onClose) throws IOException {
        if (!onClose && this.currentIndex == 0) {
            return;
        }
        EventBufferWriterRunnable toUse = null;
        if (this.runnables.size() >= 4) {
            if (!this.waiters.getFirst().waitOnFinish()) {
                Trace.error((Throwable)this.waiters.getFirst().getThrowable(), (String)"Error during dumping event info to file.");
                throw new IOException();
            }
            toUse = this.runnables.getFirst();
            this.runnables.removeFirst();
            this.waiters.removeFirst();
        } else {
            toUse = new EventBufferWriterRunnable(this.writer);
        }
        RunWaiter lastWaiter = this.waiters.isEmpty() ? null : this.waiters.getLast();
        toUse.setNewChunkData(this.currentChunkHeaderLength, this.nrOfPackets, this.writeThreadInfo, this.firstPacketOfChunkIsContinued, this.writeThreadInfo ? this.threadInfoWriter[this.threadInfoBufferIndex].getData() : null, this.writeThreadInfo ? this.threadInfoWriter[this.threadInfoBufferIndex].getLength() : 0, this.rawData[this.rawDataIndex], this.currentIndex, lastWaiter);
        lastWaiter = new ThreadRunner().run((VoidRunnable)toUse);
        this.runnables.addLast(toUse);
        this.waiters.addLast((RunWaiter<Void>)lastWaiter);
        if (waitForWriter && !lastWaiter.waitOnFinish()) {
            Trace.error((Throwable)lastWaiter.getThrowable(), (String)"Error during dumping event info to file.");
            throw new IOException();
        }
        this.nrOfPackets = 0;
        this.currentIndex = 0;
        this.packetStart = 0;
        this.threadInfoBufferIndex = (this.threadInfoBufferIndex + 1) % 5;
        this.rawDataIndex = (this.rawDataIndex + 1) % 5;
        if (this.writeThreadInfo) {
            this.threadInfoWriter[this.threadInfoBufferIndex].reset();
        }
        if (startNewChunk) {
            this.firstPacketOfChunkIsContinued = false;
            this.writeThreadInfo();
        }
    }

    private void finalizePacket(int tag) throws IOException {
        int tmpCurrentIndex = this.activePacketIndex;
        this.activePacketIndex = 0;
        this.writeUint16((char)tag);
        this.writeInt16((short)tmpCurrentIndex);
        this.activePacketIndex = tmpCurrentIndex;
        this.writeActivePacketToBuffer();
        this.activePacketIndex = 0;
        this.activePacketType = 0;
    }

    private void writeThreadInfo() throws IOException {
        if (this.writeThreadInfo) {
            ResourceWriterImpl packetWriter = new ResourceWriterImpl(this.threadInfoWriter[this.threadInfoBufferIndex], this.session, false);
            this.session.writeThreadInfo((PacketResourceWriter)packetWriter);
            packetWriter.close();
            this.currentChunkHeaderLength = this.threadInfoWriter[this.threadInfoBufferIndex].getLength() + 17;
        } else {
            this.currentChunkHeaderLength = 17;
        }
    }

    private int getMaxBytesLeftInPacket() {
        return this.activePacket.length - this.activePacketIndex;
    }

    private void writeBytesAndInc(byte[] data) throws IOException {
        this.writeBytesAndInc(data, 0, data.length);
    }

    private void writeBytesAndInc(byte[] data, int offset, int length) throws IOException {
        int leftInBuffer = this.getMaxBytesLeftInPacket();
        int currentReadPosition = offset;
        if (leftInBuffer >= length) {
            System.arraycopy(data, currentReadPosition, this.activePacket, this.activePacketIndex, length);
            this.activePacketIndex += length;
            currentReadPosition += length;
        } else {
            System.arraycopy(data, currentReadPosition, this.activePacket, this.activePacketIndex, leftInBuffer);
            this.activePacketIndex += leftInBuffer;
            currentReadPosition += leftInBuffer;
            do {
                this.continuePacket();
                leftInBuffer = this.getMaxBytesLeftInPacket();
                int toWrite = length - (currentReadPosition - offset);
                if (leftInBuffer >= toWrite) {
                    System.arraycopy(data, currentReadPosition, this.activePacket, this.activePacketIndex, toWrite);
                    this.activePacketIndex += toWrite;
                    currentReadPosition += toWrite;
                    continue;
                }
                System.arraycopy(data, currentReadPosition, this.activePacket, this.activePacketIndex, leftInBuffer);
                this.activePacketIndex += leftInBuffer;
                currentReadPosition += leftInBuffer;
            } while (length - (currentReadPosition - offset) > 0);
        }
    }

    private synchronized void writeActivePacketToBuffer() {
        assert (this.packetStart + this.activePacketIndex < this.rawData[this.rawDataIndex].length);
        System.arraycopy(this.activePacket, 0, this.rawData[this.rawDataIndex], this.currentIndex, this.activePacketIndex);
        this.currentIndex += this.activePacketIndex;
        this.packetStart = this.currentIndex;
        this.activePacketIndex = 0;
    }

    private void continuePacket() throws IOException {
        int tag = this.activePacketType;
        assert (tag < 32768);
        assert (this.getMaxBytesLeftInPacket() == 0);
        this.finalizePacket(tag | Short.MIN_VALUE);
        this.initializePacket(tag, true);
    }

    private static void writeInt8(byte[] data, int offset, int value) {
        data[offset] = (byte)value;
    }

    private static void writeInt16(byte[] data, int offset, short value) {
        data[offset] = (byte)(value >>> 8 & 0xFF);
        data[offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    private static void writeUint16(byte[] data, int offset, char value) {
        data[offset] = (byte)(value >>> 8 & 0xFF);
        data[offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    private static void writeInt32(byte[] data, int offset, int value) {
        data[offset] = (byte)(value >>> 24 & 0xFF);
        data[offset + 1] = (byte)(value >>> 16 & 0xFF);
        data[offset + 2] = (byte)(value >>> 8 & 0xFF);
        data[offset + 3] = (byte)(value >>> 0 & 0xFF);
    }

    private static void writeInt64(byte[] data, int offset, long value) {
        data[offset] = (byte)(value >>> 56);
        data[offset + 1] = (byte)(value >>> 48);
        data[offset + 2] = (byte)(value >>> 40);
        data[offset + 3] = (byte)(value >>> 32);
        data[offset + 4] = (byte)(value >>> 24);
        data[offset + 5] = (byte)(value >>> 16);
        data[offset + 6] = (byte)(value >>> 8);
        data[offset + 7] = (byte)(value >>> 0);
    }
}

