/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.MapMetaInfo;
import com.sap.jvm.profiling.controller.exception.UnsupportedSnapshotFileVersionException;
import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.FileControllerImpl;
import com.sap.jvm.profiling.controller.impl.resource.OfflineResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ResourceReaderImpl;
import com.sap.jvm.profiling.controller.impl.resource.ResourceStore;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.exception.InvalidFileFormatException;
import com.sap.jvm.profiling.exception.UnsupportedEncodingException;
import com.sap.jvm.profiling.exception.UnsupportedVersionException;
import com.sap.jvm.profiling.resource.ByteArrayBasicResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.persistence.FileHelper;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Properties;

public final class ProfilingSessionReader {
    private final String filename;
    private ProfilingVersion versionInfo;
    private Properties properties;
    private ResourceStore mapInfoStore;
    private ResourceStore eventStore;
    private ResourceStore heartBeatInfoStore;
    private ResourceStore alertsInfoStore;
    private MapMetaInfo mapMetaInfo;
    private ResourceStore traceInfoStore;
    private ResourceStore[] snapshotStores;
    private ResourceStore[] resourceStores;
    private ResourceStore viewStateStore;
    private int nrOfSnapshots;
    private int nrOfResources;
    private long totalLoadWork;
    private String directory;
    private boolean isRestoreInfoAvail;

    public ProfilingSessionReader(String filename, String directory, boolean isRestoreInfoAvail) throws IOException {
        this.filename = filename;
        this.directory = directory;
        this.isRestoreInfoAvail = isRestoreInfoAvail;
        this.mapMetaInfo = new MapMetaInfo();
        this.properties = new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        if (this.isRestoreInfoAvail && this.filename == null) {
            this.restoreContent();
        } else if (this.filename != null && !this.isRestoreInfoAvail) {
            this.parseFile();
        } else {
            boolean corruptedFile = new File(this.directory, ".corruptedSnpFile").exists();
            if (corruptedFile) {
                this.parseBasics();
                String traceInfoFilename = this.directory + File.separator + "trcHistory.tmp";
                RandomAccessFile file = new RandomAccessFile(traceInfoFilename, "r");
                this.readTraceInfoHeader(traceInfoFilename, file);
                file.close();
            } else {
                this.parseFile();
            }
            this.readResourcesInfoHeader();
            String viewStateInfoFilename = this.directory + File.separator + "viewState.tmp";
            this.viewStateStore = new ResourceStore(viewStateInfoFilename, 0L, -1L);
            String controllerPropsFilename = this.directory + File.separator + "controllerProps.tmp";
            try (FileInputStream is = null;){
                is = new FileInputStream(controllerPropsFilename);
                this.properties.load(is);
            }
        }
    }

    public void parseBasics() throws IOException {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(this.filename, "r");
            this.readHeaderInfo(file);
            this.nrOfSnapshots = 0;
            this.nrOfResources = 0;
            this.mapInfoStore = ProfilingSessionReader.readMapInfoHeader(this.filename, file, this.mapMetaInfo);
            this.readEventInfoHeader(this.filename, file);
            this.readHeartBeatInfoHeader(this.filename, file);
            if (this.isAlertsSectionAvailable(file)) {
                this.readAlertsInfoHeader(this.filename, file);
            }
            this.totalLoadWork = (long)(this.mapMetaInfo.nrOfClassLoaders + this.mapMetaInfo.nrOfClasses + this.mapMetaInfo.nrOfMethods + this.mapMetaInfo.nrOfStackTraces) + this.mapMetaInfo.nrOfHeartBeatPackets;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ex) {
                    Trace.error((Throwable)ex, () -> "Error while closing file: " + this.filename);
                }
            }
        }
    }

    public ResourceStore getMapInfoStore() {
        return this.mapInfoStore;
    }

    public ResourceStore getEventStore() {
        return this.eventStore;
    }

    public ResourceStore[] getSnapshotStores() {
        return this.snapshotStores;
    }

    public ResourceStore[] getResourceStores() {
        return this.resourceStores;
    }

    public ResourceStore getHeartBeatStore() {
        return this.heartBeatInfoStore;
    }

    public ResourceStore getAlertsStore() {
        return this.alertsInfoStore;
    }

    public ResourceStore getTraceInfoStore() {
        return this.traceInfoStore;
    }

    public ResourceStore getViewStateStore() {
        return this.viewStateStore;
    }

    public ProfilingVersion getVersionInfo() {
        return this.versionInfo;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public MapMetaInfo getMapMetaInfo() {
        return this.mapMetaInfo;
    }

    public long calculateLoadWork() {
        return this.totalLoadWork;
    }

    public static boolean isRecoverWorkspace(String directory) {
        return new File(directory, ".recover").exists();
    }

    public static void extractOriginalData(String filename, String srcDirectory, String destDirectory, String destFilename) throws IOException {
        if (filename == null) {
            ProfilingSessionReader.extractOriginalWorkspaceData(srcDirectory, destDirectory, destFilename);
            return;
        }
        if (!FileControllerImpl.isSnapshotFile(filename)) {
            File srcFile = new File(filename);
            FileHelper.copy((File)srcFile, (File)new File(destDirectory, destFilename));
            String recoverFilename = destDirectory + File.separator + ".recover";
            RandomAccessFile recoverFile = new RandomAccessFile(recoverFilename, "rw");
            recoverFile.close();
            return;
        }
        RandomAccessFile file = null;
        RandomAccessFile mapDestFile = null;
        RandomAccessFile eventDestFile = null;
        RandomAccessFile recoverFile = null;
        try {
            file = new RandomAccessFile(filename, "r");
            String recoverFilename = destDirectory + File.separator + ".recover";
            recoverFile = new RandomAccessFile(recoverFilename, "rw");
            ProfilingSessionReader.writeRecoverHeaderInfo(file, recoverFile);
            ProfilingSessionReader.seekToMapInfo(file);
            String mapDestFilename = destDirectory + File.separator + "mapInfo.tmp";
            mapDestFile = new RandomAccessFile(mapDestFilename, "rw");
            ProfilingSessionReader.copyMapInfo(file, mapDestFile);
            String eventDestFilename = destDirectory + File.separator + "events.tmp";
            eventDestFile = new RandomAccessFile(eventDestFilename, "rw");
            eventDestFile.writeShort(5001);
            eventDestFile.writeInt(-559038737);
            eventDestFile.writeShort(10);
            eventDestFile.writeShort(1);
            ProfilingSessionReader.copyEventInfo(file, eventDestFile);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "Cannot close file: \"" + filename + "\".");
                }
            }
            if (recoverFile != null) {
                try {
                    recoverFile.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "Cannot close file: \"" + destDirectory + File.separator + ".recover" + "\".");
                }
            }
            if (mapDestFile != null) {
                try {
                    mapDestFile.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "Cannot close file: \"" + destDirectory + File.separator + "mapInfo.tmp" + "\".");
                }
            }
            if (eventDestFile != null) {
                try {
                    eventDestFile.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "Cannot close file: \"" + destDirectory + File.separator + "events.tmp" + "\".");
                }
            }
        }
    }

    private static void extractOriginalWorkspaceData(String srcDirectory, String destDirectory, String destFilename) throws IOException {
        File mapFile = new File(srcDirectory, "mapInfo.tmp");
        FileHelper.copy((File)mapFile, (File)new File(destDirectory, "mapInfo.tmp"));
        File eventFile = new File(srcDirectory, "events.tmp");
        FileHelper.copy((File)eventFile, (File)new File(destDirectory, "events.tmp"));
        String recoverFilename = destDirectory + File.separator + ".recover";
        RandomAccessFile recoverFile = null;
        try {
            recoverFile = new RandomAccessFile(recoverFilename, "rw");
            recoverFile.writeUTF("success");
            recoverFile.writeShort(1);
            recoverFile.writeShort(0);
            recoverFile.writeShort(0);
            recoverFile.write(8);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (recoverFile != null) {
                    recoverFile.close();
                }
            }
            catch (IOException ex) {
                Trace.warn((Throwable)ex, () -> "Cannot close file: " + recoverFilename);
            }
        }
    }

    private static void writeRecoverHeaderInfo(RandomAccessFile srcFile, RandomAccessFile destFile) throws IOException {
        int encoding = srcFile.read();
        srcFile.readInt();
        srcFile.readShort();
        srcFile.readShort();
        srcFile.readShort();
        srcFile.readShort();
        short majorFileVersion = srcFile.readShort();
        short minorFileVersion = srcFile.readShort();
        short microFileVersion = srcFile.readShort();
        destFile.writeUTF("success");
        destFile.writeShort(majorFileVersion);
        destFile.writeShort(minorFileVersion);
        destFile.writeShort(microFileVersion);
        destFile.write(encoding);
    }

    public static ProfilingVersion getVersionInfo(String directory) throws IOException {
        String recoverFilename = directory + File.separator + ".recover";
        RandomAccessFile recoverFile = null;
        try {
            recoverFile = new RandomAccessFile(recoverFilename, "r");
            recoverFile.readUTF();
            ProfilingVersion profilingVersion = new ProfilingVersion((int)recoverFile.readShort(), (int)recoverFile.readShort(), (int)recoverFile.readShort());
            return profilingVersion;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (recoverFile != null) {
                try {
                    recoverFile.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "Error during closing recovery file: " + recoverFilename);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getEventFileLength(String directory) {
        String eventFilename = directory + File.separator + "events.tmp";
        RandomAccessFile eventFile = null;
        try {
            eventFile = new RandomAccessFile(eventFilename, "r");
            long l = eventFile.length();
            return l;
        }
        catch (IOException ex) {
            long l = 0L;
            return l;
        }
        finally {
            if (eventFile != null) {
                try {
                    eventFile.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "Cannot close file: " + eventFilename);
                }
            }
        }
    }

    public static void readMapInfo(String directory, ControllerImpl controller, ProgressReporter reporter) throws IOException {
        String mapInfoFilename = directory + File.separator + "mapInfo.tmp";
        RandomAccessFile mapInfoFile = null;
        ResourceReaderImpl mapInfoReader = null;
        try {
            mapInfoFile = new RandomAccessFile(mapInfoFilename, "r");
            MapMetaInfo mapMetaInfo = new MapMetaInfo();
            ResourceStore mapInfoStore = ProfilingSessionReader.readMapInfoHeader(mapInfoFilename, mapInfoFile, mapMetaInfo);
            mapInfoReader = new ResourceReaderImpl(0L, -1L, mapInfoStore.asDataProvider(), controller, null);
            reporter.addToMaximumWork((long)(mapMetaInfo.nrOfClassLoaders + mapMetaInfo.nrOfClasses + mapMetaInfo.nrOfMethods + mapMetaInfo.nrOfStackTraces));
            controller.getProfilingSession().readMapInfo((PacketResourceReader)mapInfoReader, mapMetaInfo, reporter);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (mapInfoFile != null) {
                try {
                    mapInfoFile.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "Error during closing file: " + mapInfoFilename);
                }
            }
            if (mapInfoReader != null) {
                mapInfoReader.close();
            }
        }
    }

    private static void seekToMapInfo(RandomAccessFile file) throws IOException {
        file.seek(5L);
        short headerLength = file.readShort();
        file.seek(headerLength);
    }

    private static void copyMapInfo(RandomAccessFile srcFile, RandomAccessFile destFile) throws IOException {
        long start = srcFile.getFilePointer();
        srcFile.readShort();
        short headerLength = srcFile.readShort();
        long payloadLength = srcFile.readLong();
        srcFile.seek(start);
        ProfilingSessionReader.copyContent(srcFile, destFile, payloadLength + (long)headerLength);
    }

    private static void copyEventInfo(RandomAccessFile srcFile, RandomAccessFile destFile) throws IOException {
        long start = srcFile.getFilePointer();
        srcFile.readShort();
        short headerLength = srcFile.readShort();
        long payloadLength = srcFile.readLong();
        srcFile.seek(start + (long)headerLength);
        ProfilingSessionReader.copyContent(srcFile, destFile, payloadLength);
    }

    private static void copyContent(RandomAccessFile srcFile, RandomAccessFile destFile, long nrOfBytes) throws IOException {
        int nrOfReadBytes;
        byte[] buffer = new byte[0x100000];
        for (long nrOfCopiedBytes = 0L; nrOfCopiedBytes < nrOfBytes; nrOfCopiedBytes += (long)nrOfReadBytes) {
            int toRead = nrOfBytes - nrOfCopiedBytes > (long)buffer.length ? buffer.length : (int)(nrOfBytes - nrOfCopiedBytes);
            nrOfReadBytes = srcFile.read(buffer, 0, toRead);
            destFile.write(buffer, 0, nrOfReadBytes);
        }
    }

    private void parseFile() throws IOException {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(this.filename, "r");
            this.readHeaderInfo(file);
            this.mapInfoStore = ProfilingSessionReader.readMapInfoHeader(this.filename, file, this.mapMetaInfo);
            this.readEventInfoHeader(this.filename, file);
            this.readHeartBeatInfoHeader(this.filename, file);
            if (this.isAlertsSectionAvailable(file)) {
                this.readAlertsInfoHeader(this.filename, file);
            }
            this.readTraceInfoHeader(this.filename, file);
            this.readSnapshotInfoHeader(this.filename, file);
            this.readResourceInfoHeader(this.filename, file);
            this.readViewStateHeader(this.filename, file);
            this.readProperties(this.filename, file);
            this.totalLoadWork = (long)(this.nrOfSnapshots + this.nrOfResources + this.mapMetaInfo.nrOfClassLoaders + this.mapMetaInfo.nrOfClasses + this.mapMetaInfo.nrOfMethods + this.mapMetaInfo.nrOfStackTraces) + this.mapMetaInfo.nrOfHeartBeatPackets;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ex) {
                    Trace.warn((Throwable)ex, () -> "Error during closing file: " + this.filename);
                }
            }
        }
    }

    private boolean isAlertsSectionAvailable(RandomAccessFile file) throws IOException {
        short sectionType = file.readShort();
        file.seek(file.getFilePointer() - 2L);
        return sectionType == 5008;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreContent() throws IOException {
        RandomAccessFile file = null;
        String headerInfo = this.directory + File.separator + ".saved";
        file = new RandomAccessFile(headerInfo, "r");
        file.readUTF();
        this.versionInfo = new ProfilingVersion((int)file.readShort(), (int)file.readShort(), (int)file.readShort());
        int encoding = 8;
        try {
            encoding = file.readByte();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        file.close();
        if (encoding != 8) {
            throw new UnsupportedEncodingException(encoding);
        }
        if (!this.versionInfo.isCompatible(1, 6, 0)) {
            throw new UnsupportedVersionException("Profiling protocol is not supported: " + this.versionInfo.toString(), this.versionInfo);
        }
        File savedFile = new File(headerInfo);
        savedFile.delete();
        String mapInfoFilename = this.directory + File.separator + "mapInfo.tmp";
        file = new RandomAccessFile(mapInfoFilename, "r");
        this.mapInfoStore = ProfilingSessionReader.readMapInfoHeader(mapInfoFilename, file, this.mapMetaInfo);
        file.close();
        String eventInfoFilename = this.directory + File.separator + "events.tmp";
        this.eventStore = new ResourceStore(eventInfoFilename);
        String heartBeatInfoFilename = this.directory + File.separator + "heartBeat.tmp";
        this.heartBeatInfoStore = new ResourceStore(heartBeatInfoFilename);
        String alertsInfoFilename = this.directory + File.separator + "alerts.tmp";
        this.alertsInfoStore = new ResourceStore(alertsInfoFilename);
        String traceInfoFilename = this.directory + File.separator + "trcHistory.tmp";
        file = new RandomAccessFile(traceInfoFilename, "r");
        this.readTraceInfoHeader(traceInfoFilename, file);
        file.close();
        this.readResourcesInfoHeader();
        String viewStateInfoFilename = this.directory + File.separator + "viewState.tmp";
        this.viewStateStore = new ResourceStore(viewStateInfoFilename, 0L, -1L);
        String controllerPropsFilename = this.directory + File.separator + "controllerProps.tmp";
        try (FileInputStream is = null;){
            is = new FileInputStream(controllerPropsFilename);
            this.properties.load(is);
        }
        this.totalLoadWork = (long)(this.nrOfSnapshots + this.nrOfResources + this.mapMetaInfo.nrOfClassLoaders + this.mapMetaInfo.nrOfClasses + this.mapMetaInfo.nrOfMethods + this.mapMetaInfo.nrOfStackTraces) + this.mapMetaInfo.nrOfHeartBeatPackets;
    }

    private void readHeaderInfo(RandomAccessFile file) throws IOException {
        int encoding = file.read();
        if (encoding == 4) {
            ProfilingVersion versionSnapshotFile12 = new ProfilingVersion(0, 2, 0);
            throw new UnsupportedSnapshotFileVersionException("Snapshot file format is not supported: " + versionSnapshotFile12.toString(), versionSnapshotFile12);
        }
        if (encoding != 8) {
            throw new UnsupportedEncodingException(encoding);
        }
        int magicNumber = file.readInt();
        if (magicNumber != -559038737) {
            throw new InvalidFileFormatException();
        }
        short headerLength = file.readShort();
        short majorFileVersion = file.readShort();
        short minorFileVersion = file.readShort();
        short microFileVersion = file.readShort();
        assert (majorFileVersion >= 0);
        assert (minorFileVersion >= 0);
        assert (microFileVersion >= 0);
        ProfilingVersion snapshotFileVersion = new ProfilingVersion((int)majorFileVersion, (int)minorFileVersion, (int)microFileVersion);
        if (!snapshotFileVersion.isCompatible(2, 0, 0)) {
            throw new UnsupportedSnapshotFileVersionException("Snapshot file format is not supported: " + this.versionInfo.toString(), snapshotFileVersion);
        }
        short majorProtVersion = file.readShort();
        short minorProtVersion = file.readShort();
        short microProtVersion = file.readShort();
        this.versionInfo = new ProfilingVersion((int)majorProtVersion, (int)minorProtVersion, (int)microProtVersion);
        if (!this.versionInfo.isCompatible(1, 6, 0)) {
            throw new UnsupportedVersionException("Profiling protocol is not supported: " + this.versionInfo.toString(), this.versionInfo);
        }
        this.nrOfSnapshots = file.readInt();
        this.nrOfResources = file.readInt();
        file.seek(headerLength);
    }

    private static ResourceStore readMapInfoHeader(String resourceFilename, RandomAccessFile file, MapMetaInfo mapMetaInfo) throws IOException {
        long currentPointer = file.getFilePointer();
        short sectionType = file.readShort();
        assert (sectionType >= 0);
        short headerLength = file.readShort();
        byte[] data = new byte[headerLength - 4];
        file.readFully(data);
        ByteArrayBasicResourceReader reader = new ByteArrayBasicResourceReader(data);
        long payloadLength = reader.readInt64();
        mapMetaInfo.nrOfClassLoaders = reader.readInt32();
        mapMetaInfo.nrOfClasses = reader.readInt32();
        mapMetaInfo.nrOfMethods = reader.readInt32();
        mapMetaInfo.nrOfStackTraces = reader.readInt32();
        mapMetaInfo.nrOfAnnotationDefinitions = reader.readInt32();
        mapMetaInfo.nrOfSpecs = reader.readInt32();
        mapMetaInfo.nrOfDefinitionSets = reader.readInt32();
        mapMetaInfo.hasGcStatistic = reader.hasNext() ? reader.readBoolean() : false;
        mapMetaInfo.nrOfHeartBeatPackets = reader.hasNext(8) ? reader.readInt64() : 0L;
        mapMetaInfo.nrOfHostnames = reader.hasNext(4) ? reader.readInt32() : 0;
        mapMetaInfo.nrOfServices = reader.hasNext(4) ? reader.readInt32() : 0;
        mapMetaInfo.defaultTimeZone = reader.hasNext(2) ? reader.readString() : "";
        mapMetaInfo.userTimeZone = reader.hasNext(2) ? reader.readString() : "";
        long mapInfoSectionEnd = currentPointer + (long)headerLength + payloadLength;
        file.seek(mapInfoSectionEnd);
        return new ResourceStore(resourceFilename, currentPointer + (long)headerLength, mapInfoSectionEnd);
    }

    private void readEventInfoHeader(String resourceFilename, RandomAccessFile file) throws IOException {
        long currentPointer = file.getFilePointer();
        short sectionType = file.readShort();
        assert (sectionType >= 0);
        short headerLength = file.readShort();
        long payloadLength = file.readLong();
        long nrOfPackets = file.readLong();
        assert (nrOfPackets >= 0L);
        if (nrOfPackets < 0L) {
            throw new IOException("The file seems to contain corrupted data.");
        }
        long eventSectionEnd = currentPointer + (long)headerLength + payloadLength;
        file.seek(eventSectionEnd);
        this.eventStore = new ResourceStore(resourceFilename, currentPointer + (long)headerLength, eventSectionEnd);
    }

    private void readHeartBeatInfoHeader(String resourceFilename, RandomAccessFile file) throws IOException {
        long currentPointer = file.getFilePointer();
        short sectionType = file.readShort();
        assert (sectionType >= 0);
        short headerLength = file.readShort();
        long payloadLength = file.readLong();
        long heartBeatInfoSectionEnd = currentPointer + (long)headerLength + payloadLength;
        file.seek(heartBeatInfoSectionEnd);
        this.heartBeatInfoStore = new ResourceStore(resourceFilename, currentPointer + (long)headerLength, heartBeatInfoSectionEnd);
    }

    private void readAlertsInfoHeader(String resourceFilename, RandomAccessFile file) throws IOException {
        long currentPointer = file.getFilePointer();
        short sectionType = file.readShort();
        assert (sectionType >= 0);
        short headerLength = file.readShort();
        long payloadLength = file.readLong();
        long alertsInfoSectionEnd = currentPointer + (long)headerLength + payloadLength;
        file.seek(alertsInfoSectionEnd);
        this.alertsInfoStore = new ResourceStore(resourceFilename, currentPointer + (long)headerLength, alertsInfoSectionEnd);
    }

    private void readTraceInfoHeader(String resourceFilename, RandomAccessFile file) throws IOException {
        long currentPointer = file.getFilePointer();
        short sectionType = file.readShort();
        assert (sectionType >= 0);
        short headerLength = file.readShort();
        long payloadLength = file.readLong();
        long traceInfoSectionEnd = currentPointer + (long)headerLength + payloadLength;
        file.seek(traceInfoSectionEnd);
        this.traceInfoStore = new ResourceStore(resourceFilename, currentPointer + (long)headerLength, traceInfoSectionEnd);
    }

    private void readSnapshotInfoHeader(String resourceFilename, RandomAccessFile file) throws IOException {
        this.snapshotStores = new ResourceStore[this.nrOfSnapshots];
        for (int i = 0; i < this.nrOfSnapshots; ++i) {
            this.snapshotStores[i] = this.readResourceStore(resourceFilename, file);
        }
    }

    private void readResourceInfoHeader(String resourceFilename, RandomAccessFile file) throws IOException {
        this.resourceStores = new ResourceStore[this.nrOfResources];
        for (int i = 0; i < this.nrOfResources; ++i) {
            this.resourceStores[i] = this.readResourceStore(resourceFilename, file);
        }
    }

    private void readResourcesInfoHeader() throws IOException {
        int i;
        int i2;
        ArrayList<ResourceStore> tmpResourceStores = new ArrayList<ResourceStore>();
        ArrayList<ResourceStore> tmpSnapshotStores = new ArrayList<ResourceStore>();
        File file = new File(this.directory);
        File[] files = file.listFiles();
        for (int i3 = 0; i3 < files.length; ++i3) {
            if (OfflineResourceManagerImpl.isSnapshotResource(files[i3].getName())) {
                tmpSnapshotStores.add(new ResourceStore(files[i3].getAbsolutePath()));
                continue;
            }
            if (!OfflineResourceManagerImpl.isResource(files[i3].getName())) continue;
            tmpResourceStores.add(new ResourceStore(files[i3].getAbsolutePath()));
        }
        int newNrOfResources = tmpResourceStores.size();
        if (this.resourceStores != null) {
            newNrOfResources += this.resourceStores.length;
        }
        ResourceStore[] newResourceStores = new ResourceStore[newNrOfResources];
        if (this.resourceStores != null) {
            for (i2 = 0; i2 < this.resourceStores.length; ++i2) {
                newResourceStores[i2] = this.resourceStores[i2];
            }
        }
        for (i2 = 0; i2 < tmpResourceStores.size(); ++i2) {
            newResourceStores[i2 + this.nrOfResources] = (ResourceStore)tmpResourceStores.get(i2);
        }
        int newNrOfSnapshots = tmpSnapshotStores.size();
        if (this.snapshotStores != null) {
            newNrOfSnapshots += this.snapshotStores.length;
        }
        ResourceStore[] newSnapshotStores = new ResourceStore[newNrOfSnapshots];
        if (this.snapshotStores != null) {
            for (i = 0; i < this.snapshotStores.length; ++i) {
                newSnapshotStores[i] = this.snapshotStores[i];
            }
        }
        for (i = 0; i < tmpSnapshotStores.size(); ++i) {
            newSnapshotStores[i + this.nrOfSnapshots] = (ResourceStore)tmpSnapshotStores.get(i);
        }
        this.resourceStores = newResourceStores;
        this.snapshotStores = newSnapshotStores;
        this.nrOfSnapshots = newSnapshotStores.length;
        this.nrOfResources = newResourceStores.length;
    }

    private ResourceStore readResourceStore(String resourceFilename, RandomAccessFile file) throws IOException {
        long currentPointer = file.getFilePointer();
        short sectionType = file.readShort();
        assert (sectionType >= 0);
        short headerLength = file.readShort();
        long payloadLength = file.readLong();
        long resourceSectionEnd = currentPointer + (long)headerLength + payloadLength;
        file.seek(resourceSectionEnd);
        if (payloadLength == 0L) {
            return null;
        }
        return new ResourceStore(resourceFilename, currentPointer + (long)headerLength, resourceSectionEnd);
    }

    private void readViewStateHeader(String resourceFilename, RandomAccessFile file) throws IOException {
        long currentPointer = file.getFilePointer();
        short sectionType = file.readShort();
        assert (sectionType >= 0);
        short headerLength = file.readShort();
        long payloadLength = file.readLong();
        long resourceSectionEnd = currentPointer + (long)headerLength + payloadLength;
        file.seek(resourceSectionEnd);
        this.viewStateStore = new ResourceStore(resourceFilename, currentPointer + (long)headerLength, resourceSectionEnd);
    }

    private void readProperties(String resourceFilename, RandomAccessFile file) throws IOException {
        long currentPointer = file.getFilePointer();
        if (file.length() <= currentPointer) {
            return;
        }
        short sectionType = file.readShort();
        assert (sectionType >= 0);
        short headerLength = file.readShort();
        long payloadLength = file.readLong();
        this.properties = new Properties();
        this.properties.load(new InputStreamHelper(file));
        long resourceSectionEnd = currentPointer + (long)headerLength + payloadLength;
        file.seek(resourceSectionEnd);
    }

    private static class InputStreamHelper
    extends InputStream {
        private RandomAccessFile file;

        InputStreamHelper(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        public int read() throws IOException {
            return this.file.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.file.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.file.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }
}

