/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.ProfilingSessionStatistic;
import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ResourceWriterImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;

public final class ProfilingSessionWriter {
    private ProfilingSession session;
    private AbstractResourceManagerImpl<?> resourceManager;
    private ControllerImpl controller;

    public ProfilingSessionWriter(ControllerImpl controller) {
        this.controller = controller;
        this.session = controller.getProfilingSession();
        this.resourceManager = (AbstractResourceManagerImpl)this.session.getResourceManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String filename, ProgressReporter reporter) throws IOException {
        RandomAccessFile file = new RandomAccessFile(filename, "rw");
        file.setLength(0L);
        ProfilingSession profilingSession = this.session;
        synchronized (profilingSession) {
            long totalSaveWork = this.calculateMapInfoWork() + this.calculateEventInfoWork() + this.calculateHeartBeatInfoWork() + this.calculateResourceInfoWork();
            if (reporter != null) {
                reporter.setWork("", totalSaveWork);
            }
            if (reporter == null || !reporter.isCancelled()) {
                this.writeHeader(file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                ProfilingSessionWriter.writeMapInfo(this.session, filename, file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                this.writeEventInfo(file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                this.writeHeartBeatInfo(file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                this.writeAlertsInfo(file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                ProfilingSessionWriter.writeTraceInfo(this.session, this.controller, file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                this.writeSnapshotInfo(file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                this.writeResourceInfo(file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                this.writeViewState(file, reporter);
            }
            if (reporter == null || !reporter.isCancelled()) {
                this.writeProperties(file, reporter, this.controller.getProperties());
            }
        }
        file.close();
        if (reporter != null && reporter.isCancelled()) {
            new File(filename).delete();
        }
    }

    private boolean writeHeader(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        file.write(8);
        file.writeInt(-559038737);
        file.writeShort(27);
        file.writeShort(2);
        file.writeShort(0);
        file.writeShort(0);
        file.writeShort(this.session.getVersion().getMajorVersion());
        file.writeShort(this.session.getVersion().getMinorVersion());
        file.writeShort(this.session.getVersion().getMicroVersion());
        file.writeInt(this.resourceManager.getNrOfSnapshots());
        file.writeInt(this.resourceManager.getNrOfResources());
        return true;
    }

    public static void writeMapInfo(ProfilingSession session, String filename, RandomAccessFile file, ProgressReporter reporter) throws IOException {
        long headerStart = file.getFilePointer();
        file.writeShort(5000);
        long headerLengthPointer = file.getFilePointer();
        file.writeShort(0);
        long payloadPointer = file.getFilePointer();
        file.writeLong(0L);
        ProfilingSessionStatistic statistic = session.getSessionStatistic();
        file.writeInt(session.getClassLoaderManager().getNrOfClassLoaders());
        file.writeInt(session.getClassObjectManager().getNrOfClasses());
        file.writeInt(session.getMethodObjectManager().getNrOfMethods());
        file.writeInt(session.getStackTraceManager().getNrOfStackTraces());
        file.writeInt(statistic.getNrOfAnnotationDefinitions());
        file.writeInt(statistic.getNrOfMethodParameterSpecifications());
        file.writeInt(statistic.getNrOfMethodParameterDefinitionSets());
        file.writeBoolean(session.hasGcStatistic());
        file.writeLong(session.getNrOfHeartBeatPackets());
        file.writeInt(session.getNrOfHostnames());
        file.writeInt(session.getNrOfNetworkServices());
        file.writeUTF(session.getDefaultTimeZone());
        file.writeUTF(session.getUserTimeZone());
        long payloadStart = file.getFilePointer();
        file.seek(headerLengthPointer);
        file.writeShort((int)(payloadStart - headerStart));
        file.seek(payloadStart);
        ResourceWriterImpl payloadWriter = new ResourceWriterImpl(filename, file, session, false);
        session.writeMapInfo((PacketResourceWriter)payloadWriter, reporter);
        payloadWriter.flush();
        payloadWriter.close();
        if (reporter != null && reporter.isCancelled()) {
            return;
        }
        long payloadEnd = file.getFilePointer();
        long payloadLength = payloadEnd - payloadStart;
        file.seek(payloadPointer);
        file.writeLong(payloadLength);
        file.seek(payloadEnd);
    }

    private void writeEventInfo(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        file.writeShort(5001);
        file.writeShort(20);
        long payloadPointer = file.getFilePointer();
        file.writeLong(0L);
        file.writeLong(this.session.getReader() != null ? this.session.getReader().getNrOfReadPackets() : 0L);
        long payloadStart = file.getFilePointer();
        this.resourceManager.writeEventInfo(file, reporter);
        if (reporter != null && reporter.isCancelled()) {
            return;
        }
        long payloadEnd = file.getFilePointer();
        long payloadLength = payloadEnd - payloadStart;
        file.seek(payloadPointer);
        file.writeLong(payloadLength);
        file.seek(payloadEnd);
    }

    private void writeHeartBeatInfo(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        file.writeShort(5003);
        file.writeShort(12);
        long payloadPointer = file.getFilePointer();
        file.writeLong(0L);
        long payloadStart = file.getFilePointer();
        this.resourceManager.writeHeartBeatInfo(file, reporter);
        long payloadEnd = file.getFilePointer();
        long payloadLength = payloadEnd - payloadStart;
        file.seek(payloadPointer);
        file.writeLong(payloadLength);
        file.seek(payloadEnd);
    }

    private void writeAlertsInfo(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        file.writeShort(5008);
        file.writeShort(12);
        long payloadPointer = file.getFilePointer();
        file.writeLong(0L);
        long payloadStart = file.getFilePointer();
        this.resourceManager.writeAlertsInfo(file, reporter);
        long payloadEnd = file.getFilePointer();
        long payloadLength = payloadEnd - payloadStart;
        file.seek(payloadPointer);
        file.writeLong(payloadLength);
        file.seek(payloadEnd);
    }

    public static void writeTraceInfo(ProfilingSession session, ControllerImpl controller, RandomAccessFile file, ProgressReporter reporter) throws IOException {
        file.writeShort(5005);
        file.writeShort(12);
        long payloadPointer = file.getFilePointer();
        file.writeLong(0L);
        long payloadStart = file.getFilePointer();
        ResourceWriterImpl resourceWriter = new ResourceWriterImpl(null, file, session, false);
        resourceWriter.initializePacket((short)30000);
        controller.getModelController().getTraceHistory().write((ResourceWriter)resourceWriter);
        resourceWriter.close();
        long payloadEnd = file.getFilePointer();
        long payloadLength = payloadEnd - payloadStart;
        file.seek(payloadPointer);
        file.writeLong(payloadLength);
        file.seek(payloadEnd);
    }

    private void writeSnapshotInfo(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        ResourceName[] snapshotResources = this.resourceManager.getSnapshotResourceNames();
        for (int i = 0; i < snapshotResources.length; ++i) {
            file.writeShort(5002);
            file.writeShort(12);
            long payloadPointer = file.getFilePointer();
            file.writeLong(0L);
            long payloadStart = file.getFilePointer();
            this.resourceManager.writeResource(snapshotResources[i], file, reporter);
            long payloadEnd = file.getFilePointer();
            long payloadLength = payloadEnd - payloadStart;
            file.seek(payloadPointer);
            file.writeLong(payloadLength);
            file.seek(payloadEnd);
        }
    }

    private void writeResourceInfo(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        ResourceName[] statisticResources = this.resourceManager.getStatisticResourceNames();
        for (int i = 0; i < statisticResources.length; ++i) {
            file.writeShort(5004);
            file.writeShort(12);
            long payloadPointer = file.getFilePointer();
            file.writeLong(0L);
            long payloadStart = file.getFilePointer();
            this.resourceManager.updateResource(statisticResources[i], reporter);
            this.resourceManager.writeResource(statisticResources[i], file, reporter);
            long payloadEnd = file.getFilePointer();
            long payloadLength = payloadEnd - payloadStart;
            file.seek(payloadPointer);
            file.writeLong(payloadLength);
            file.seek(payloadEnd);
        }
    }

    private void writeViewState(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        file.writeShort(5006);
        file.writeShort(12);
        long payloadPointer = file.getFilePointer();
        file.writeLong(0L);
        long payloadStart = file.getFilePointer();
        this.resourceManager.writeViewState(file, reporter);
        long payloadEnd = file.getFilePointer();
        long payloadLength = payloadEnd - payloadStart;
        file.seek(payloadPointer);
        file.writeLong(payloadLength);
        file.seek(payloadEnd);
    }

    private void writeProperties(RandomAccessFile file, ProgressReporter reporter, Properties properties) throws IOException {
        file.writeShort(5007);
        file.writeShort(12);
        long payloadPointer = file.getFilePointer();
        file.writeLong(0L);
        long payloadStart = file.getFilePointer();
        properties.store(new OutputStreamHelper(file), null);
        long payloadEnd = file.getFilePointer();
        long payloadLength = payloadEnd - payloadStart;
        file.seek(payloadPointer);
        file.writeLong(payloadLength);
        file.seek(payloadEnd);
    }

    private long calculateMapInfoWork() {
        return this.session.getClassLoaderManager().getNrOfClassLoaders() + this.session.getClassObjectManager().getNrOfClasses() + this.session.getMethodObjectManager().getNrOfMethods() + this.session.getMethodLocationManager().getNrOfLocations() + this.session.getStackTraceManager().getNrOfStackTraces();
    }

    private long calculateEventInfoWork() {
        return this.resourceManager.getEventInfoPayloadLength();
    }

    private long calculateHeartBeatInfoWork() {
        return this.resourceManager.getHeartBeatInfoPayloadLength();
    }

    private long calculateResourceInfoWork() {
        return this.resourceManager.calculateResourceWriteWork();
    }

    private static class OutputStreamHelper
    extends OutputStream {
        private RandomAccessFile file;

        OutputStreamHelper(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        public void write(int b) throws IOException {
            this.file.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.file.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.file.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }
}

