/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.resource.RandomAccessResourceFile;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class RandomAccessResourceFileImpl
implements RandomAccessResourceFile {
    private RandomAccessFile file;

    public RandomAccessResourceFileImpl(String filename) throws IOException {
        this.file = new RandomAccessFile(filename, "rw");
    }

    @Override
    public long getPointer() {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.file.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.file.readByte();
    }

    @Override
    public int readInt32() throws IOException {
        return this.file.readInt();
    }

    @Override
    public void seek(long pointer) throws IOException {
        this.file.seek(pointer);
    }

    @Override
    public void skip(int nrOfBytes) throws IOException {
        this.file.skipBytes(nrOfBytes);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.file.writeBoolean(value);
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.file.writeByte(value);
    }

    @Override
    public void writeInt32(int value) throws IOException {
        this.file.writeInt(value);
    }

    @Override
    public void clear() throws IOException {
        this.file.setLength(0L);
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

