/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceHandler;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.util.AccessibleObjectWrapper;
import com.sap.jvm.profiling.util.CtorWrapper;
import java.io.IOException;

public final class ResourceControllerHandler
implements ResourceHandler {
    private static AccessibleObjectWrapper.SetAccessibleHook sah = o -> {
        if (!o.isAccessible()) {
            o.setAccessible(true);
        }
    };
    private final CtorWrapper constructor;
    private final ResourceNameElement element;

    public ResourceControllerHandler(ResourceNameElement element, Class<? extends Resource> resource) {
        this.element = element;
        this.constructor = new CtorWrapper(resource, sah, new Class[]{ResourceName.class, ProgressReporter.class});
    }

    public boolean canHandle(ResourceName name) {
        return name.endsWithType(this.element);
    }

    public Resource create(ResourceName name, ProgressReporter reporter) {
        return (Resource)this.constructor.newInstance(new Object[]{name, reporter});
    }

    public Resource read(ResourceName name, ResourceReader reader, ProgressReporter reporter) throws IOException {
        reader.readVersion(0, 0);
        return (Resource)this.constructor.newInstance(new Object[]{name, reporter});
    }

    public void write(ResourceName name, Resource resource, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
    }

    public long calculateWriteWork(ResourceName name, Resource resource) {
        return 0L;
    }
}

