/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class ResourceDataProvider {
    private RandomAccessFile file;
    private final long startOffset;
    private final long endOffset;
    private long currentPointer;
    private final String filename;

    public ResourceDataProvider(String filename, long startOffset, long endOffset) throws IOException {
        this.filename = filename;
        this.file = new RandomAccessFile(filename, "r");
        this.startOffset = startOffset;
        this.endOffset = endOffset == -1L ? this.file.length() : endOffset;
        this.file.seek(startOffset);
        this.currentPointer = startOffset;
    }

    public long getFilePointer() {
        return this.currentPointer - this.startOffset;
    }

    public void seek(long position) throws IOException {
        this.file.seek(position + this.startOffset);
        this.currentPointer = position + this.startOffset;
    }

    public boolean isEof() {
        return this.currentPointer >= this.endOffset;
    }

    public boolean readBoolean() throws IOException {
        ++this.currentPointer;
        return this.file.readBoolean();
    }

    public byte readByte() throws IOException {
        ++this.currentPointer;
        return this.file.readByte();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int retValue = this.file.read(b, off, len);
        this.currentPointer += (long)retValue;
        return retValue;
    }

    public int readInt() throws IOException {
        this.currentPointer += 4L;
        return this.file.readInt();
    }

    public long readLong() throws IOException {
        this.currentPointer += 8L;
        return this.file.readLong();
    }

    public short readShort() throws IOException {
        this.currentPointer += 2L;
        return this.file.readShort();
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, () -> "Could not close '" + this.getFilename() + "'");
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, () -> "Could not get length of '" + this.getFilename() + "'");
            return -1L;
        }
    }
}

