/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.resource.ControllerResourceUtil;
import com.sap.jvm.profiling.presentation.resource.PresentationResourceUtil;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResouceUtil;
import com.sap.jvm.profiling.util.AccessibleObjectWrapper;
import com.sap.jvm.profiling.util.CtorWrapper;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class ResourceNameElementsHandler {
    private static AccessibleObjectWrapper.SetAccessibleHook sah = o -> {
        if (!o.isAccessible()) {
            o.setAccessible(true);
        }
    };
    private final ArrayList<ResourceNameElement> elements = new ArrayList();
    private final Map<String, ClassInfo> tagToClassInfo = new HashMap<String, ClassInfo>();
    private static ResourceNameElementsHandler theInstance;

    public static synchronized ResourceNameElementsHandler getInstance() {
        if (theInstance == null) {
            theInstance = new ResourceNameElementsHandler();
        }
        return theInstance;
    }

    private ResourceNameElementsHandler() {
        SnapshotResouceUtil.getFactory().addElements(this.elements);
        PresentationResourceUtil.getFactory().addElements(this.elements);
        ControllerResourceUtil.getFactory().addElements(this.elements);
        this.init();
    }

    public String getTag(ResourceNameElement element) {
        return element.getTag();
    }

    public ResourceNameElement readElement(ResourceReader reader) throws IOException {
        String tag = reader.readString();
        ClassInfo classInfo = this.tagToClassInfo.get(tag);
        if (classInfo == null) {
            Trace.warn(() -> "Could not get element for tag '" + tag + "'");
            return null;
        }
        if (!classInfo.needsReader) {
            return (ResourceNameElement)classInfo.ctorWrapper.newInstanceWithIOException(new Object[0]);
        }
        return (ResourceNameElement)classInfo.ctorWrapper.newInstanceWithIOException(new Object[]{reader});
    }

    public void writeElement(ResourceNameElement element, ResourceWriter writer) throws IOException {
        assert (this.containsElementWithTag(element.getTag()));
        String tag = this.getTag(element);
        writer.writeString(tag);
        element.write(writer);
    }

    private boolean containsElementWithTag(String tag) {
        for (ResourceNameElement e : this.elements) {
            if (!tag.equals(e.getTag())) continue;
            return true;
        }
        return false;
    }

    private void init() {
        for (ResourceNameElement type : this.elements) {
            CtorWrapper ctorWrapper;
            boolean needsReader = true;
            if (CtorWrapper.hasConstructor(type.getClass(), (Class[])new Class[]{ResourceReader.class})) {
                ctorWrapper = new CtorWrapper(type.getClass(), sah, new Class[]{ResourceReader.class});
            } else {
                ctorWrapper = new CtorWrapper(type.getClass(), sah, new Class[0]);
                needsReader = false;
            }
            String tag = this.getTag(type);
            assert (!this.tagToClassInfo.containsKey(tag));
            this.tagToClassInfo.put(tag, new ClassInfo(ctorWrapper, needsReader));
        }
    }

    private class ClassInfo {
        public final CtorWrapper ctorWrapper;
        public final boolean needsReader;

        public ClassInfo(CtorWrapper ctorWrapper, boolean needsReader) {
            this.ctorWrapper = ctorWrapper;
            this.needsReader = needsReader;
        }
    }
}

