/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public final class ResourceNameImpl
implements ResourceName {
    private final ArrayList<ResourceNameElement> elements;
    private final ControllerImpl controller;
    private final ProfilingSession session;

    public ResourceNameImpl(ControllerImpl controller, ResourceNameElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The parameter \"element\" is null.");
        }
        this.controller = controller;
        this.session = controller.getProfilingSession();
        this.elements = new ArrayList();
        this.elements.add(element);
    }

    public ResourceNameImpl(ControllerImpl controller, ResourceReader reader) throws IOException {
        this.controller = controller;
        this.session = controller.getProfilingSession();
        int nrOfElements = reader.readInt16();
        this.elements = new ArrayList();
        for (int i = 0; i < nrOfElements; ++i) {
            ResourceNameElement element = this.session.getResourceManager().readResourceNameElement(reader);
            assert (element != null);
            this.elements.add(element);
        }
    }

    private ResourceNameImpl(ResourceNameImpl toCopy) {
        this.elements = new ArrayList<ResourceNameElement>(toCopy.elements);
        this.controller = toCopy.controller;
        this.session = toCopy.session;
    }

    public int getNrOfElements() {
        return this.elements.size();
    }

    public ResourceNameElement[] getElements() {
        ResourceNameElement[] retValue = new ResourceNameElement[this.elements.size()];
        retValue = this.elements.toArray(retValue);
        return retValue;
    }

    public Iterator<ResourceNameElement> iterator() {
        return this.elements.iterator();
    }

    public ResourceName addElement(ResourceNameElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The parameter \"element\" is null.");
        }
        ResourceNameImpl result = new ResourceNameImpl(this);
        result.elements.add(element);
        return result;
    }

    public ResourceName addNonNullElement(ResourceNameElement element) {
        if (element == null) {
            return this;
        }
        return this.addElement(element);
    }

    public ResourceNameElement getLastElement() {
        assert (!this.elements.isEmpty());
        return this.elements.get(this.elements.size() - 1);
    }

    public ResourceName stripLastElement() {
        assert (!this.elements.isEmpty());
        if (this.elements.size() == 1) {
            return null;
        }
        ResourceNameImpl result = new ResourceNameImpl(this);
        result.elements.remove(this.elements.size() - 1);
        return result;
    }

    public boolean endsWith(ResourceNameElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The parameter \"element\" is null.");
        }
        ResourceNameElement lastElement = this.getLastElement();
        assert (lastElement != null);
        return lastElement.equals((Object)element);
    }

    public boolean endsWithType(ResourceNameElement element) {
        ResourceNameElement lastElement = this.getLastElement();
        assert (lastElement != null);
        return element.getTag().equals(lastElement.getTag());
    }

    public boolean startsWith(ResourceNameElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The parameter \"element\" is null.");
        }
        return this.elements.get(0).equals((Object)element);
    }

    public boolean startsWith(Class<? extends ResourceNameElement> elementType) {
        return elementType.isAssignableFrom(this.elements.get(0).getClass());
    }

    public boolean startsWith(ResourceName name) {
        if (name.getNrOfElements() > this.getNrOfElements()) {
            return false;
        }
        ResourceNameElement[] otherElements = name.getElements();
        for (int i = 0; i < otherElements.length; ++i) {
            if (this.elements.get(i).equals((Object)otherElements[i])) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Class<? extends ResourceNameElement> elementType) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!elementType.isAssignableFrom(this.elements.get(i).getClass())) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Class<? extends ResourceNameElement> elementType) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (!elementType.isAssignableFrom(this.elements.get(i).getClass())) continue;
            return i;
        }
        return -1;
    }

    public ProfilingSession getSession() {
        return this.session;
    }

    public ResourceManager getResourceManager() {
        return this.session.getResourceManager();
    }

    public int hashCode() {
        int retValue = 255;
        for (ResourceNameElement current : this.elements) {
            retValue ^= current.hashCode();
        }
        return retValue;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ResourceNameImpl)) {
            return false;
        }
        return this.equalsInternal((ResourceNameImpl)obj);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ResourceNameElement current : this.elements) {
            if (builder.length() > 0) {
                builder.append(";");
            }
            builder.append(current.toString());
        }
        return builder.toString();
    }

    public void write(ResourceWriter writer) throws IOException {
        ResourceManager resourceManager = writer.getSession().getResourceManager();
        writer.writeInt16((short)this.getNrOfElements());
        for (ResourceNameElement element : this.elements) {
            resourceManager.writeResourceNameElement(element, writer);
        }
    }

    public ControllerImpl getController() {
        return this.controller;
    }

    private boolean equalsInternal(ResourceNameImpl name) {
        if (name.elements.size() != this.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i).equals((Object)name.elements.get(i))) continue;
            return false;
        }
        return true;
    }
}

