/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ChunkHeaderMetaData;
import com.sap.jvm.profiling.controller.impl.resource.ResourceDataProvider;
import com.sap.jvm.profiling.controller.impl.resource.ResourceNameImpl;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.resource.AbstractPacketResourceReader;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.persistence.ContinuedPacketReader;
import com.sap.jvm.util.persistence.ParallelProfilingInputStream;
import com.sap.jvm.util.persistence.ProfilingInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public final class ResourceReaderImpl
extends AbstractPacketResourceReader {
    private ResourceDataProvider resourceDataProvider;
    private InputStream prfInputStream;
    private long currentChunkEndPointer;
    private long currentPointer;
    private ControllerImpl controller;
    private long startPacketNumber;
    private ChunkHeaderMetaData[] chunkMetaData;
    private long nrOfStartPacketsToSkip;
    private long nrOfThreadInfoPacketsToSkip;
    private boolean skipContinuedPackets;
    private int chunkIndex;
    private long savedChunkEnd;
    private final boolean useParallelStream;

    public ResourceReaderImpl(long startPacketNumber, long nrOfPacketsToRead, ResourceDataProvider resourceDataProvider, ControllerImpl controller, ChunkHeaderMetaData[] chunkMetaData) throws IOException {
        super(controller.getProfilingSession(), nrOfPacketsToRead == -1L ? Long.MAX_VALUE : nrOfPacketsToRead);
        boolean bl = this.useParallelStream = !"false".equals(System.getProperty("com.sap.jvm.profiling.useParallelProfilingStream"));
        assert (nrOfPacketsToRead >= -1L);
        this.resourceDataProvider = resourceDataProvider;
        this.chunkMetaData = chunkMetaData;
        this.startPacketNumber = startPacketNumber;
        this.controller = controller;
        this.setPacketReader(new ContinuedPacketReader((InputStream)new ContinuedPacketReaderDataProviderImpl(), false));
        this.nrOfStartPacketsToSkip = 0L;
        this.nrOfThreadInfoPacketsToSkip = 0L;
        this.skipContinuedPackets = this.goToStartChunk();
        this.prfInputStream = new ProfilingInputStream((InputStream)new DataProviderImpl());
        if (this.useParallelStream) {
            this.prfInputStream = new ParallelProfilingInputStream(this.prfInputStream);
        }
    }

    public void skipInitialContinuedPacket() throws IOException {
        if (this.skipContinuedPackets) {
            this.packetReader.skipContinuedPackets();
            this.skipContinuedPackets = false;
        }
    }

    public static ChunkHeaderMetaData[] generateChunkHeaderMetaData(ResourceDataProvider resourceDataProvider, ProgressReporter reporter) throws IOException {
        ArrayList<ChunkHeaderMetaData> metaData = new ArrayList<ChunkHeaderMetaData>();
        while (!resourceDataProvider.isEof()) {
            long chunkHeaderStart = resourceDataProvider.getFilePointer();
            if (!reporter.report(chunkHeaderStart)) {
                throw new OperationCanceledException();
            }
            int chunkHeaderSize = resourceDataProvider.readInt();
            assert (chunkHeaderSize > 0);
            int nrOfPackets = resourceDataProvider.readInt();
            assert (nrOfPackets >= 0);
            byte[] flags = new byte[1];
            while (resourceDataProvider.read(flags, 0, 1) == 0) {
            }
            boolean threadInfoAvailable = (flags[0] & 1) > 0;
            boolean startsWithContinuedPacket = (flags[0] & 2) > 0;
            long currentChunkLength = resourceDataProvider.readLong();
            long currentPointer = resourceDataProvider.getFilePointer();
            ChunkHeaderMetaData newChunkMetaData = new ChunkHeaderMetaData(chunkHeaderStart, nrOfPackets, chunkHeaderStart + (long)chunkHeaderSize, threadInfoAvailable ? currentPointer : -1L, startsWithContinuedPacket);
            metaData.add(newChunkMetaData);
            resourceDataProvider.seek(chunkHeaderStart + (long)chunkHeaderSize + currentChunkLength);
        }
        ChunkHeaderMetaData[] retValue = new ChunkHeaderMetaData[metaData.size()];
        retValue = metaData.toArray(retValue);
        return retValue;
    }

    public long getNrOfReadBytes() {
        return this.resourceDataProvider.getFilePointer();
    }

    public int getStackTraceIndexForObjectId(long objectId) throws EOFException {
        return this.readInt32();
    }

    public long readClassLoaderId() throws EOFException {
        return this.readInt32();
    }

    public ClassLoaderObject readClassLoaderObject() throws EOFException {
        int classLoaderId = this.readInt32();
        if (classLoaderId == -1) {
            return null;
        }
        assert (classLoaderId >= 0);
        return this.getSession().getClassLoader(classLoaderId);
    }

    public ClassObject readClassObject() throws EOFException {
        int classId = this.readInt32();
        if (classId == -1) {
            return null;
        }
        assert (classId >= 0);
        return this.getSession().getClassObject(classId);
    }

    public long readClassObjectId() throws EOFException {
        return this.readInt32();
    }

    public MethodObject readMethodObject() throws EOFException {
        int methodId = this.readInt32();
        if (methodId == -1) {
            return null;
        }
        assert (methodId >= 0);
        return this.getSession().getMethodObject(methodId);
    }

    public long readMethodObjectId() throws EOFException {
        return this.readInt32();
    }

    public long readUniqueFileId() throws EOFException {
        return this.readInt64();
    }

    public long readUniqueSocketId() throws EOFException {
        return this.readInt64();
    }

    public ResourceName readResourceName() throws IOException {
        return new ResourceNameImpl(this.controller, (ResourceReader)this);
    }

    public int readStackTraceIndex() throws EOFException {
        int stackId = this.readInt32();
        assert (stackId >= 0);
        return stackId;
    }

    public void close() {
        this.resourceDataProvider.close();
        try {
            this.prfInputStream.close();
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Could not close profiling input stream");
        }
    }

    public long getNrOfPacketsToSkip() {
        return this.nrOfStartPacketsToSkip;
    }

    public long getNrOfThreadInfoPacketsToSkip() {
        return this.nrOfThreadInfoPacketsToSkip;
    }

    private void nextChunk(boolean readThreadInfo) throws IOException {
        if (this.currentPointer == -1L || this.resourceDataProvider.isEof()) {
            this.currentPointer = -1L;
            return;
        }
        if (!readThreadInfo && this.savedChunkEnd > 0L) {
            if (this.currentPointer + 17L >= this.chunkMetaData[this.chunkIndex].getPayLoadOffset()) {
                this.currentChunkEndPointer = this.savedChunkEnd;
                this.savedChunkEnd = 0L;
                this.currentPointer = this.chunkMetaData[this.chunkIndex].getPayLoadOffset();
                this.resourceDataProvider.seek(this.currentPointer);
                return;
            }
            int threadInfoChunkHeaderSize = this.resourceDataProvider.readInt();
            if (threadInfoChunkHeaderSize <= 0) {
                throw new IOException("The file seems to contain corrupted data.");
            }
            int nrOfThreadInfoPackets = this.resourceDataProvider.readInt();
            if (nrOfThreadInfoPackets < 0) {
                throw new IOException("The file seems to contain corrupted data.");
            }
            this.resourceDataProvider.readBoolean();
            long threadInfoChunkLength = this.resourceDataProvider.readLong();
            this.currentChunkEndPointer = this.currentPointer + (long)threadInfoChunkHeaderSize + threadInfoChunkLength;
            this.resourceDataProvider.seek(this.currentPointer + (long)threadInfoChunkHeaderSize);
            this.currentPointer = this.resourceDataProvider.getFilePointer();
            if (nrOfThreadInfoPackets == 0) {
                this.resourceDataProvider.seek(this.currentChunkEndPointer);
                this.currentPointer = this.currentChunkEndPointer;
                this.nextChunk(false);
            }
            return;
        }
        long chunkHeaderStart = this.resourceDataProvider.getFilePointer();
        int chunkHeaderSize = this.resourceDataProvider.readInt();
        if (chunkHeaderSize <= 0) {
            throw new IOException("The file seems to contain corrupted data.");
        }
        int nrOfPackets = this.resourceDataProvider.readInt();
        if (nrOfPackets < 0) {
            throw new IOException("The file seems to contain corrupted data.");
        }
        byte[] flags = new byte[1];
        while (this.resourceDataProvider.read(flags, 0, 1) == 0) {
        }
        boolean threadInfoAvailable = (flags[0] & 1) > 0;
        long currentChunkLength = this.resourceDataProvider.readLong();
        if (readThreadInfo && threadInfoAvailable) {
            while (true) {
                long threadInfoStartOffset = this.resourceDataProvider.getFilePointer();
                int threadInfoChunkHeaderSize = this.resourceDataProvider.readInt();
                if (threadInfoChunkHeaderSize <= 0) {
                    throw new IOException("The file seems to contain corrupted data.");
                }
                int nrOfThreadInfoPackets = this.resourceDataProvider.readInt();
                if (nrOfThreadInfoPackets < 0) {
                    throw new IOException("The file seems to contain corrupted data.");
                }
                this.resourceDataProvider.readBoolean();
                this.currentChunkEndPointer = threadInfoStartOffset + (long)threadInfoChunkHeaderSize + this.resourceDataProvider.readLong();
                this.nrOfReadPackets -= (long)nrOfThreadInfoPackets;
                this.nrOfStartPacketsToSkip += (long)nrOfThreadInfoPackets;
                this.nrOfThreadInfoPacketsToSkip += (long)nrOfThreadInfoPackets;
                this.resourceDataProvider.seek(this.currentChunkEndPointer);
                this.currentPointer = this.resourceDataProvider.getFilePointer();
                if (this.currentPointer + 17L < this.chunkMetaData[this.chunkIndex].getPayLoadOffset()) continue;
                this.resourceDataProvider.seek(chunkHeaderStart + 17L);
                this.currentChunkEndPointer = this.currentPointer = this.resourceDataProvider.getFilePointer();
                this.savedChunkEnd = chunkHeaderStart + (long)chunkHeaderSize + currentChunkLength;
                return;
                assert (this.currentPointer <= this.chunkMetaData[this.chunkIndex].getPayLoadOffset());
            }
        }
        this.resourceDataProvider.seek(chunkHeaderStart + (long)chunkHeaderSize);
        this.currentPointer = this.resourceDataProvider.getFilePointer();
        this.currentChunkEndPointer = this.currentPointer + currentChunkLength;
    }

    private boolean goToStartChunk() throws IOException {
        long nrOfSkippedPackets = 0L;
        if (this.startPacketNumber == 0L) {
            this.nextChunk(false);
            return false;
        }
        while (this.chunkIndex < this.chunkMetaData.length && (long)this.chunkMetaData[this.chunkIndex].getNrOfPackets() + nrOfSkippedPackets < this.startPacketNumber) {
            nrOfSkippedPackets += (long)this.chunkMetaData[this.chunkIndex].getNrOfPackets();
            this.nrOfPacketsToRead += (long)this.chunkMetaData[this.chunkIndex].getNrOfPackets();
            this.nrOfReadPackets += (long)this.chunkMetaData[this.chunkIndex].getNrOfPackets();
            ++this.chunkIndex;
        }
        assert (this.chunkIndex < this.chunkMetaData.length);
        this.nrOfStartPacketsToSkip = this.startPacketNumber - nrOfSkippedPackets - 1L;
        this.nrOfPacketsToRead += this.nrOfStartPacketsToSkip;
        this.resourceDataProvider.seek(this.chunkMetaData[this.chunkIndex].getChunkOffset());
        this.nextChunk(true);
        return this.chunkMetaData[this.chunkIndex].startsWithContinuedPacket();
    }

    private class ContinuedPacketReaderDataProviderImpl
    extends InputStream {
        private ContinuedPacketReaderDataProviderImpl() {
        }

        @Override
        public int read() throws IOException {
            return ResourceReaderImpl.this.prfInputStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return ResourceReaderImpl.this.prfInputStream.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return ResourceReaderImpl.this.prfInputStream.read(b);
        }
    }

    private class DataProviderImpl
    extends InputStream {
        byte[] singleByteBuffer = new byte[1];

        private DataProviderImpl() {
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (ResourceReaderImpl.this.currentPointer == -1L) {
                return -1;
            }
            int maxLen = (int)(ResourceReaderImpl.this.currentChunkEndPointer - ResourceReaderImpl.this.currentPointer) < len ? (int)(ResourceReaderImpl.this.currentChunkEndPointer - ResourceReaderImpl.this.currentPointer) : len;
            int readBytes = ResourceReaderImpl.this.resourceDataProvider.read(b, off, maxLen);
            ResourceReaderImpl.this.currentPointer = ResourceReaderImpl.this.currentPointer + (long)readBytes;
            if (ResourceReaderImpl.this.currentPointer >= ResourceReaderImpl.this.currentChunkEndPointer) {
                ResourceReaderImpl.this.nextChunk(false);
                if (ResourceReaderImpl.this.savedChunkEnd > 0L && readBytes == 0) {
                    return this.read(b, off, len);
                }
            }
            return readBytes;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            return this.read(this.singleByteBuffer, 0, this.singleByteBuffer.length);
        }
    }
}

