/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.resource.ResourceDataProvider;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class ResourceStore {
    private String filename;
    private long startOffset;
    private long endOffset;

    public ResourceStore(String filename) {
        this(filename, 10L, -1L);
    }

    public ResourceStore(String filename, long startOffset, long endOffset) {
        this.filename = filename;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public void copyContent(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        this.copyContent(file, false, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyContent(RandomAccessFile file, boolean adaptEndOffset, ProgressReporter reporter) throws IOException {
        RandomAccessFile srcFile = new RandomAccessFile(this.filename, "r");
        srcFile.seek(this.startOffset);
        if (this.endOffset == -1L || adaptEndOffset) {
            this.endOffset = srcFile.length();
        }
        byte[] buffer = new byte[0x100000];
        int nrReadBytes = 0;
        int toWrite = 0;
        try {
            for (long nrBytesToWrite = this.endOffset - this.startOffset; nrBytesToWrite > 0L; nrBytesToWrite -= (long)toWrite) {
                nrReadBytes = srcFile.read(buffer);
                if (nrReadBytes == -1) {
                    return;
                }
                toWrite = nrBytesToWrite - (long)nrReadBytes < 0L ? (int)nrBytesToWrite : nrReadBytes;
                file.write(buffer, 0, toWrite);
                if (reporter == null || reporter.report(reporter.getActualWork() + (long)toWrite)) continue;
                return;
            }
        }
        finally {
            srcFile.close();
        }
    }

    public ResourceDataProvider asDataProvider() throws IOException {
        return new ResourceDataProvider(this.filename, this.startOffset, this.endOffset);
    }

    public long getPayloadLength() {
        if (this.endOffset >= 0L) {
            return this.endOffset - this.startOffset;
        }
        try {
            RandomAccessFile file = new RandomAccessFile(this.filename, "r");
            long retValue = file.length() - this.startOffset;
            file.close();
            return retValue;
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Error during accessing resource file.");
            return 0L;
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

