/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ControllerResourceUtil;
import com.sap.jvm.profiling.controller.impl.resource.GenericSnapshotControllerResourceNameElement;
import com.sap.jvm.profiling.controller.impl.resource.ResourceNameImpl;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotDefiningElement;
import com.sap.jvm.profiling.snapshot.SnapshotEndTag;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.tracing.Trace;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class ResourceUtils {
    private static final Map<Class<? extends GenericSnapshotElement>, Class<? extends GenericSnapshotControllerResourceNameElement>> snapshotElementMapping = new HashMap<Class<? extends GenericSnapshotElement>, Class<? extends GenericSnapshotControllerResourceNameElement>>();

    public static ResourceName getParentSnapshotName(ResourceName name) {
        return name.stripLastElement().stripLastElement().addElement((ResourceNameElement)new SnapshotEndTag());
    }

    public static ResourceName getSnapshotName(ResourceName name) {
        ResourceName tmpName;
        for (tmpName = name; tmpName != null && !tmpName.endsWithType((ResourceNameElement)new SnapshotEndTag()); tmpName = tmpName.stripLastElement()) {
        }
        return tmpName;
    }

    public static ResourceName asSnapshotName(ResourceName name, ControllerImpl controller) {
        ResourceNameElement[] elements = name.getElements();
        ResourceNameImpl snapshotName = new ResourceNameImpl(controller, elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            if (elements[i] instanceof SnapshotEndTag) continue;
            snapshotName = snapshotName.addElement(elements[i]);
        }
        snapshotName = snapshotName.addElement(new SnapshotEndTag());
        return snapshotName;
    }

    public static ResourceName createSnapshotName(ResourceName name, ControllerImpl controller) {
        ResourceNameElement[] elements = name.getElements();
        ResourceNameImpl snapshotName = new ResourceNameImpl(controller, elements[0]);
        boolean endSnapshotTagReached = false;
        for (int i = 1; i < elements.length; ++i) {
            if (!endSnapshotTagReached && elements[i] instanceof SnapshotEndTag) {
                endSnapshotTagReached = true;
                continue;
            }
            if (!endSnapshotTagReached) {
                snapshotName = snapshotName.addElement(elements[i]);
                continue;
            }
            if (!(elements[i] instanceof SnapshotDefiningElement)) continue;
            snapshotName = snapshotName.addElement(elements[i]);
        }
        snapshotName = snapshotName.addElement(new SnapshotEndTag());
        return snapshotName;
    }

    public static boolean isSnapshotRelated(ResourceName name) {
        ResourceNameElement[] elements = name.getElements();
        return elements[0] instanceof GenericSnapshotElement;
    }

    public static boolean isSnapshotName(ResourceName name) {
        ResourceNameElement[] elements = name.getElements();
        return elements.length >= 2 && elements[0] instanceof GenericSnapshotElement && elements[elements.length - 1] instanceof SnapshotEndTag;
    }

    public static boolean isSnapshotControllerName(ResourceName name) {
        Class<? extends GenericSnapshotControllerResourceNameElement> controllerClazz;
        ResourceNameElement[] elements = name.getElements();
        return elements.length >= 2 && (controllerClazz = snapshotElementMapping.get(elements[0].getClass())) != null && controllerClazz.equals(elements[elements.length - 1].getClass());
    }

    public static ResourceName getControllerName(Snapshot snapshot) {
        ResourceName snapshotName = snapshot.asResourceName();
        ResourceNameElement[] elements = snapshotName.getElements();
        Class<? extends GenericSnapshotControllerResourceNameElement> controllerClazz = snapshotElementMapping.get(elements[0].getClass());
        if (controllerClazz != null) {
            try {
                return snapshotName.addElement((ResourceNameElement)controllerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Trace.error((Throwable)e, () -> "Error while creating resource name element for class " + controllerClazz.getName());
            }
        }
        assert (false);
        return null;
    }

    public static void register(GenericSnapshotControllerResourceNameElement element) {
        Class<? extends GenericSnapshotElement> snapshotClazz = element.getSnapshotClass();
        assert (!snapshotElementMapping.containsKey(snapshotClazz));
        snapshotElementMapping.put(snapshotClazz, ((Object)((Object)element)).getClass());
    }

    static {
        ControllerResourceUtil.getFactory();
    }
}

