/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.ControllerImpl;
import com.sap.jvm.profiling.controller.impl.model.AbstractModelImpl;
import com.sap.jvm.profiling.controller.impl.resource.AbstractResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.OfflineResourceManagerImpl;
import com.sap.jvm.profiling.controller.impl.resource.ProfilingSessionReader;
import com.sap.jvm.profiling.controller.impl.resource.ResourceReaderImpl;
import com.sap.jvm.profiling.controller.impl.resource.ResourceStore;
import com.sap.jvm.profiling.controller.impl.resource.ViewStateStore;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotFactory;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.elements.GenericSnapshotElement;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;

public final class SnpOfflineResourceManagerImpl
extends OfflineResourceManagerImpl {
    private final ProfilingSessionReader sessionReader;
    private final boolean isSnapshotFile;

    public SnpOfflineResourceManagerImpl(String filename, boolean isSnapshotFile, ProfilingSessionReader sessionReader, ControllerImpl controller, String sessionDirectory, File tempDirectory) throws IOException {
        super(controller, sessionDirectory, tempDirectory);
        this.noResourceQueriesAllowed = true;
        this.sessionReader = sessionReader;
        this.isSnapshotFile = isSnapshotFile;
    }

    @Override
    public void init() throws IOException {
        this.sessionReader.parse();
        this.versionInfo = this.sessionReader.getVersionInfo();
        this.eventStore = this.sessionReader.getEventStore();
        this.heartBeatStore = this.sessionReader.getHeartBeatStore();
        this.alertsStore = this.sessionReader.getAlertsStore();
    }

    public long calculateLoadWork() {
        return this.sessionReader.calculateLoadWork();
    }

    public ResourceReaderImpl getHeartBeatReader() throws IOException {
        return new ResourceReaderImpl(0L, -1L, this.sessionReader.getHeartBeatStore().asDataProvider(), this.controller, null);
    }

    public ResourceReaderImpl getAlertsReader() throws IOException {
        try {
            if (this.sessionReader.getAlertsStore() == null) {
                return null;
            }
            return new ResourceReaderImpl(0L, -1L, this.sessionReader.getAlertsStore().asDataProvider(), this.controller, null);
        }
        catch (FileNotFoundException e) {
            Trace.warn(() -> "The alerts store file is not available in the workspace: " + e.getMessage());
            return null;
        }
    }

    public ResourceReaderImpl getTraceInfoReader() throws IOException {
        return new ResourceReaderImpl(0L, -1L, this.sessionReader.getTraceInfoStore().asDataProvider(), this.controller, null);
    }

    public void readMapInfo(ProgressReporter progressReporter) throws IOException {
        try (ResourceReaderImpl mapInfoReader = null;){
            mapInfoReader = new ResourceReaderImpl(0L, -1L, this.sessionReader.getMapInfoStore().asDataProvider(), this.controller, null);
            this.session.readMapInfo((PacketResourceReader)mapInfoReader, this.sessionReader.getMapMetaInfo(), progressReporter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Snapshot[] readSnapshots() throws IOException {
        ResourceStore[] stores = this.sessionReader.getSnapshotStores();
        HashSet<Snapshot> foundSnapshots = new HashSet<Snapshot>();
        SnapshotFactory snapshotFactory = SnapshotFactory.get(this.controller.getProfilingSession());
        for (int i = 0; i < stores.length; ++i) {
            ResourceReaderImpl reader = new ResourceReaderImpl(0L, -1L, stores[i].asDataProvider(), this.controller, null);
            boolean hasNext = reader.nextPacket();
            assert (hasNext);
            ResourceName name = reader.readResourceName();
            int uniqueId = reader.readInt32();
            assert (uniqueId >= 0);
            if (uniqueId >= this.nextUniqueResourceId) {
                this.nextUniqueResourceId = uniqueId + 1;
            }
            SnapshotStore store = null;
            GenericSnapshotElement snapshotElement = (GenericSnapshotElement)name.getElements()[0];
            store = ((AbstractModelImpl)this.controller.getModelController().getModel(snapshotElement.getType().getTraceType())).getSnapshotStore();
            assert (store != null);
            ProgressReporter reporter = new ProgressReporter();
            try {
                Snapshot snapshot = snapshotFactory.readSnapshot(name, (ResourceReader)reader, store, reporter);
                if (foundSnapshots.contains(snapshot)) {
                    foundSnapshots.remove(snapshot);
                }
                foundSnapshots.add(snapshot);
                this.store(name, stores[i], uniqueId);
                continue;
            }
            finally {
                reporter.finish();
                reader.close();
            }
        }
        Snapshot[] retValue = new Snapshot[foundSnapshots.size()];
        retValue = foundSnapshots.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readResources() {
        ResourceStore[] stores = this.sessionReader.getResourceStores();
        for (int i = 0; i < stores.length; ++i) {
            try (ResourceReaderImpl reader = null;){
                boolean hasNext;
                if (stores[i] == null || !(hasNext = (reader = new ResourceReaderImpl(0L, -1L, stores[i].asDataProvider(), this.controller, null)).nextPacket())) continue;
                ResourceName name = reader.readResourceName();
                int resourceId = reader.readInt32();
                AbstractResourceManagerImpl.ResourceData resourceData = (AbstractResourceManagerImpl.ResourceData)this.resourceMap.get(name);
                if (resourceData == null) {
                    assert (this.assertId(resourceId, name));
                    resourceData = new AbstractResourceManagerImpl.ResourceData();
                    resourceData.id = resourceId;
                    this.resourceMap.put(name, resourceData);
                    this.traceMap(name, "Read");
                    if (resourceId >= this.nextUniqueResourceId) {
                        this.nextUniqueResourceId = resourceId + 1;
                    }
                }
                resourceData.store = stores[i];
                continue;
            }
        }
        this.noResourceQueriesAllowed = false;
    }

    public void createViewStateStore() throws IOException {
        this.viewStateStore = new ViewStateStore(this.sessionDirectory);
    }

    public void readViewState() throws IOException {
        ResourceStore store = this.sessionReader.getViewStateStore();
        this.viewStateStore = new ViewStateStore(this.sessionDirectory, store.asDataProvider());
    }

    public void fallback() throws IOException {
        File resourceDirectory = new File(this.sessionDirectory);
        File[] resourceFiles = resourceDirectory.listFiles();
        for (int i = 0; i < resourceFiles.length; ++i) {
            if (resourceFiles[i].getName().equals("profilingData.prf")) continue;
            resourceFiles[i].delete();
        }
        if (this.isSnapshotFile) {
            this.sessionReader.parseBasics();
            this.versionInfo = this.sessionReader.getVersionInfo();
            this.eventStore = this.sessionReader.getEventStore();
            this.heartBeatStore = this.sessionReader.getHeartBeatStore();
            this.alertsStore = this.sessionReader.getAlertsStore();
        }
    }
}

