/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.resource.Task;
import com.sap.jvm.tracing.Trace;
import java.util.LinkedList;
import java.util.List;

public final class TaskManager {
    private List<Task> taskQueue = new LinkedList<Task>();
    private volatile boolean stop = false;
    private ResourceManagerWorkerThread workerThread = new ResourceManagerWorkerThread();

    public TaskManager() {
        this.workerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Task task) {
        List<Task> list = this.taskQueue;
        synchronized (list) {
            this.taskQueue.add(task);
            this.taskQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinish() {
        ResourceManagerWorkerThread resourceManagerWorkerThread = this.workerThread;
        synchronized (resourceManagerWorkerThread) {
            while (!this.workerThread.idle) {
                try {
                    this.workerThread.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stop = true;
        List<Task> list = this.taskQueue;
        synchronized (list) {
            this.taskQueue.notify();
        }
        try {
            this.workerThread.join();
        }
        catch (InterruptedException ex) {
            Trace.error((Throwable)ex, (String)"Unexpected interrupted exception during shutdown.");
        }
    }

    private class ResourceManagerWorkerThread
    extends Thread {
        volatile boolean idle;

        public ResourceManagerWorkerThread() {
            super("ResourceManagerWorkerThread");
            this.idle = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Task task = null;
                List list = TaskManager.this.taskQueue;
                synchronized (list) {
                    if (TaskManager.this.stop) {
                        break;
                    }
                    if (TaskManager.this.taskQueue.isEmpty()) {
                        ResourceManagerWorkerThread resourceManagerWorkerThread = this;
                        synchronized (resourceManagerWorkerThread) {
                            this.idle = true;
                            this.notifyAll();
                        }
                        try {
                            TaskManager.this.taskQueue.wait();
                        }
                        catch (InterruptedException ex) {
                            Trace.error((Throwable)ex, (String)"Unexpected interrupted exception during task execution.");
                        }
                    } else {
                        this.idle = false;
                        task = (Task)TaskManager.this.taskQueue.remove(0);
                    }
                }
                try {
                    if (task == null) continue;
                    task.run();
                }
                catch (Throwable ex) {
                    Trace.error((Throwable)ex, (String)"Error occurred during task execution.");
                }
            }
            ResourceManagerWorkerThread resourceManagerWorkerThread = this;
            synchronized (resourceManagerWorkerThread) {
                this.idle = true;
                this.notifyAll();
            }
        }
    }
}

