/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.resource;

import com.sap.jvm.profiling.controller.impl.resource.RandomAccessResourceFile;
import com.sap.jvm.profiling.controller.impl.resource.RandomAccessResourceFileImpl;
import com.sap.jvm.profiling.controller.impl.resource.ResourceDataProvider;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class ViewStateStore {
    public static final String VIEW_STATE_FILE = "viewState.tmp";
    private static final int NR_OF_EXPECTED_INDICES = 100;
    private static final int NR_OF_EXPECTED_CHILDREN = 5;
    private static final int PACKET_LENGTH = 12;
    private static final int HEADER_LENGTH = 5;
    private static final byte VIEW_STATE_STORE_HEADER = -1;
    private static final int VIEW_STATE_STORE_VERSION = 2;
    private RandomAccessResourceFile viewStateFile;
    private int[] ids;
    private int[] parents;
    private int[][] children;
    private boolean[] closed;
    private boolean[] valid;
    private boolean[] expand;
    private boolean[] isSnp;
    private long startOffset;

    public ViewStateStore(String directory) throws IOException {
        String filename = directory + "/" + VIEW_STATE_FILE;
        this.viewStateFile = new RandomAccessResourceFileImpl(filename);
        this.ids = new int[100];
        this.parents = new int[100];
        this.children = new int[100][];
        this.closed = new boolean[100];
        this.expand = new boolean[100];
        this.valid = new boolean[100];
        this.isSnp = new boolean[100];
        this.startOffset = this.viewStateFile.getPointer();
        this.viewStateFile.writeByte((byte)-1);
        this.viewStateFile.writeInt32(2);
    }

    public ViewStateStore(String directory, ResourceDataProvider dataProvider) throws IOException {
        this(directory);
        this.init(dataProvider);
        dataProvider.close();
    }

    public synchronized boolean isClosed(int id) {
        int index = this.getIndex(id);
        if (index > -1) {
            return this.closed[index];
        }
        return false;
    }

    public synchronized boolean isAvailable(int id) {
        int index = this.getIndex(id);
        return index > -1;
    }

    public synchronized void removeInvalidSnpEntry(int id) {
        int index = this.getIndex(id);
        assert (index > -1 && this.isSnp[index] && this.closed[index]);
        if (index > -1) {
            this.valid[index] = false;
            this.parents[index] = -1;
            this.closed[index] = true;
            this.isSnp[index] = false;
            try {
                this.viewStateFile.seek(this.startOffset + 5L + (long)(index * 12));
                this.viewStateFile.writeBoolean(this.valid[index]);
                this.viewStateFile.skip(4);
                this.viewStateFile.writeInt32(this.parents[index]);
                this.viewStateFile.writeBoolean(this.closed[index]);
                this.viewStateFile.skip(1);
                this.viewStateFile.writeBoolean(this.isSnp[index]);
            }
            catch (IOException ex) {
                Trace.error((Throwable)ex, (String)"could not update the ViewStateStore on snp remove!");
            }
        } else {
            Trace.warn(() -> "The resource ID = " + id + " is unknown by the view state store!");
        }
    }

    public synchronized void opened(int id, boolean isSnapshot) {
        if (isSnapshot) {
            // empty if block
        }
        int index = this.getIndex(id);
        boolean isNewView = false;
        boolean isValid = true;
        boolean isClosed = false;
        if (index == -1) {
            index = this.getNextFreeIndex();
            isNewView = true;
        } else if (isSnapshot && this.closed[index]) {
            isValid = false;
            isClosed = true;
        }
        if (isNewView) {
            this.parents[index] = -1;
        }
        boolean needsWrite = this.valid[index] != isValid || this.closed[index] != isClosed;
        this.valid[index] = isValid;
        this.ids[index] = id;
        this.closed[index] = isClosed;
        this.isSnp[index] = isSnapshot;
        if (isNewView || needsWrite) {
            try {
                this.viewStateFile.seek(this.startOffset + 5L + (long)(index * 12));
                this.viewStateFile.writeBoolean(isValid);
                this.viewStateFile.writeInt32(id);
                if (isNewView) {
                    this.viewStateFile.writeInt32(-1);
                } else {
                    this.viewStateFile.skip(4);
                }
                this.viewStateFile.writeBoolean(isClosed);
                this.viewStateFile.writeBoolean(this.expand[index]);
                this.viewStateFile.writeBoolean(this.isSnp[index]);
            }
            catch (IOException ex) {
                Trace.error((Throwable)ex, (String)"Could not update the ViewStateStore on open!");
            }
        }
    }

    public synchronized int getParent(int childId) {
        int childIndex = this.getIndex(childId);
        if (childIndex == -1) {
            return -1;
        }
        return this.parents[childIndex];
    }

    public synchronized void setParent(int parentId, int childId, boolean isSnapshot) {
        this.opened(childId, isSnapshot);
        int childIndex = this.getIndex(childId);
        int parentIndex = this.getIndex(parentId);
        if (this.parents[childIndex] == parentId) {
            return;
        }
        this.parents[childIndex] = parentId;
        this.insertChild(parentIndex, childId);
        long pos = this.startOffset + 5L + (long)(childIndex * 12);
        try {
            this.viewStateFile.seek(pos);
            this.viewStateFile.skip(5);
            this.viewStateFile.writeInt32(parentId);
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, () -> "Could not write parent id at " + pos);
        }
    }

    public synchronized void closed(int id) {
        int index = this.getIndex(id);
        if (index > -1) {
            this.closed[index] = true;
            if (!this.existsChildren(index)) {
                if (this.parents[index] > -1 || this.isSnp[index]) {
                    this.valid[index] = false;
                }
                this.removeChild(this.parents[index], id);
                this.parents[index] = -1;
            }
            try {
                this.viewStateFile.seek(this.startOffset + 5L + (long)(index * 12));
                this.viewStateFile.writeBoolean(this.valid[index]);
                this.viewStateFile.skip(4);
                this.viewStateFile.writeInt32(this.parents[index]);
                this.viewStateFile.writeBoolean(true);
            }
            catch (IOException ex) {
                Trace.error((Throwable)ex, (String)"could not update the ViewStateStore on close!");
            }
        } else {
            Trace.warn(() -> "The resource ID = " + id + " is unknown by the view state store!");
        }
    }

    public synchronized void expanded(int id, boolean state) {
        int index = this.getIndex(id);
        if (index > -1) {
            if (this.expand[index] != state) {
                this.expand[index] = state;
                try {
                    this.viewStateFile.seek(this.startOffset + 5L + (long)(index * 12));
                    this.viewStateFile.writeBoolean(this.valid[index]);
                    this.viewStateFile.skip(9);
                    this.viewStateFile.writeBoolean(state);
                }
                catch (IOException ex) {
                    Trace.error((Throwable)ex, (String)"could not update the ViewStateStore on expand!");
                }
            }
        } else {
            Trace.warn(() -> "The resource ID = " + id + " is unknown by the view state store!");
        }
    }

    public synchronized boolean isExpanded(int id) {
        int index = this.getIndex(id);
        if (index < 0) {
            return false;
        }
        assert (index < this.valid.length);
        return this.valid[index] && this.expand[index];
    }

    public synchronized boolean isOpen(int id) {
        int index = this.getIndex(id);
        if (index < 0) {
            return false;
        }
        assert (index < this.valid.length);
        return this.valid[index] && !this.closed[index];
    }

    public synchronized int[] getChildren(int id) {
        int index = this.getIndex(id);
        if (index < 0) {
            return new int[0];
        }
        int[] tmpChildren = this.children[index];
        int length = 0;
        if (tmpChildren != null) {
            for (int i = 0; i < tmpChildren.length; ++i) {
                if (tmpChildren[i] <= 0) continue;
                ++length;
            }
        }
        int[] retValue = new int[length];
        if (length > 0 && tmpChildren != null) {
            int j = 0;
            for (int i = 0; i < tmpChildren.length; ++i) {
                if (tmpChildren[i] <= 0) continue;
                retValue[j] = tmpChildren[i];
                ++j;
            }
        }
        return retValue;
    }

    public synchronized void writePayload(RandomAccessFile file, ProgressReporter reporter) throws IOException {
        file.writeByte(-1);
        file.writeInt(2);
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] == 0) {
                return;
            }
            file.writeBoolean(this.valid[i]);
            file.writeInt(this.ids[i]);
            file.writeInt(this.parents[i]);
            file.writeBoolean(this.closed[i]);
            file.writeBoolean(this.expand[i]);
            file.writeBoolean(this.isSnp[i]);
        }
    }

    public synchronized void close() {
        this.viewStateFile.close();
    }

    private void removeChild(int parentId, int childId) {
        if (parentId <= 0) {
            return;
        }
        int parentIndex = this.getIndex(parentId);
        assert (parentIndex >= 0);
        int[] currentChildren = this.children[parentIndex];
        assert (currentChildren != null);
        for (int i = 0; i < currentChildren.length; ++i) {
            if (currentChildren[i] != childId) continue;
            currentChildren[i] = 0;
            break;
        }
        if (this.closed[parentIndex]) {
            this.closed(parentId);
        }
    }

    private boolean existsChildren(int index) {
        int[] currentChildren = this.children[index];
        if (currentChildren != null) {
            for (int i = 0; i < currentChildren.length; ++i) {
                if (currentChildren[i] <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void append(boolean isValid, int id, int parentId, boolean closedState, boolean expandState, boolean snp) throws IOException {
        this.viewStateFile.writeBoolean(isValid);
        this.viewStateFile.writeInt32(id);
        this.viewStateFile.writeInt32(parentId);
        this.viewStateFile.writeBoolean(closedState);
        this.viewStateFile.writeBoolean(expandState);
        this.viewStateFile.writeBoolean(snp);
    }

    private void init(ResourceDataProvider dataProvider) throws IOException {
        int index = 0;
        if (!dataProvider.isEof()) {
            byte header = dataProvider.readByte();
            if (header == -1) {
                int ver = dataProvider.readInt();
                while (!dataProvider.isEof()) {
                    boolean snp;
                    boolean isValid = dataProvider.readBoolean();
                    int id = dataProvider.readInt();
                    int parentId = dataProvider.readInt();
                    boolean closedState = dataProvider.readBoolean();
                    boolean expandState = dataProvider.readBoolean();
                    boolean bl = snp = ver == 2 ? dataProvider.readBoolean() : false;
                    if (!isValid && !snp) continue;
                    this.resize(index);
                    this.ids[index] = id;
                    this.valid[index] = isValid;
                    this.closed[index] = closedState;
                    this.expand[index] = expandState;
                    this.isSnp[index] = snp;
                    this.parents[index] = isValid ? parentId : -1;
                    ++index;
                }
            } else {
                this.valid[index] = header != 0;
                this.ids[index] = dataProvider.readInt();
                this.parents[index] = dataProvider.readInt();
                this.closed[index] = dataProvider.readBoolean();
                ++index;
                while (!dataProvider.isEof()) {
                    boolean isValid = dataProvider.readBoolean();
                    int id = dataProvider.readInt();
                    int parentId = dataProvider.readInt();
                    boolean closedState = dataProvider.readBoolean();
                    if (isValid) {
                        this.resize(index);
                        this.ids[index] = id;
                        this.parents[index] = parentId;
                        this.valid[index] = true;
                        this.closed[index] = closedState;
                    }
                    ++index;
                }
            }
            this.viewStateFile.seek(0L);
            this.viewStateFile.clear();
            this.viewStateFile.writeByte((byte)-1);
            this.viewStateFile.writeInt32(2);
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] == 0) {
                    return;
                }
                if (this.valid[i]) {
                    this.insertChild(this.getIndex(this.parents[i]), this.ids[i]);
                }
                this.append(this.valid[i], this.ids[i], this.parents[i], this.closed[i], this.expand[i], this.isSnp[i]);
            }
        }
    }

    private void insertChild(int parentIndex, int childId) {
        if (parentIndex < 0) {
            return;
        }
        int[] tmpChildren = this.children[parentIndex];
        if (tmpChildren == null) {
            tmpChildren = new int[5];
            this.children[parentIndex] = tmpChildren;
        }
        int freeIndex = -1;
        for (int i = 0; i < tmpChildren.length; ++i) {
            if (tmpChildren[i] <= 0) {
                freeIndex = i;
            }
            if (tmpChildren[i] != childId) continue;
            return;
        }
        if (freeIndex >= 0) {
            tmpChildren[freeIndex] = childId;
            return;
        }
        int newTmpChildrenSize = tmpChildren.length * 2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : tmpChildren.length * 2;
        int[] newTmpChildren = new int[newTmpChildrenSize];
        System.arraycopy(tmpChildren, 0, newTmpChildren, 0, tmpChildren.length);
        this.children[parentIndex] = newTmpChildren;
        newTmpChildren[tmpChildren.length] = childId;
    }

    private void resize(int index) {
        if (index >= this.valid.length) {
            int newIndexSize = this.valid.length * 2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.valid.length * 2;
            boolean[] newValid = new boolean[newIndexSize];
            System.arraycopy(this.valid, 0, newValid, 0, this.valid.length);
            int[] newIds = new int[newIndexSize];
            System.arraycopy(this.ids, 0, newIds, 0, this.valid.length);
            int[] newParents = new int[newIndexSize];
            System.arraycopy(this.parents, 0, newParents, 0, this.valid.length);
            boolean[] newClosed = new boolean[newIndexSize];
            System.arraycopy(this.closed, 0, newClosed, 0, this.valid.length);
            boolean[] newExpand = new boolean[newIndexSize];
            System.arraycopy(this.expand, 0, newExpand, 0, this.valid.length);
            boolean[] newIsSnp = new boolean[newIndexSize];
            System.arraycopy(this.isSnp, 0, newIsSnp, 0, this.valid.length);
            int[][] newChildren = new int[newIndexSize][];
            for (int i = 0; i < this.valid.length; ++i) {
                newChildren[i] = this.children[i];
            }
            this.valid = newValid;
            this.ids = newIds;
            this.parents = newParents;
            this.children = newChildren;
            this.closed = newClosed;
            this.expand = newExpand;
            this.isSnp = newIsSnp;
        }
    }

    private int getNextFreeIndex() {
        for (int i = 0; i < this.valid.length; ++i) {
            if (this.valid[i] || this.isSnp[i]) continue;
            return i;
        }
        int freeSlot = this.valid.length;
        this.resize(freeSlot);
        return freeSlot;
    }

    private int getIndex(int id) {
        if (id < 0) {
            return -1;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i] != id) continue;
            return i;
        }
        return -1;
    }
}

