/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.AllocationTrace;
import com.sap.jvm.profiling.controller.trace.AllocationTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.List;

public final class AllocationTraceImpl
extends ProfilingTraceImpl
implements AllocationTrace {
    private static int VERSION = 2;
    private AllocationTraceSpec spec;
    private long nrOfAllocations;
    private long nrOfAllocatedBytes;

    public static AllocationTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        long nrOfAllocations = reader.readInt64();
        long nrOfAllocatedBytes = reader.readInt64();
        boolean isAdaptive = reader.readBoolean();
        boolean isIncludingLineNrs = reader.readBoolean();
        String threadFilterString = reader.readString();
        String classFilter = "";
        boolean isIncludingIds = false;
        boolean supportsJRuby = false;
        int version = AllocationTraceImpl.readVersion(reader, 0, VERSION);
        if (version >= 0) {
            classFilter = reader.readString();
        }
        if (version > 0) {
            isIncludingIds = reader.readBoolean();
        }
        if (version > 1) {
            supportsJRuby = reader.readBoolean();
        }
        AllocationTraceSpec spec = new AllocationTraceSpec();
        spec.setIsAdaptive(isAdaptive && !isIncludingIds);
        spec.setIncludeLineNrs(isIncludingLineNrs);
        spec.setSupportsJRuby(supportsJRuby);
        if (ProfilingTraceSpec.isFiltering(threadFilterString)) {
            spec.setThreadFilter(new ThreadFilter(threadFilterString));
        }
        spec.setClassFilter(classFilter);
        spec.setIncludeIds(isIncludingIds);
        AllocationTraceImpl retValue = new AllocationTraceImpl(name, spec, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setNrOfAllocations(nrOfAllocations);
        retValue.setNrOfAllocatedBytes(nrOfAllocatedBytes);
        retValue.setTraceState(state);
        return retValue;
    }

    public AllocationTraceImpl(String name, AllocationTraceSpec spec, ProfilingSession session) {
        super(name, session);
        this.spec = spec;
    }

    @Override
    public long getNrOfAllocatedBytes() {
        return this.nrOfAllocatedBytes;
    }

    @Override
    public long getNrOfAllocations() {
        return this.nrOfAllocations;
    }

    @Override
    public AllocationTraceSpec getSpecification() {
        return this.spec;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.ALLOCATION_TRACE;
    }

    public void setNrOfAllocations(long nrOfAllocations) {
        this.nrOfAllocations = nrOfAllocations;
    }

    public void setNrOfAllocatedBytes(long nrOfAllocatedBytes) {
        this.nrOfAllocatedBytes = nrOfAllocatedBytes;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfAllocations);
        writer.writeInt64(this.nrOfAllocatedBytes);
        writer.writeBoolean(this.spec.isAdaptive());
        writer.writeBoolean(this.spec.isIncludingLineNrs());
        writer.writeString(this.spec.getThreadFilter() == null ? "**" : this.spec.getThreadFilter().asString());
        AllocationTraceImpl.writeVersion(writer, VERSION);
        writer.writeString(this.spec.getClassFilter());
        writer.writeBoolean(this.spec.isIncludingIds());
        writer.writeBoolean(this.spec.supportsJRuby());
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        AllocationTraceConfiguration configuration = new AllocationTraceConfiguration(this.spec.isAdaptive() ? AllocationTraceType.ADAPTIVE : (this.spec.isIncludingIds() ? AllocationTraceType.WITH_OBJECT_IDS : AllocationTraceType.NO_OBJECT_IDS));
        configuration.setAllowMultiEvents(true);
        configuration.setAllowPacketReordering(true);
        configuration.setIncludeLineNrs(this.spec.isIncludingLineNrs());
        configuration.setAllocatedObjectClassFilter(this.spec.getClassFilter());
        configuration.setAllocatedObjectThreadFilter(this.spec.getThreadFilter());
        List<RequestedMethodParameter> params = this.spec.getRequestedMethodParameters();
        configuration.setSupportsJRuby(this.spec.supportsJRuby());
        MemoryCommandFactory factory = provider.getMemoryFactory();
        Object cmd = params == null ? (this.spec.isAdaptive() ? factory.createEnableAdaptiveAllocationTraceCommand(configuration) : factory.createEnableAllocationTraceCommand(configuration)) : (this.spec.isAdaptive() ? factory.createEnableAdaptiveAllocationMptTraceCommand(configuration, params, true, true, true, false) : factory.createEnableAllocationMptTraceCommand(configuration, params, true, true, true, false));
        return handler.sendCommand((Command)cmd, true);
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        Object cmd = this.getSpecification().getRequestedMethodParameters() != null ? provider.getMemoryFactory().createDisableAllocationMptTraceCommand() : provider.getMemoryFactory().createDisableAllocationTraceCommand();
        return handler.sendCommand((Command)cmd, true);
    }
}

