/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.DumpClassStatisticTrace;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class DumpClassStatisticTraceImpl
extends ProfilingTraceImpl
implements DumpClassStatisticTrace {
    private static int VERSION = 1;
    private boolean forceGc;

    public static DumpClassStatisticTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        int version = reader.readVersion(0, VERSION);
        boolean forcedGc = true;
        if (version > 0) {
            forcedGc = reader.readBoolean();
        }
        DumpClassStatisticTraceImpl retValue = new DumpClassStatisticTraceImpl(name, forcedGc, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setTraceState(state);
        return retValue;
    }

    public DumpClassStatisticTraceImpl(String name, boolean forceGc, ProfilingSession session) {
        super(name, session);
        this.forceGc = forceGc;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.CLASS_STATISTIC_TRACE;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(VERSION);
        writer.writeBoolean(this.forceGc);
    }

    @Override
    public ProfilingTraceSpec getSpecification() {
        return null;
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean forcedGc() {
        return this.forceGc;
    }
}

