/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.GcHistoryFileDumpTrace;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class GcHistoryFileDumpTraceImpl
extends ProfilingTraceImpl
implements GcHistoryFileDumpTrace {
    private static int VERSION = 0;

    public static GcHistoryFileDumpTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        reader.readVersion(VERSION);
        GcHistoryFileDumpTraceImpl retValue = new GcHistoryFileDumpTraceImpl(name, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setTraceState(state);
        return retValue;
    }

    public GcHistoryFileDumpTraceImpl(String name, ProfilingSession session) {
        super(name, session);
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.GC_HISTORY_FILE_DUMP;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(VERSION);
    }

    @Override
    public ProfilingTraceSpec getSpecification() {
        return null;
    }

    public Command createDisableComand(CommandFactoryProvider provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        throw new UnsupportedOperationException();
    }
}

