/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.GcTrace;
import com.sap.jvm.profiling.controller.trace.GcTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class GcTraceImpl
extends ProfilingTraceImpl
implements GcTrace {
    private GcTraceSpec spec;
    private long durationFull;
    private long durationYoung;
    private long durationConc;
    private long maxDurationFull;
    private long maxDurationYoung;
    private long maxDurationConc;
    private long nrGcsFull;
    private long nrGcsYoung;
    private long nrGcsConc;

    public static GcTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        long durationFull = reader.readInt64();
        long durationYoung = reader.readInt64();
        long durationConc = reader.readInt64();
        long maxDurationFull = reader.readInt64();
        long maxDurationYoung = reader.readInt64();
        long maxDurationConc = reader.readInt64();
        long nrOfGcsFull = reader.readInt64();
        long nrOfGcsYoung = reader.readInt64();
        long nrOfGcsConc = reader.readInt64();
        GcTraceSpec spec = new GcTraceSpec();
        GcTraceImpl retValue = new GcTraceImpl(name, spec, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setDurationFull(durationFull);
        retValue.setDurationYoung(durationYoung);
        retValue.setDurationConc(durationConc);
        retValue.setMaxDurationFull(maxDurationFull);
        retValue.setMaxDurationYoung(maxDurationYoung);
        retValue.setMaxDurationConc(maxDurationConc);
        retValue.setNrGcsFull(nrOfGcsFull);
        retValue.setNrGcsYoung(nrOfGcsYoung);
        retValue.setNrGcsConc(nrOfGcsConc);
        retValue.setTraceState(state);
        return retValue;
    }

    public GcTraceImpl(String name, GcTraceSpec spec, ProfilingSession session) {
        super(name, session);
        this.spec = spec;
    }

    @Override
    public GcTraceSpec getSpecification() {
        return this.spec;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.GC_TRACE;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.durationFull);
        writer.writeInt64(this.durationYoung);
        writer.writeInt64(this.durationConc);
        writer.writeInt64(this.maxDurationFull);
        writer.writeInt64(this.maxDurationYoung);
        writer.writeInt64(this.maxDurationConc);
        writer.writeInt64(this.nrGcsFull);
        writer.writeInt64(this.nrGcsYoung);
        writer.writeInt64(this.nrGcsConc);
    }

    @Override
    public long getDurationTotal() {
        return this.durationFull + this.durationYoung + this.durationConc;
    }

    @Override
    public long getDurationFull() {
        return this.durationFull;
    }

    @Override
    public long getDurationYoung() {
        return this.durationYoung;
    }

    @Override
    public long getDurationConc() {
        return this.durationConc;
    }

    @Override
    public long getMaxDuration() {
        return Math.max(this.maxDurationFull, Math.max(this.maxDurationYoung, this.maxDurationConc));
    }

    @Override
    public long getMaxDurationFull() {
        return this.maxDurationFull;
    }

    @Override
    public long getMaxDurationYoung() {
        return this.maxDurationYoung;
    }

    @Override
    public long getMaxDurationConc() {
        return this.maxDurationConc;
    }

    @Override
    public long getNrOfGcsTotal() {
        return this.nrGcsFull + this.nrGcsYoung + this.nrGcsConc;
    }

    @Override
    public long getNrOfGcsFull() {
        return this.nrGcsFull;
    }

    @Override
    public long getNrOfGcsYoung() {
        return this.nrGcsYoung;
    }

    @Override
    public long getNrOfGcsConc() {
        return this.nrGcsConc;
    }

    public void setDurationFull(long durationFull) {
        this.durationFull = durationFull;
    }

    public void setDurationYoung(long durationYoung) {
        this.durationYoung = durationYoung;
    }

    public void setDurationConc(long durationConc) {
        this.durationConc = durationConc;
    }

    public void setMaxDurationFull(long maxDurationFull) {
        this.maxDurationFull = maxDurationFull;
    }

    public void setMaxDurationYoung(long maxDurationYoung) {
        this.maxDurationYoung = maxDurationYoung;
    }

    public void setMaxDurationConc(long maxDurationConc) {
        this.maxDurationConc = maxDurationConc;
    }

    public void setNrGcsFull(long nrGcsFull) {
        this.nrGcsFull = nrGcsFull;
    }

    public void setNrGcsYoung(long nrGcsYoung) {
        this.nrGcsYoung = nrGcsYoung;
    }

    public void setNrGcsConc(long nrGcsConc) {
        this.nrGcsConc = nrGcsConc;
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        return handler.sendCommand((Command)provider.getMemoryFactory().createEnableGcStatisticCommand(true), true);
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        return handler.sendCommand((Command)provider.getMemoryFactory().createDisableGcStatisticCommand(), true);
    }
}

