/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.HprofDumpTrace;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpProperties;
import java.io.IOException;

public class HprofDumpTraceImpl
extends ProfilingTraceImpl
implements HprofDumpTrace {
    private static int VERSION = 0;
    private HprofDumpProperties properties;
    private boolean forceGc;

    public static HprofDumpTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        reader.readVersion(VERSION);
        HprofDumpProperties properties = new HprofDumpProperties(reader);
        HprofDumpTraceImpl retValue = new HprofDumpTraceImpl(name, properties, properties.forceGcRequested(), reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setTraceState(state);
        return retValue;
    }

    public HprofDumpTraceImpl(String name, HprofDumpProperties properties, boolean forceGc, ProfilingSession session) {
        super(name, session);
        this.properties = properties;
        this.forceGc = forceGc;
    }

    @Override
    public HprofDumpProperties getProperties() {
        return this.properties;
    }

    public void setProperties(HprofDumpProperties properties) {
        this.properties = properties;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.HPROF_DUMP;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(VERSION);
        this.properties.write(writer);
    }

    @Override
    public ProfilingTraceSpec getSpecification() {
        return null;
    }

    @Override
    public boolean forcedGc() {
        return this.forceGc;
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        throw new UnsupportedOperationException();
    }
}

