/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.MethodParameterTrace;
import com.sap.jvm.profiling.controller.trace.MethodParameterTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.method.command.DisableMethodParameterTraceCommand;
import com.sap.jvm.profiling.method.command.EnableMethodParameterTraceCommand;
import com.sap.jvm.profiling.method.event.MethodParameterApplyErrorEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParameterEventHandler;
import com.sap.jvm.profiling.method.event.MethodParameterExitEvent;
import com.sap.jvm.profiling.method.event.MethodParameterNearMissEvent;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.response.DisableMethodParameterTraceResponse;
import com.sap.jvm.profiling.method.response.EnableMethodParameterTraceResponse;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class MethodParameterTraceImpl
extends ProfilingTraceImpl
implements MethodParameterTrace {
    private final MethodParameterTraceSpec spec;
    private long nrOfInvocations;

    public static MethodParameterTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        long nrOfInvocations = reader.readInt64();
        MethodParameterTraceImpl retValue = new MethodParameterTraceImpl(name, MethodParameterTraceSpec.read(reader), reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setNrOfInvocations(nrOfInvocations);
        retValue.setTraceState(state);
        return retValue;
    }

    public MethodParameterTraceImpl(String name, MethodParameterTraceSpec spec, ProfilingSession session) {
        super(name, session);
        this.spec = spec;
    }

    @Override
    public MethodParameterTraceSpec getSpecification() {
        return this.spec;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.METHOD_PARAMETER_TRACE;
    }

    @Override
    public long getNrOfInvocations() {
        return this.nrOfInvocations;
    }

    public void setNrOfInvocations(long nrOfInvocations) {
        this.nrOfInvocations = nrOfInvocations;
    }

    @Override
    public List<MethodParameterApplyErrorEvent> getApplyErrors() {
        LinkedList<MethodParameterApplyErrorEvent> retValue = new LinkedList<MethodParameterApplyErrorEvent>();
        this.getErrors(retValue, null);
        return retValue;
    }

    @Override
    public List<MethodParameterNearMissEvent> getNearMisses() {
        LinkedList<MethodParameterNearMissEvent> retValue = new LinkedList<MethodParameterNearMissEvent>();
        this.getErrors(null, retValue);
        return retValue;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfInvocations);
        this.spec.write(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getErrors(List<MethodParameterApplyErrorEvent> applyErrorList, List<MethodParameterNearMissEvent> nearMissList) {
        if (this.startBookmark == null) {
            return;
        }
        Bookmark tmpEndBookmark = this.endBookmark == null ? this.session.getReader().createBookmark() : this.endBookmark;
        ProgressReporter reporter = new ProgressReporter();
        try {
            ProfilingReader reader = this.session.getResourceManager().getEventReader(this.startBookmark, tmpEndBookmark, null, reporter);
            MptEventHandler handler = new MptEventHandler(applyErrorList, nearMissList);
            reader.registerMethodParameterEventHandler((MethodParameterEventHandler)handler);
            try {
                while (reader.nextPacket() != null) {
                }
            }
            catch (IOException ex) {
                Trace.warn((Throwable)ex, (String)"Error during reading trace events.");
            }
            finally {
                reader.close();
            }
        }
        catch (OperationCanceledException e) {
            return;
        }
        finally {
            reporter.finish();
        }
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        EnableMethodParameterTraceCommand cmd = provider.getMethodFactory().createEnableMethodParameterTraceCommand(this.spec.getRequestedParameters(), this.spec.includeTimeStamp(), this.spec.includeCpuTime(), this.spec.includeStackTrace(), false);
        return handler.sendCommand((Command)cmd, true);
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        DisableMethodParameterTraceCommand cmd = provider.getMethodFactory().createDisableMethodParameterTraceCommand();
        return handler.sendCommand((Command)cmd, true);
    }

    private class MptEventHandler
    implements MethodParameterEventHandler {
        private List<MethodParameterApplyErrorEvent> applyErrorList;
        private List<MethodParameterNearMissEvent> nearMissList;

        public MptEventHandler(List<MethodParameterApplyErrorEvent> applyErrorList, List<MethodParameterNearMissEvent> nearMissList) {
            this.applyErrorList = applyErrorList;
            this.nearMissList = nearMissList;
        }

        public void handle(DisableMethodParameterTraceResponse response) {
        }

        public void handle(EnableMethodParameterTraceResponse response) {
        }

        public void handle(MethodParameterApplyErrorEvent event) {
            if (this.applyErrorList != null) {
                this.applyErrorList.add(event);
            }
        }

        public void handle(MethodParameterEntryEvent event) {
        }

        public void handle(MethodParameterExitEvent event) {
        }

        public void handle(MethodParameterNearMissEvent event) {
            if (this.nearMissList != null) {
                this.nearMissList.add(event);
            }
        }

        public boolean providesReturnValuesInEntryEvents() {
            return false;
        }

        public ArrayList<Parameter> getReturnValuesForEntryEvent(MethodParameterEntryEvent event) {
            assert (false);
            return null;
        }
    }
}

