/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.MethodTrace;
import com.sap.jvm.profiling.controller.trace.MethodTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class MethodTraceImpl
extends ProfilingTraceImpl
implements MethodTrace {
    private MethodTraceSpec spec;
    private long nrOfInvocations;

    public static MethodTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        long nrOfInvocations = reader.readInt64();
        String threadFilterString = reader.readString();
        MethodTraceSpec spec = new MethodTraceSpec();
        if (ProfilingTraceSpec.isFiltering(threadFilterString)) {
            spec.setThreadFilter(new ThreadFilter(threadFilterString));
        }
        MethodTraceImpl retValue = new MethodTraceImpl(name, spec, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setNrOfInvocations(nrOfInvocations);
        retValue.setTraceState(state);
        return retValue;
    }

    public MethodTraceImpl(String name, MethodTraceSpec spec, ProfilingSession session) {
        super(name, session);
        this.spec = spec;
    }

    @Override
    public long getNrOfInvocations() {
        return this.nrOfInvocations;
    }

    @Override
    public MethodTraceSpec getSpecification() {
        return this.spec;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.METHOD_TRACE;
    }

    public void setNrOfInvocations(long nrOfInvocations) {
        this.nrOfInvocations = nrOfInvocations;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfInvocations);
        writer.writeString(this.spec.getThreadFilter() == null ? "**" : this.spec.getThreadFilter().asString());
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        return handler.sendCommand((Command)provider.getMethodFactory().createEnableMethodTraceCommand(), true);
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        return handler.sendCommand((Command)provider.getMethodFactory().createDisableMethodTraceCommand(), true);
    }
}

