/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.NetworkTrace;
import com.sap.jvm.profiling.controller.trace.NetworkTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.net.command.EnableNetworkTraceCommand;
import com.sap.jvm.profiling.net.command.NetworkTraceConfiguration;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class NetworkTraceImpl
extends ProfilingTraceImpl
implements NetworkTrace {
    private NetworkTraceSpec spec;
    private long nrOfReadBytes;
    private long nrOfWrittenBytes;
    private long readDuration;
    private long writeDuration;

    public static NetworkTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        long nrOfReadBytes = reader.readInt64();
        long nrOfWrittenBytes = reader.readInt64();
        long readDuration = reader.readInt64();
        long writeDuration = reader.readInt64();
        String threadFilterString = reader.readString();
        NetworkTraceSpec spec = new NetworkTraceSpec();
        if (ProfilingTraceSpec.isFiltering(threadFilterString)) {
            spec.setThreadFilter(new ThreadFilter(threadFilterString));
        }
        NetworkTraceImpl retValue = new NetworkTraceImpl(name, spec, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setNrOfReadBytes(nrOfReadBytes);
        retValue.setNrOfWrittenBytes(nrOfWrittenBytes);
        retValue.setReadDuration(readDuration);
        retValue.setWriteDuration(writeDuration);
        retValue.setTraceState(state);
        return retValue;
    }

    public NetworkTraceImpl(String name, NetworkTraceSpec spec, ProfilingSession session) {
        super(name, session);
        this.spec = spec;
    }

    @Override
    public long getNrOfTransferredBytes() {
        return this.nrOfReadBytes + this.nrOfWrittenBytes;
    }

    @Override
    public long getNrOfReadBytes() {
        return this.nrOfReadBytes;
    }

    @Override
    public long getNrOfWrittenBytes() {
        return this.nrOfWrittenBytes;
    }

    @Override
    public long getDuration() {
        return this.readDuration + this.writeDuration;
    }

    @Override
    public long getReadDuration() {
        return this.readDuration;
    }

    @Override
    public long getWriteDuration() {
        return this.writeDuration;
    }

    @Override
    public NetworkTraceSpec getSpecification() {
        return this.spec;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.NETWORK_TRACE;
    }

    public void setReadDuration(long readDuration) {
        this.readDuration = readDuration;
    }

    public void setWriteDuration(long writeDuration) {
        this.writeDuration = writeDuration;
    }

    public void setNrOfReadBytes(long nrOfReadBytes) {
        this.nrOfReadBytes = nrOfReadBytes;
    }

    public void setNrOfWrittenBytes(long nrOfWrittenBytes) {
        this.nrOfWrittenBytes = nrOfWrittenBytes;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfReadBytes);
        writer.writeInt64(this.nrOfWrittenBytes);
        writer.writeInt64(this.readDuration);
        writer.writeInt64(this.writeDuration);
        writer.writeString(this.spec.getThreadFilter() == null ? "**" : this.spec.getThreadFilter().asString());
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        NetworkTraceConfiguration config = new NetworkTraceConfiguration();
        config.setThreadFilter(this.spec.getThreadFilter());
        config.setResolveAllHosts(this.spec.isResolveAllHosts());
        EnableNetworkTraceCommand cmd = provider.getNetworkFactory().createEnableNetworkTraceCommand(config);
        return handler.sendCommand((Command)cmd, true);
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        return handler.sendCommand((Command)provider.getNetworkFactory().createDisableNetworkTraceCommand(), true);
    }
}

