/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.controller.impl.trace;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.action.CommandFactoryProvider;
import com.sap.jvm.profiling.controller.impl.RemoteConnectionHandler;
import com.sap.jvm.profiling.controller.impl.trace.ProfilingTraceImpl;
import com.sap.jvm.profiling.controller.trace.PerformanceHotspotTrace;
import com.sap.jvm.profiling.controller.trace.PerformanceHotspotTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceSpec;
import com.sap.jvm.profiling.controller.trace.ProfilingTraceState;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.util.List;

public final class PerformanceHotspotTraceImpl
extends ProfilingTraceImpl
implements PerformanceHotspotTrace {
    private static int VERSION = 0;
    private final PerformanceHotspotTraceSpec spec;
    private long nrOfSamples;
    private long sampleTime;
    private double interpretedFraction;

    public static PerformanceHotspotTraceImpl read(ResourceReader reader) throws IOException {
        Bookmark startBookmark = reader.getSession().readBookmark(reader);
        boolean endBookmarkAvail = reader.readBoolean();
        Bookmark endBookmark = null;
        if (endBookmarkAvail) {
            endBookmark = reader.getSession().readBookmark(reader);
        }
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        ProfilingTraceState state = reader.readBoolean() ? ProfilingTraceState.ENABLED : ProfilingTraceState.DISABLED;
        String name = reader.readString();
        long nrOfSamples = reader.readInt64();
        long sampleTime = reader.readInt64();
        boolean isIgnoringSleepingThreads = reader.readBoolean();
        String userFilter = reader.readString();
        int version = PerformanceHotspotTraceImpl.readVersion(reader, 0, VERSION);
        double interpretedFraction = -1.0;
        if (version >= 0) {
            interpretedFraction = reader.readDouble();
        }
        PerformanceHotspotTraceSpec spec = new PerformanceHotspotTraceSpec();
        spec.ignoreSleepingThreads();
        spec.setUserFilter("**");
        if (!isIgnoringSleepingThreads) {
            spec.reportSleepingThreads();
        }
        if (ProfilingTraceSpec.isFiltering(userFilter)) {
            spec.setUserFilter(userFilter);
        }
        PerformanceHotspotTraceImpl retValue = new PerformanceHotspotTraceImpl(name, spec, reader.getSession());
        retValue.setStartBookmark(startBookmark);
        retValue.setEndBookmark(endBookmark);
        retValue.setStartTimeStamp(startTimestamp);
        retValue.setEndTimeStamp(endTimestamp);
        retValue.setNrOfSamples(nrOfSamples);
        retValue.setSampleTime(sampleTime);
        retValue.setTraceState(state);
        retValue.interpretedFraction = interpretedFraction;
        return retValue;
    }

    public PerformanceHotspotTraceImpl(String name, PerformanceHotspotTraceSpec spec, ProfilingSession session) {
        super(name, session);
        this.spec = spec;
        this.interpretedFraction = -1.0;
    }

    @Override
    public PerformanceHotspotTraceSpec getSpecification() {
        return this.spec;
    }

    @Override
    public ProfilingTraceType getType() {
        return ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE;
    }

    @Override
    public long getNrOfSamples() {
        return this.nrOfSamples;
    }

    @Override
    public long getSampleTime() {
        return this.sampleTime;
    }

    @Override
    public double getInterpretedFraction() {
        return this.interpretedFraction;
    }

    public void setInterpretedFraction(double frac) {
        this.interpretedFraction = frac;
    }

    public void setNrOfSamples(long nrOfSamples) {
        this.nrOfSamples = nrOfSamples;
    }

    public void setSampleTime(long sampleTime) {
        this.sampleTime = sampleTime;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.nrOfSamples);
        writer.writeInt64(this.sampleTime);
        writer.writeBoolean(this.spec.isIgnoringSleepingThreads());
        writer.writeString(this.spec.getUserFilter());
        PerformanceHotspotTraceImpl.writeVersion(writer, VERSION);
        writer.writeDouble(this.interpretedFraction);
    }

    @Override
    public Response enable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        List<RequestedMethodParameter> params = this.spec.getRequestedMethodParameters();
        Object cmd = params != null ? provider.getMethodFactory().createEnableTimeBasedSamplingMptCommand(-1, this.spec.isIgnoringSleepingThreads(), this.spec.getThreadFilter(), this.spec.getSmooth(), params, true, true, true, false) : provider.getMethodFactory().createEnableTimeBasedSamplingCommand(-1, this.spec.isIgnoringSleepingThreads(), this.spec.getThreadFilter(), this.spec.getSmooth());
        return handler.sendCommand((Command)cmd, true);
    }

    @Override
    public Response disable(RemoteConnectionHandler handler, CommandFactoryProvider provider) {
        Object cmd = this.getSpecification().getRequestedMethodParameters() != null ? provider.getMethodFactory().createDisableTimeBasedSamplingMptCommand() : provider.getMethodFactory().createDisableTimeBasedSamplingCommand();
        return handler.sendCommand((Command)cmd, true);
    }
}

